package com.payu.paymentparamhelper;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;

public class SiConvenienceFeeData implements Parcelable {
    private String billingAmount;
    private List<ConvenienceFeeCharges> chargeUUIDs;
    private String requestUUID;
    private String combinationUUID;

    public SiConvenienceFeeData() {
    }

    public SiConvenienceFeeData(String billingAmount, List<ConvenienceFeeCharges> chargeUUIDs, String requestUUID, String combinationUUID) {
        this.billingAmount = billingAmount;
        this.chargeUUIDs = chargeUUIDs;
        this.requestUUID = requestUUID;
        this.combinationUUID = combinationUUID;
    }

    protected SiConvenienceFeeData(Parcel in) {
        billingAmount = in.readString();
        chargeUUIDs = in.createTypedArrayList(ConvenienceFeeCharges.CREATOR);
        requestUUID = in.readString();
        combinationUUID = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(billingAmount);
        dest.writeTypedList(chargeUUIDs);
        dest.writeString(requestUUID);
        dest.writeString(combinationUUID);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<SiConvenienceFeeData> CREATOR = new Creator<SiConvenienceFeeData>() {
        @Override
        public SiConvenienceFeeData createFromParcel(Parcel in) {
            return new SiConvenienceFeeData(in);
        }

        @Override
        public SiConvenienceFeeData[] newArray(int size) {
            return new SiConvenienceFeeData[size];
        }
    };

    public String getBillingAmount() {
        return billingAmount;
    }

    public void setBillingAmount(String billingAmount) {
        this.billingAmount = billingAmount;
    }

    public List<ConvenienceFeeCharges> getChargeUUIDs() {
        return chargeUUIDs;
    }

    public void setChargeUUIDs(List<ConvenienceFeeCharges> chargeUUIDs) {
        this.chargeUUIDs = chargeUUIDs;
    }

    public String getRequestUUID() {
        return requestUUID;
    }

    public void setRequestUUID(String requestUUID) {
        this.requestUUID = requestUUID;
    }

    public String getCombinationUUID() {
        return combinationUUID;
    }

    public void setCombinationUUID(String combinationUUID) {
        this.combinationUUID = combinationUUID;
    }
}