package com.payu.paymentparamhelper.siparams;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.paymentparamhelper.siparams.enums.BillingCycle;

public class SIParamsDetails implements Parcelable {
    private BillingCycle billingCycle;
    private int billingInterval;
    private String billingAmount;
    private String billingCurrency = "INR";
    private String paymentStartDate;
    private String paymentEndDate;
    private String remarks;


    public void setBillingCurrency(String billingCurrency) {
        this.billingCurrency = billingCurrency;
    }

    public SIParamsDetails() {
    }

    protected SIParamsDetails(Parcel in) {
        billingInterval = in.readInt();
        billingAmount = in.readString();
        billingCurrency = in.readString();
        paymentStartDate = in.readString();
        paymentEndDate = in.readString();
        remarks = in.readString();
        billingCycle = BillingCycle.valueOf(in.readString());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(billingInterval);
        dest.writeString(billingAmount);
        dest.writeString(billingCurrency);
        dest.writeString(paymentStartDate);
        dest.writeString(paymentEndDate);
        dest.writeString(remarks);
        dest.writeString(billingCycle.name());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<SIParamsDetails> CREATOR = new Creator<SIParamsDetails>() {
        @Override
        public SIParamsDetails createFromParcel(Parcel in) {
            return new SIParamsDetails(in);
        }

        @Override
        public SIParamsDetails[] newArray(int size) {
            return new SIParamsDetails[size];
        }
    };

    public BillingCycle getBillingCycle() {
        return billingCycle;
    }

    public void setBillingCycle(BillingCycle billingCycle) {
        this.billingCycle = billingCycle;
    }

    public int getBillingInterval() {
        return billingInterval;
    }

    public void setBillingInterval(int billingInterval) {
        this.billingInterval = billingInterval;
    }

    public String getBillingAmount() {
        return billingAmount;
    }

    public void setBillingAmount(String billingAmount) {
        this.billingAmount = billingAmount;
    }

    public String getBillingCurrency() {
        return billingCurrency;
    }

    public String getPaymentStartDate() {
        return paymentStartDate;
    }

    public void setPaymentStartDate(String paymentStartDate) {
        this.paymentStartDate = paymentStartDate;
    }

    public String getPaymentEndDate() {
        return paymentEndDate;
    }

    public void setPaymentEndDate(String paymentEndDate) {
        this.paymentEndDate = paymentEndDate;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}
