package com.payu.paymentparamhelper.siparams;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.paymentparamhelper.siparams.enums.BeneficiaryAccountType;

public class BeneficiaryDetails implements Parcelable {
    private String beneficiaryName;
    private String beneficiaryAccountNumber;
    private BeneficiaryAccountType beneficiaryAccountType;

    public BeneficiaryDetails() {
    }

    public BeneficiaryDetails(String beneficiaryName, String beneficiaryAccountNumber, BeneficiaryAccountType beneficiaryAccountType) {
        this.beneficiaryName = beneficiaryName;
        this.beneficiaryAccountNumber = beneficiaryAccountNumber;
        this.beneficiaryAccountType = beneficiaryAccountType;
    }

    protected BeneficiaryDetails(Parcel in) {
        beneficiaryName = in.readString();
        beneficiaryAccountNumber = in.readString();
        beneficiaryAccountType = BeneficiaryAccountType.valueOf(in.readString());
    }

    public static final Creator<BeneficiaryDetails> CREATOR = new Creator<BeneficiaryDetails>() {
        @Override
        public BeneficiaryDetails createFromParcel(Parcel in) {
            return new BeneficiaryDetails(in);
        }

        @Override
        public BeneficiaryDetails[] newArray(int size) {
            return new BeneficiaryDetails[size];
        }
    };

    public String getBeneficiaryName() {
        return beneficiaryName;
    }

    public void setBeneficiaryName(String beneficiaryName) {
        this.beneficiaryName = beneficiaryName;
    }

    public String getBeneficiaryAccountNumber() {
        return beneficiaryAccountNumber;
    }

    public void setBeneficiaryAccountNumber(String beneficiaryAccountNumber) {
        this.beneficiaryAccountNumber = beneficiaryAccountNumber;
    }

    public BeneficiaryAccountType getBeneficiaryAccountType() {
        return beneficiaryAccountType;
    }

    public void setBeneficiaryAccountType(BeneficiaryAccountType beneficiaryAccountType) {
        this.beneficiaryAccountType = beneficiaryAccountType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(beneficiaryName);
        dest.writeString(beneficiaryAccountNumber);
        dest.writeString(this.beneficiaryAccountType.name());
    }
}
