//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.paymentparamhelper;


/**
 * Created by franklin on 5/30/15.
 * Payu Errors
 * when SDK validates the post params (paymentDefaultParams, CCDCParams, NetbankingParams, CashCardParam, Emi params, paisawallet param)
 * any one of these error code, proper error message should be return via postParam
 */
public interface PayuErrors {

    //prefix and postfix
    String PRE_PREIX = "should be the ";
    String UDF_POSTIX = " should not be null, it can be empty or string";
    String INVALID_PREIX2 = "Please provide valid ";
    String MANDATORY_PARAM_PREIX = "Mandatory param ";
    String IS_MISSING_POSTIX = " is missing";

    int NO_ERROR = 0000;  // TODO rename this gus as SUCCESS or something else.
    int MISSING_PARAMETER_EXCEPTION = 5001;
    int NUMBER_FORMAT_EXCEPTION = 5002;
    int INVALID_AMOUNT_EXCEPTION = 5003;
    int UN_SUPPORTED_ENCODING_EXCEPTION = 5004;
    int INVALID_BANKCODE_EXCEPTION = 5005;
    int INVALID_CARD_NUMBER_EXCEPTION = 5008;
    int INVALID_CVV_EXCEPTION = 5009;
    int CARD_EXPIRED_EXCEPTION = 5012;
    int USER_CREDENTIALS_NOT_FOUND_EXCEPTION = 5013;
    int INVALID_SUBVENTION_AMOUNT_EXCEPTION = 5021;
    int INVALID_VPA = 5022;

    String MANDATORY_PARAM_KEY_IS_MISSING = MANDATORY_PARAM_PREIX + "key" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_HASH_IS_MISSING = MANDATORY_PARAM_PREIX + "hash" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_TXNID_IS_MISSING = MANDATORY_PARAM_PREIX + "txnid" + IS_MISSING_POSTIX;

    String MANDATORY_PARAM_FIRST_NAME_IS_MISSING = MANDATORY_PARAM_PREIX + "firstname" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_EMAIL_IS_MISSING = MANDATORY_PARAM_PREIX + "email" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_PRODUCT_INFO_IS_MISSING = MANDATORY_PARAM_PREIX + "product info" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_SURL_IS_MISSING = MANDATORY_PARAM_PREIX + "surl" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_FURL_IS_MISSING = MANDATORY_PARAM_PREIX + "furl" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_BENEFICIARY_ACCOUNT_NUMBER_IS_MISSING = MANDATORY_PARAM_PREIX + "beneficiaryAccountNumber" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_PHONE_IS_MISSING = MANDATORY_PARAM_PREIX + "phone" + IS_MISSING_POSTIX;

    String USER_CREDENTIALS_MISSING = PRE_PREIX + "user credentials and it should be merchant_key:unique_user_id.";

    String USER_CREDENTIALS_NOT_FOUND = " Card can not be stored!, user_credentials is missing!";

    String CARD_EXPIRED = " It seems the card is expired!";

    String INVALID_AMOUNT = " Amount should be a Double value example 5.00";
    String INVALID_BANK_CODE = "Invalid bank code please verify";
    String INVALID_CARD_NUMBER = " Invalid card number, Failed while applying Luhn";
    String INVALID_CVV = " Invalid cvv, please verify";
    String INVALID_URL = " should be something like https://www.payu.in/txnstatus";
    String INVALID_PG = "Invalid pg!, pg should be any one of CC, EMI, CASH, NB, PAYU_MONEY";

    String INVALID_SUBVENTION_AMOUNT_TYPE_1 = "Subvention Amount should be a Double value example 5.00";
    String INVALID_SUBVENTION_AMOUNT_TYPE_2 = "Subvention Amount should be positive and less than or equal to the transaction amount.";

    String INVALID_UDF1 = "UDF1" + UDF_POSTIX;
    String INVALID_UDF2 = "UDF2" + UDF_POSTIX;
    String INVALID_UDF3 = "UDF3" + UDF_POSTIX;
    String INVALID_UDF4 = "UDF4" + UDF_POSTIX;
    String INVALID_UDF5 = "UDF5" + UDF_POSTIX;


    String INVALID_EMI_DETAILS = INVALID_PREIX2 + "email details";

    String VPA_NULL="virtual address is null";
    String VPA_EMPTY="virtual address is empty";
    String VPA_GREATER="virtual address length should be less then 50 charaters";
    String INVALID_VPA_MESSAGE="INVALID VPA";
    String MANDATORY_PARAM_ACCOUNT_NUMBER_IS_MISSING = MANDATORY_PARAM_PREIX + "account number" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_ACCOUNT_HOLDER_NAME_IS_MISSING = MANDATORY_PARAM_PREIX + "account holder name" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_ACCOUNT_TYPE_IS_MISSING = MANDATORY_PARAM_PREIX + "account type" + IS_MISSING_POSTIX;

    String MANDATORY_PARAM_CCNAME_IS_MISSING = MANDATORY_PARAM_PREIX + "name on card" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_CCNUMBER_IS_MISSING = MANDATORY_PARAM_PREIX + "card number" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_CCVV_IS_MISSING = MANDATORY_PARAM_PREIX + "card cvv" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_CCEXPMON_IS_MISSING = MANDATORY_PARAM_PREIX + "card month expiry" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_CCEXPYEAR_IS_MISSING = MANDATORY_PARAM_PREIX + "card year expiry" + IS_MISSING_POSTIX;
    String ERROR_INVALID_START_DATE_EXCEPTION = "Invalid start date";
    String ERROR_INVALID_END_DATE_EXCEPTION = "Invalid end date";
    String MANDATORY_PARAM_BANK_CODE_IS_MISSING = MANDATORY_PARAM_PREIX + "bank code" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_PAYMENT_MODE_IS_MISSING = MANDATORY_PARAM_PREIX + "payment mode" + IS_MISSING_POSTIX;

    int INVALID_START_DATE_EXCEPTION = 5031;
    int INVALID_END_DATE_EXCEPTION = 5032;
    int INVALID_DATE_EXCEPTION = 5033;
    int INVALID_BILLING_INTERVAL_EXCEPTION = 5034;
    int INVALID_BILLING_AMOUNT_FOR_UPI_EXCEPTION = 5035;
    int INVALID_BILLING_AMOUNT_FOR_ADHOC_EXCEPTION = 5036;
    int INVALID_BILLING_CYCLE_PARAMETER_EXCEPTION = 5037;
    int INVALID_ACCOUNT_NUMBER_EXCEPTION = 5038;
    int INVALID_REMARKS_LENGTH_ERROR = 5039;

    String ERROR_INVALID_START_END_DATE_EXCEPTION = "End date should be greater than start date";
    String ERROR_INVALID_BILLING_INTERVAL_EXCEPTION = "Billing interval should be 1 for billing cycle ADHOC and ONCE";
    String ERROR_INVALID_BILLING_AMOUNT_FOR_UPI_EXCEPTION = "Billing amount should be less than INR 2000";
    String ERROR_INVALID_BILLING_AMOUNT_FOR_ADHOC_EXCEPTION = "Billing amount should not be greater than amount passed in subscription call";
    String ERROR_INVALID_BILLING_CYCLE_EXCEPTION = "Invalid billing cycle value passed";
    String ERROR_INVALID_ACCOUNT_NUMBER_EXCEPTION = "Please enter atleast 8 digit account number";
    String ERROR_REMARKS_MAX_LENGTH_CROSSED = "Remarks can be maximum of 50 characters";

}
