//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.paymentparamhelper;


import java.util.HashSet;
import java.util.Set;

/**
 * Created by franklin on 5/31/15.
 * Payu constants
 * User can make use in API request, response, bundles, validations etc,
 */
public interface PayuConstants {

    // payu default params
    String DEVICE_TYPE = "device_type";
    // payment modes
    String CC = "CC";
    String EMI = "EMI";
    String CASH = "CASH";
    String NB = "NB";
    String PAYU_MONEY = "PAYU_MONEY";
    String UPI = "upi";
    String UPITPV = "UPITPV";
    String TEZTPV = "TEZTPV";
    String INTTPV = "INTTPV";
    String TEZ = "TEZ";
    String OLAM = "OLAM";
    String TWID = "TWID";
    String OLA_MONEY = "OLA_MONEY";
    String SAMSUNG_PAY = "SAMPAY";
    String PHONEPE_INTENT = "PPINTENT";
    String UPI_INTENT = "INTENT";
    String PAY_BY_REWARDS = "PAY_BY_REWARDS";

    // payment mode params
    String PG = "pg";
    String BANK_CODE = "bankcode";
    String CC_NUM = "ccnum";
    String CC_NAME = "ccname";
    String C_CVV = "ccvv";
    String CC_EXP_MON = "ccexpmon";
    String CC_EXP_YR = "ccexpyr";
    String STORE_CARD_TOKEN = "store_card_token";
    String STORED_CARD = "store_card";
    String USER_CREDENTIALS = "user_credentials";
    String VPA = "vpa";
    String NOTIFY_URL = "notifyurl";
    String SALT_VERSION = "salt_version";
    String TWID_CUSTOMER_HASH = "twid_customer_hash";

    // cvvless inputs


    // payment mandatory parms
    String KEY = "key";
    String TXNID = "txnid";
    String AMOUNT = "amount";
    String PRODUCT_INFO = "productinfo";
    String FIRST_NAME = "firstname";
    String BENEFICIARY_ACCOUNT_NUMBER = "beneficiaryAccountNumber";
    String BENEFICIARY_DETAILS = "beneficiarydetail";
    String TPV = "TPV";
    String API_VERSION = "api_version";
    String EMAIL = "email";
    String SURL = "surl";
    String FURL = "furl";
    String HASH = "hash";

    // payment other params
    String OFFER_KEY = "offer_key";
    String PHONE = "phone";
    String LASTNAME = "lastname";
    String ADDRESS1 = "address1";
    String ADDRESS2 = "address2";
    String CITY = "city";
    String STATE = "state";
    String COUNTRY = "country";
    String ZIPCODE = "zipcode";

    String CODURL = "codurl";
    String DROP_CATEGORY = "drop_category";
    String ENFORCE_PAYMETHOD = "enforce_paymethod";
    String CUSTOM_NOTE = "custom_note";
    String NOTE_CATEGORY = "note_category";
    String SHIPPING_FIRSTNAME = "shipping_firstname";
    String SHIPPING_LASTNAME = "shipping_lastname";
    String SHIPPING_ADDRESS1 = "shipping_address1";
    String SHIPPING_ADDRESS2 = "shipping_address2";
    String SHIPPING_CITY = "shipping_city";
    String SHIPPING_STATE = "shipping_state";
    String SHIPPING_CONTRY = "shipping_county";
    String SHIPPING_ZIPCODE = "shipping_zipcode";
    String SHIPPING_PHONE = "shipping_phone";

    //udf collection
    String UDF1 = "udf1";
    String UDF2 = "udf2";
    String UDF3 = "udf3";
    String UDF4 = "udf4";
    String UDF5 = "udf5";

    // issuer collections

    String VISA = "VISA";
    String LASER = "LASER";
    String MAES = "MAES";
    String MAST = "MAST";
    String AMEX = "AMEX";
    String DINR = "DINR";
    String JCB = "JCB";
    String SMAE = "SMAE";
    String RUPAY = "RUPAY";
    String UNDEFINED = "UNDEFINED";

    // webservice api constants

    String DEFAULT = "default";


    int MAX_VPA_SIZE=50;
    // commands

    @Deprecated
    String GET_NETBANKING_STATUS = "getNetbankingStatus";
    @Deprecated
    String GET_ISSUING_BANK_STATUS = "getIssuingBankStatus";
    @Deprecated
    String GET_MERCHANT_IBIBO_CODES = "get_merchant_ibibo_codes";
    // hash generation api not for merchats
    @Deprecated
    String MOBILE_HASH_TEST_WS = "mobileHashTestWs";
    // status
    String ERROR = "ERROR";
    String SUCCESS = "SUCCESS";
    // Response data
    String LAZYPAY = "lazypay";
    String PAYUW = "PAYUW";
    String WALLET = "wallet";


    // user cards

    String NAME_ON_CARD = "name_on_card";
    String CARD_NAME = "card_name";

    // for bundle
    @Deprecated
    String PAYMENT_DEFAULT_PARAMS = "payment_default_params";

    // sets and lists

    Set<String> PG_SET = new HashSet<String>();
    String[] PAYMENT_PARAMS_ARRAY = {KEY, TXNID, AMOUNT, PRODUCT_INFO, FIRST_NAME, EMAIL, SURL, FURL, HASH, UDF1, UDF2, UDF3, UDF4, UDF5, BENEFICIARY_ACCOUNT_NUMBER};
    // Shared preference file name
    INIT init = new INIT();

    // subvention amount - used with payment url (_payment)
    String SUBVENTION_AMOUNT = "subvention_amount";

    //Analytics
    String PLATFORM_KEY = "platform";
    String PLATFORM_VALUE = "android";
    String SDK_PLATFORM_KEY ="sdk_platform";
    String NAME_KEY ="name";
    String NAME_VALUE ="pgsdk";
    String VERSION_KEY ="version";

    class INIT {
        static {
            //PG_SET
            PG_SET.add(CC);
            PG_SET.add(EMI);
            PG_SET.add(CASH);
            PG_SET.add(NB);
            PG_SET.add(PAYU_MONEY);
            PG_SET.add(UPI);
            PG_SET.add(TEZ);
            PG_SET.add(SAMSUNG_PAY);
            PG_SET.add(PHONEPE_INTENT);
            PG_SET.add(UPI_INTENT);
            PG_SET.add(OLA_MONEY);
            PG_SET.add(PAY_BY_REWARDS);

            // For getEmiAmountAccordingToInterest
        }

        INIT() {
        }
    }

    String BENEFICIARY_NAME = "beneficiaryName";
    String BENEFICIARY_ACCOUNT_TYPE = "beneficiaryAccountType";
    String BILLING_INTERVAL = "billingInterval";
    String BILLING_CYCLE = "billingCycle";
    String BILLING_AMOUNT = "billingAmount";
    String BILLING_CURRENCY = "billingCurrency";
    String BILLING_START_DATE = "paymentStartDate";
    String BILLING_END_DATE = "paymentEndDate";
    String BILLING_REMARKS = "remarks";
    String ENACH = "ENACH";
    String SI_API_VERSION = "api_version";
    String SI_VALUE = "si";
    String SI_DETAILS = "si_details";
    String DC = "DC";
    String SI_FREE_TRIAL = "free_trial";


}
