/*
 * Decompiled with CFR 0.152.
 */
package in.org.nnm.log4j.utils;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.RegexReplacement;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;

@Plugin(name="MessageRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public class MessageRewritePolicy
implements RewritePolicy {
    private final RegexReplacement[] replace;

    private MessageRewritePolicy(RegexReplacement[] replace) {
        this.replace = replace;
    }

    @PluginFactory
    public static MessageRewritePolicy createPlugin(@PluginElement(value="Replace") RegexReplacement[] replace) {
        return new MessageRewritePolicy(replace);
    }

    public LogEvent rewrite(LogEvent event) {
        String message = event.getMessage().getFormattedMessage();
        for (RegexReplacement r : this.replace) {
            message = r.format(message);
        }
        return new Log4jLogEvent.Builder(event).setMessage((Message)new SimpleMessage(message)).build();
    }
}

