/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.mathcal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class WeeklyData {
    public List<Double> open = new ArrayList<Double>();
    public List<Double> high = new ArrayList<Double>();
    public List<Double> low = new ArrayList<Double>();
    public List<Double> close = new ArrayList<Double>();
    public List<String> date = new ArrayList<String>();
    public List<Long> volume = new ArrayList<Long>();
    private List<Double> dopen = new ArrayList<Double>();
    private List<Double> dhigh = new ArrayList<Double>();
    private List<Double> dlow = new ArrayList<Double>();
    private List<Double> dclose = new ArrayList<Double>();
    private List<Long> dvolume = new ArrayList<Long>();
    private List<String> ddate = new ArrayList<String>();
    private List<Integer> day = new ArrayList<Integer>();

    public WeeklyData(List<Double> o, List<Double> h, List<Double> l, List<Double> c, List<Long> v, List<String> ts) {
        this.dopen.addAll(o);
        this.dhigh.addAll(h);
        this.dlow.addAll(l);
        this.dclose.addAll(c);
        this.dvolume.addAll(v);
        this.ddate.addAll(ts);
        if (this.dopen.size() == this.dhigh.size() && this.dopen.size() == this.dlow.size() && this.dopen.size() == this.dclose.size() && this.dopen.size() == this.dvolume.size() && this.dopen.size() == this.ddate.size() && this.dopen.size() > 1) {
            this.WeeklyData();
        }
    }

    private void WeeklyData() {
        int i;
        Calendar c = Calendar.getInstance();
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        Locale l = Locale.US;
        SimpleDateFormat d = new SimpleDateFormat("EEEE");
        long tmp_vol = 0L;
        double tmp_low = 0.0;
        double tmp_high = 0.0;
        try {
            for (i = 0; i < this.ddate.size(); ++i) {
                Date dt = f.parse(this.ddate.get(i));
                c.setTime(dt);
                int dayOfWeek = c.get(7);
                this.day.add(dayOfWeek);
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        for (i = 0; i < this.day.size() - 1; ++i) {
            if (i == 0) {
                this.close.add(this.dclose.get(i));
                this.date.add(this.ddate.get(i));
                tmp_vol = this.dvolume.get(i);
                tmp_low = this.dlow.get(i);
                tmp_high = this.dhigh.get(i);
                if (this.day.get(i) != 2) continue;
                this.open.add(this.dopen.get(i));
                this.high.add(tmp_high);
                this.low.add(tmp_low);
                this.volume.add(tmp_vol);
                continue;
            }
            if (i < 1) continue;
            if (this.day.get(i) < this.day.get(i - 1)) {
                tmp_vol += this.dvolume.get(i).longValue();
                if (this.dlow.get(i) < tmp_low) {
                    tmp_low = this.dlow.get(i);
                }
                if (this.dhigh.get(i) > tmp_high) {
                    tmp_high = this.dhigh.get(i);
                }
                if (this.day.get(i) >= this.day.get(i + 1) && i + 1 != this.day.size() - 1) continue;
                this.open.add(this.dopen.get(i));
                this.high.add(tmp_high);
                this.low.add(tmp_low);
                this.volume.add(tmp_vol);
                continue;
            }
            if (this.day.get(i) <= this.day.get(i - 1)) continue;
            this.close.add(this.dclose.get(i));
            this.date.add(this.ddate.get(i));
            tmp_vol = this.dvolume.get(i);
            tmp_low = this.dlow.get(i);
            tmp_high = this.dhigh.get(i);
        }
    }

    public List<Double> getOpen() {
        return this.open;
    }

    public List<Double> getHigh() {
        return this.high;
    }

    public List<Double> getLow() {
        return this.low;
    }

    public List<Double> getClose() {
        return this.close;
    }

    public List<Long> getVolume() {
        return this.volume;
    }

    public List<String> getDate() {
        return this.date;
    }
}

