/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.twoline;

import in.kncsolutions.dhelm.candlebasic.ClosingWhiteMarubozu;
import in.kncsolutions.dhelm.candlebasic.WhiteMarubozu;
import in.kncsolutions.dhelm.exceptions.DataException;
import java.util.ArrayList;
import java.util.List;

public class MatchingHigh {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefLength;
    private int RefTrend;
    private double Percentage;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isMatchingHigh;

    public MatchingHigh(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numLen, int numTrend, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage = percentage;
        this.isMatchingHigh = false;
        if (this.Open.size() < (this.RefTrend + 2 > this.RefLength ? this.RefTrend + 2 : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.MatchingHigh();
    }

    private void MatchingHigh() throws DataException {
        if ((new WhiteMarubozu(this.Open, this.High, this.Low, this.Close).isWhiteMarubozu() || new ClosingWhiteMarubozu(this.Open, this.High, this.Low, this.Close).isClosingWhiteMarubozu()) && (new WhiteMarubozu(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size())).isLongWhiteMarubozu(this.RefLength, this.Percentage) || new ClosingWhiteMarubozu(this.Open.subList(1, this.Open.size()), this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), this.Close.subList(1, this.Close.size())).isLongClosingWhiteMarubozu(this.RefLength, this.Percentage)) && this.Close.get(0) == this.Close.get(1) && this.Open.get(0) > this.Open.get(1) && this.trendPrior[0] < 0.0) {
            this.isMatchingHigh = true;
        }
    }

    public boolean isMatchingHigh() {
        return this.isMatchingHigh;
    }
}

