/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.oneline;

import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.CandleFacts;
import in.kncsolutions.dhelm.mathcal.Mathfns;
import java.util.ArrayList;
import java.util.List;

public class OneCandleShootingStar {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefLength;
    private int RefTrend;
    private double Percentage;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isOneCandleShootingStar;

    public OneCandleShootingStar(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numLen, int numTrend, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage = percentage;
        this.isOneCandleShootingStar = false;
        if (this.Open.size() < (this.RefTrend + 1 > this.RefLength ? this.RefTrend + 1 : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.OneCandleShootingStar();
    }

    private void OneCandleShootingStar() throws DataException {
        double lShadow = Math.abs(Math.min(this.Open.get(0), this.Close.get(0)) - this.Low.get(0));
        double uShadow = Math.abs(this.High.get(0) - Math.max(this.Open.get(0), this.Close.get(0)));
        double body = Math.abs(this.Open.get(0) - this.Close.get(0));
        double avgCandleLength = CandleFacts.getAverageLength(this.High, this.Low, (int)this.RefLength);
        if (lShadow < body && uShadow / body >= 2.0 && this.High.get(0) - this.Low.get(0) > avgCandleLength * this.Percentage / 100.0) {
            this.trendPrior = Mathfns.ComputeTrendLine(this.Close.subList(1, this.RefTrend + 1), (int)this.Close.subList(1, this.RefTrend + 1).size());
            if (this.trendPrior[0] < 0.0) {
                this.isOneCandleShootingStar = true;
            }
        }
    }

    public boolean isOneCandleShootingStar() {
        return this.isOneCandleShootingStar;
    }

    public boolean isLong() {
        return this.isOneCandleShootingStar;
    }

    public boolean isShort() {
        return false;
    }
}

