/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.oneline;

import in.kncsolutions.dhelm.candlebasic.BlackSpinningTop;
import in.kncsolutions.dhelm.candlebasic.WhiteSpinningTop;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.Mathfns;
import java.util.ArrayList;
import java.util.List;

public class HangingMan {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefLength;
    private int RefTrend;
    private double Percentage;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isHangingMan;

    public HangingMan(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numLen, int numTrend, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage = percentage;
        this.isHangingMan = false;
        if (this.Open.size() < (this.RefTrend + 1 > this.RefLength ? this.RefTrend + 1 : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.HangingMan();
    }

    private void HangingMan() throws DataException {
        if ((new WhiteSpinningTop(this.Open, this.High, this.Low, this.Close, this.RefLength, this.Percentage).isLongWhiteSpinningTop() || new BlackSpinningTop(this.Open, this.High, this.Low, this.Close, this.RefLength, this.Percentage).isLongBlackSpinningTop()) && this.High.get(0) - Math.max(this.Open.get(0), this.Close.get(0)) <= Math.abs(this.Open.get(0) - this.Close.get(0)) && Math.min(this.Open.get(0), this.Close.get(0)) - this.Low.get(0) >= 2.0 * Math.abs(this.Open.get(0) - this.Close.get(0)) && Math.min(this.Open.get(0), this.Close.get(0)) - this.Low.get(0) <= 3.0 * Math.abs(this.Open.get(0) - this.Close.get(0))) {
            this.trendPrior = Mathfns.ComputeTrendLine(this.Close.subList(1, this.RefTrend + 1), (int)this.Close.subList(1, this.RefTrend + 1).size());
            if (this.trendPrior[0] < 0.0) {
                this.isHangingMan = true;
            }
        }
    }

    public boolean isHangingMan() {
        return this.isHangingMan;
    }
}

