/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.oneline;

import in.kncsolutions.dhelm.candlebasic.BlackMarubozu;
import in.kncsolutions.dhelm.candlebasic.ClosingBlackMarubozu;
import in.kncsolutions.dhelm.candlebasic.LongBlackCandle;
import in.kncsolutions.dhelm.candlebasic.OpeningBlackMarubozu;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.CandleFacts;
import java.util.ArrayList;
import java.util.List;

public class BearishStrongLine {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefBody;
    private int RefLength;
    private double Percentage;
    private boolean isBearishStrongLine;

    public BearishStrongLine(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numBody, int numLen, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefLength = numBody;
        this.RefLength = numLen;
        this.Percentage = percentage;
        this.isBearishStrongLine = false;
        if (this.Open.size() < (this.RefBody > this.RefLength ? this.RefBody : this.RefLength) || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.BearishStrongLine();
    }

    private void BearishStrongLine() throws DataException {
        double avgBodyLength = CandleFacts.getAverageLength(this.Open, this.Close, (int)this.RefBody);
        if ((new OpeningBlackMarubozu(this.Open, this.High, this.Low, this.Close).isLongOpeningBlackMarubozu(this.RefLength, this.Percentage) || new ClosingBlackMarubozu(this.Open, this.High, this.Low, this.Close).isLongClosingBlackMarubozu(this.RefLength, this.Percentage) || new BlackMarubozu(this.Open, this.High, this.Low, this.Close).isLongBlackMarubozu(this.RefLength, this.Percentage) || new LongBlackCandle(this.Open, this.High, this.Low, this.Close, this.RefBody, this.RefLength, this.Percentage).isLongBlackCandle()) && this.Open.get(0) - this.Close.get(0) >= 3.0 * avgBodyLength) {
            this.isBearishStrongLine = true;
        }
    }

    public boolean isBearishStrongLine() {
        return this.isBearishStrongLine;
    }
}

