/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlepattern.multiline;

import in.kncsolutions.dhelm.candlebasic.ClosingWhiteMarubozu;
import in.kncsolutions.dhelm.candlebasic.LongWhiteCandle;
import in.kncsolutions.dhelm.candlebasic.OpeningWhiteMarubozu;
import in.kncsolutions.dhelm.candlebasic.WhiteCandle;
import in.kncsolutions.dhelm.candlebasic.WhiteMarubozu;
import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.CandleFacts;
import in.kncsolutions.dhelm.mathcal.Mathfns;
import java.util.ArrayList;
import java.util.List;

public class RisingThreeMethod {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefBody;
    private int RefLength;
    private int RefTrend;
    private double Percentage;
    private double[] trendPrior = new double[]{0.0, 0.0};
    private boolean isRisingThreeMethod;

    public RisingThreeMethod(List<Double> open, List<Double> high, List<Double> low, List<Double> close, int numBody, int numLen, int numTrend, double percentage) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        this.RefBody = numBody;
        this.RefLength = numLen;
        this.RefTrend = numTrend;
        this.Percentage = percentage;
        this.isRisingThreeMethod = false;
        if (this.Open.size() < (this.RefTrend + 4 > this.RefLength ? this.RefTrend + 4 : this.RefLength) && (this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size())) {
            throw new DataException();
        }
        this.RisingThreeMethod();
    }

    private void RisingThreeMethod() throws DataException {
        if (this.Close.get(4) > this.Open.get(4) && this.validBasicCandle(5) && this.Close.get(3) < this.Open.get(3) && this.Open.get(3) < this.Close.get(4) && this.Close.get(3) > this.Open.get(4) && this.Close.get(2) < this.Open.get(2) && this.Open.get(2) < this.Close.get(4) && this.Close.get(2) > this.Open.get(4) && this.Close.get(2) < this.Close.get(3) && this.Close.get(1) < this.Open.get(1) && this.Open.get(1) < this.Close.get(4) && this.Close.get(1) > this.Open.get(4) && this.Close.get(1) < this.Close.get(2) && this.Close.get(0) > this.Open.get(0) && this.validBasicCandle(1) && this.Close.get(0) > this.Close.get(4)) {
            this.trendPrior = Mathfns.ComputeTrendLine(this.Close.subList(3, this.RefTrend + 3), (int)this.Close.subList(3, this.RefTrend + 3).size());
            if (this.trendPrior[0] < 0.0) {
                this.isRisingThreeMethod = true;
            }
        }
    }

    private boolean validBasicCandle(int i) throws DataException {
        if (i == 5 && new WhiteCandle(this.Open.subList(4, this.Open.size()), this.High.subList(4, this.High.size()), this.Low.subList(4, this.Low.size()), this.Close.subList(4, this.Close.size()), this.RefBody, this.RefLength, this.Percentage).isWhiteCandle() || new LongWhiteCandle(this.Open.subList(4, this.Open.size()), this.High.subList(4, this.High.size()), this.Low.subList(4, this.Low.size()), this.Close.subList(4, this.Close.size()), this.RefBody, this.RefLength, this.Percentage).isLongWhiteCandle() || new WhiteMarubozu(this.Open.subList(4, this.Open.size()), this.High.subList(4, this.High.size()), this.Low.subList(4, this.Low.size()), this.Close.subList(4, this.Close.size())).isLongWhiteMarubozu(this.RefLength, this.Percentage) || new ClosingWhiteMarubozu(this.Open.subList(4, this.Open.size()), this.High.subList(4, this.High.size()), this.Low.subList(4, this.Low.size()), this.Close.subList(4, this.Close.size())).isLongClosingWhiteMarubozu(this.RefLength, this.Percentage) || new OpeningWhiteMarubozu(this.Open.subList(4, this.Open.size()), this.High.subList(4, this.High.size()), this.Low.subList(4, this.Low.size()), this.Close.subList(4, this.Close.size())).isLongOpeningWhiteMarubozu(this.RefLength, this.Percentage)) {
            return true;
        }
        return i == 1 && new WhiteCandle(this.Open, this.High, this.Low, this.Close, this.RefBody, this.RefLength, this.Percentage).isWhiteCandle() || new LongWhiteCandle(this.Open, this.High, this.Low, this.Close, this.RefBody, this.RefLength, this.Percentage).isLongWhiteCandle() || new WhiteMarubozu(this.Open, this.High, this.Low, this.Close).isLongWhiteMarubozu(this.RefLength, this.Percentage) || new ClosingWhiteMarubozu(this.Open, this.High, this.Low, this.Close).isLongClosingWhiteMarubozu(this.RefLength, this.Percentage) || new OpeningWhiteMarubozu(this.Open, this.High, this.Low, this.Close).isLongOpeningWhiteMarubozu(this.RefLength, this.Percentage);
    }

    private boolean isShort() throws DataException {
        double avgCandleLength = CandleFacts.getAverageLength(this.High.subList(1, this.High.size()), this.Low.subList(1, this.Low.size()), (int)this.RefLength);
        return this.High.get(1) - this.Low.get(1) <= avgCandleLength * this.Percentage / 100.0;
    }

    public boolean isRisingThreeMethod() {
        return this.isRisingThreeMethod;
    }
}

