/*
 * Decompiled with CFR 0.152.
 */
package in.kncsolutions.dhelm.candlebasic;

import in.kncsolutions.dhelm.exceptions.DataException;
import in.kncsolutions.dhelm.mathcal.CandleFacts;
import java.util.ArrayList;
import java.util.List;

public class ClosingBlackMarubozu {
    private List<Double> Open = new ArrayList<Double>();
    private List<Double> High = new ArrayList<Double>();
    private List<Double> Low = new ArrayList<Double>();
    private List<Double> Close = new ArrayList<Double>();
    private int RefBody;
    private int RefLength;
    private double Percentage;
    private boolean isClosingBlackMarubozu;

    public ClosingBlackMarubozu(List<Double> open, List<Double> high, List<Double> low, List<Double> close) throws DataException {
        this.Open.addAll(open);
        this.High.addAll(high);
        this.Low.addAll(low);
        this.Close.addAll(close);
        if (this.Open.size() == 0 || this.Open.size() != this.Close.size() || this.Open.size() != this.High.size() || this.Open.size() != this.Low.size()) {
            throw new DataException();
        }
        this.ClosingBlackMarubozu();
    }

    private void ClosingBlackMarubozu() throws DataException {
        double avgBodyLength = CandleFacts.getAverageLength(this.Open, this.Close, (int)this.RefBody);
        double avgCandleLength = CandleFacts.getAverageLength(this.High, this.Low, (int)this.RefLength);
        if (this.Open.get(0) > this.Close.get(0) && this.High.get(0) > this.Open.get(0) && this.Low.get(0) == this.Close.get(0) && this.Open.get(0) - this.Close.get(0) > this.High.get(0) - this.Open.get(0)) {
            this.isClosingBlackMarubozu = true;
        }
    }

    public boolean isClosingBlackMarubozu() {
        return this.isClosingBlackMarubozu;
    }

    public boolean isLongClosingBlackMarubozu(int numLen, double percentage) throws DataException {
        double avgCandleLength = CandleFacts.getAverageLength(this.High, this.Low, (int)this.RefLength);
        return this.High.get(0) - this.Low.get(0) > avgCandleLength * this.Percentage / 100.0;
    }
}

