/*
 * Decompiled with CFR 0.152.
 */
package in.co.ophio.secure.core;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import in.co.ophio.secure.core.ObscuredSharedPreferences;

public class ObscuredPreferencesBuilder {
    public static final String DEFAULT_PREF_NAME = "shared_pref";
    private Application application;
    private String sharedPrefFileName = "shared_pref";
    private boolean isObfuscated;
    private boolean isKeyObfuscated = true;
    private String secret;

    public ObscuredPreferencesBuilder setApplication(Application application) {
        this.application = application;
        return this;
    }

    public ObscuredPreferencesBuilder setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public ObscuredPreferencesBuilder obfuscateValue(boolean obfuscated) {
        this.isObfuscated = obfuscated;
        return this;
    }

    public ObscuredPreferencesBuilder obfuscateKey(boolean obfuscateKey) {
        this.isKeyObfuscated = obfuscateKey;
        return this;
    }

    public ObscuredPreferencesBuilder setSharePrefFileName(String fileName) {
        this.sharedPrefFileName = fileName;
        return this;
    }

    public SharedPreferences createSharedPrefs() {
        SharedPreferences sharedPreferences;
        SharedPreferences sharedPrefDelegate = this.application.getSharedPreferences(this.sharedPrefFileName, 0);
        if (this.isObfuscated || this.isKeyObfuscated) {
            sharedPreferences = new ObscuredSharedPreferences((Context)this.application, sharedPrefDelegate, this.isKeyObfuscated);
            if (!TextUtils.isEmpty((CharSequence)this.secret)) {
                ((ObscuredSharedPreferences)sharedPreferences).setSecret(this.secret);
            } else {
                Log.d((String)"SharedPrefsBuilder", (String)"secret is empty");
            }
        } else {
            sharedPreferences = sharedPrefDelegate;
        }
        return sharedPreferences;
    }
}

