/*
 * Decompiled with CFR 0.152.
 */
package in.co.ophio.secure.vault;

import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;

public class SecretKeyWrapper {
    private final Cipher mCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
    private final KeyPair mPair;

    public SecretKeyWrapper(Context context, String alias) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        if (!keyStore.containsAlias(alias)) {
            SecretKeyWrapper.generateKeyPair(context, alias);
        }
        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, null);
        this.mPair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
    }

    private static void generateKeyPair(Context context, String alias) throws GeneralSecurityException {
        GregorianCalendar start = new GregorianCalendar();
        GregorianCalendar end = new GregorianCalendar();
        ((Calendar)end).add(1, 100);
        KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setSubject(new X500Principal("CN=" + alias)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
        gen.initialize((AlgorithmParameterSpec)spec);
        gen.generateKeyPair();
    }

    public byte[] wrap(SecretKey key) throws GeneralSecurityException {
        this.mCipher.init(3, this.mPair.getPublic());
        return this.mCipher.wrap(key);
    }

    public SecretKey unwrap(byte[] blob) throws GeneralSecurityException {
        this.mCipher.init(4, this.mPair.getPrivate());
        return (SecretKey)this.mCipher.unwrap(blob, "AES", 3);
    }
}

