/*
 * Decompiled with CFR 0.152.
 */
package in.co.ophio.secure.core;

import android.app.Application;
import android.content.Context;
import android.security.KeyChain;
import android.util.Base64;
import in.co.ophio.secure.core.KeyGenerator;
import in.co.ophio.secure.vault.SecretKeyWrapper;
import in.co.ophio.secure.vault.Utils;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyStoreKeyGenerator
implements KeyGenerator {
    public static final String TAG = "KeyGenerator";
    private static final int DATA_KEY_LENGTH = 32;
    private Application application;
    private boolean isHardwareBacked;
    private File keyFile;

    private KeyStoreKeyGenerator(Application application, String filename) {
        this.application = application;
        this.isHardwareBacked = KeyChain.isBoundKeyAlgorithm((String)"RSA");
        this.keyFile = new File(application.getFilesDir(), filename);
        try {
            this.loadOrGenerateKeys();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static KeyStoreKeyGenerator get(Application application, String fileName) {
        return new KeyStoreKeyGenerator(application, fileName);
    }

    @Override
    public String loadOrGenerateKeys() throws GeneralSecurityException, IOException {
        SecretKey key;
        SecretKeyWrapper wrapper = new SecretKeyWrapper((Context)this.application, TAG);
        if (!this.keyFile.exists()) {
            byte[] raw = new byte[32];
            new SecureRandom().nextBytes(raw);
            key = new SecretKeySpec(raw, "AES");
            byte[] wrapped = wrapper.wrap(key);
            Utils.writeFully(this.keyFile, wrapped);
        }
        byte[] wrapped = Utils.readFully(this.keyFile);
        key = wrapper.unwrap(wrapped);
        return Base64.encodeToString((byte[])key.getEncoded(), (int)0);
    }

    @Override
    public boolean isHardwareBacked() {
        return this.isHardwareBacked;
    }
}

