/*
 * Decompiled with CFR 0.152.
 */
package in.arjsna.swipecardlib;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.FrameLayout;
import in.arjsna.swipecardlib.BaseFlingAdapterView;
import in.arjsna.swipecardlib.FlingPageListener;
import in.arjsna.swipecardlib.R;

public class SwipePageView
extends BaseFlingAdapterView {
    private int MIN_ADAPTER_STACK = 6;
    private int MAX_VISIBLE = 2;
    private Adapter mAdapter;
    private boolean mInLayout = false;
    private int LAST_OBJECT_IN_STACK = 0;
    private View mActiveCard;
    private FlingPageListener flingPageListener;
    private PointF mLastTouchPoint;
    private float CURRENT_TRANSY_VAL;
    private float CURRENT_SCALE_VAL;
    private double SCALE_OFFSET = 0.2;
    private int TRANS_OFFSET = 45;
    private OnPageFlingListener mFlingListener;
    private OnItemClickListener mOnItemClickListener;
    private AdapterDataSetObserver mDataSetObserver;
    private int START_STACK_FROM = 0;

    public SwipePageView(Context context) {
        this(context, null);
    }

    public SwipePageView(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public SwipePageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipePageView, defStyle, 0);
        this.MIN_ADAPTER_STACK = a.getInt(R.styleable.SwipePageView_min_adapter_stack_page, this.MIN_ADAPTER_STACK);
        a.recycle();
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mAdapter == null) {
            return;
        }
        this.mInLayout = true;
        int adapterCount = this.mAdapter.getCount();
        if (adapterCount == 0) {
            this.removeAllViewsInLayout();
        } else {
            View topCard = this.getChildAt(this.LAST_OBJECT_IN_STACK);
            if (this.mActiveCard != null && topCard != null && topCard == this.mActiveCard) {
                if (this.flingPageListener.isTouching()) {
                    PointF lastPoint = this.flingPageListener.getLastPoint();
                    if (this.mLastTouchPoint == null || !this.mLastTouchPoint.equals((Object)lastPoint)) {
                        this.mLastTouchPoint = lastPoint;
                        this.removeViewsInLayout(0, this.LAST_OBJECT_IN_STACK);
                        this.layoutChildren(1, adapterCount);
                    }
                }
            } else {
                this.removeAllViewsInLayout();
                this.layoutChildren(this.START_STACK_FROM, adapterCount);
                this.setTopView();
            }
        }
        this.mInLayout = false;
        if (adapterCount <= this.MIN_ADAPTER_STACK) {
            this.mFlingListener.onAdapterAboutToEmpty(adapterCount);
        }
    }

    private void layoutChildren(int startingIndex, int adapterCount) {
        this.resetOffsets();
        if (adapterCount < this.MAX_VISIBLE) {
            this.MAX_VISIBLE = adapterCount;
        }
        int viewStack = 0;
        while (startingIndex < this.START_STACK_FROM + this.MAX_VISIBLE && startingIndex < adapterCount) {
            View newUnderChild = this.mAdapter.getView(startingIndex, null, (ViewGroup)this);
            if (newUnderChild.getVisibility() != 8) {
                this.makeAndAddView(newUnderChild);
                this.LAST_OBJECT_IN_STACK = viewStack;
            }
            ++startingIndex;
            ++viewStack;
        }
    }

    private void resetOffsets() {
        this.CURRENT_TRANSY_VAL = 0.0f;
        this.CURRENT_SCALE_VAL = 0.0f;
    }

    @TargetApi(value=17)
    private void makeAndAddView(View child) {
        int childTop;
        int childLeft;
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
        child.setScaleX(child.getScaleX() - this.CURRENT_SCALE_VAL);
        child.setScaleY(child.getScaleY() - this.CURRENT_SCALE_VAL);
        this.CURRENT_SCALE_VAL = (float)((double)this.CURRENT_SCALE_VAL + this.SCALE_OFFSET);
        this.addViewInLayout(child, 0, (ViewGroup.LayoutParams)lp, true);
        boolean needToMeasure = child.isLayoutRequested();
        if (needToMeasure) {
            int childWidthSpec = SwipePageView.getChildMeasureSpec((int)this.getWidthMeasureSpec(), (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
            int childHeightSpec = SwipePageView.getChildMeasureSpec((int)this.getHeightMeasureSpec(), (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
            child.measure(childWidthSpec, childHeightSpec);
        } else {
            this.cleanupLayoutState(child);
        }
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int gravity = lp.gravity;
        if (gravity == -1) {
            gravity = 0x800033;
        }
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
        int verticalGravity = gravity & 0x70;
        switch (absoluteGravity & 7) {
            case 1: {
                childLeft = (this.getWidth() + this.getPaddingLeft() - this.getPaddingRight() - w) / 2 + lp.leftMargin - lp.rightMargin;
                break;
            }
            case 0x800005: {
                childLeft = this.getWidth() + this.getPaddingRight() - w - lp.rightMargin;
                break;
            }
            default: {
                childLeft = this.getPaddingLeft() + lp.leftMargin;
            }
        }
        switch (verticalGravity) {
            case 16: {
                childTop = (this.getHeight() + this.getPaddingTop() - this.getPaddingBottom() - h) / 2 + lp.topMargin - lp.bottomMargin;
                break;
            }
            case 80: {
                childTop = this.getHeight() - this.getPaddingBottom() - h - lp.bottomMargin;
                break;
            }
            default: {
                childTop = this.getPaddingTop() + lp.topMargin;
            }
        }
        child.layout(childLeft, childTop, childLeft + w, childTop + h);
    }

    private void setTopView() {
        if (this.getChildCount() > 0) {
            this.mActiveCard = this.getChildAt(this.LAST_OBJECT_IN_STACK);
            if (this.mActiveCard != null) {
                this.flingPageListener = new FlingPageListener(this.mActiveCard, this.mAdapter.getItem(0), new FlingPageListener.FlingListener(){

                    @Override
                    public void onCardExited() {
                        SwipePageView.this.mActiveCard = null;
                        SwipePageView.this.START_STACK_FROM++;
                        SwipePageView.this.requestLayout();
                    }

                    @Override
                    public void onClick(Object dataObject) {
                        if (SwipePageView.this.mOnItemClickListener != null) {
                            SwipePageView.this.mOnItemClickListener.onItemClicked(0, dataObject);
                        }
                    }

                    @Override
                    public void onScroll(float scrollProgressPercent) {
                        int childCount;
                        Log.i((String)"Scroll Percentage ", (String)(scrollProgressPercent + ""));
                        SwipePageView.this.mFlingListener.onScroll(scrollProgressPercent);
                        if (childCount < SwipePageView.this.MAX_VISIBLE) {
                            for (childCount = SwipePageView.this.getChildCount() - 1; childCount > 0; --childCount) {
                                SwipePageView.this.relayoutChild(SwipePageView.this.getChildAt(childCount - 1), Math.abs(scrollProgressPercent), childCount);
                            }
                        } else {
                            while (childCount > 1) {
                                SwipePageView.this.relayoutChild(SwipePageView.this.getChildAt(childCount - 1), Math.abs(scrollProgressPercent), childCount - 1);
                                --childCount;
                            }
                        }
                    }

                    @Override
                    public void topExit(Object dataObject) {
                        SwipePageView.this.mFlingListener.onTopCardExit(dataObject);
                    }

                    @Override
                    public void bottomExit(Object dataObject) {
                        SwipePageView.this.mFlingListener.onBottomCardExit(dataObject);
                    }
                });
                this.mActiveCard.setOnTouchListener((View.OnTouchListener)this.flingPageListener);
            }
        }
    }

    public void relayoutChild(View child, float scrollDis, int childcount) {
        float absScrollDis = scrollDis > 1.0f ? 1.0f : scrollDis;
        float newScale = (float)(1.0 - this.SCALE_OFFSET * (double)(this.MAX_VISIBLE - childcount) + (double)absScrollDis * this.SCALE_OFFSET);
        child.setScaleX(newScale);
        child.setScaleY(newScale);
    }

    public Adapter getAdapter() {
        return null;
    }

    public void setAdapter(Adapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
    }

    public View getSelectedView() {
        return this.mActiveCard;
    }

    public void setFlingListener(OnPageFlingListener OnCardFlingListener2) {
        this.mFlingListener = OnCardFlingListener2;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new FrameLayout.LayoutParams(this.getContext(), attrs);
    }

    private class AdapterDataSetObserver
    extends DataSetObserver {
        private AdapterDataSetObserver() {
        }

        public void onChanged() {
            SwipePageView.this.requestLayout();
        }

        public void onInvalidated() {
            SwipePageView.this.requestLayout();
        }
    }

    public static interface OnPageFlingListener {
        public void onAdapterAboutToEmpty(int var1);

        public void onScroll(float var1);

        public void onTopCardExit(Object var1);

        public void onBottomCardExit(Object var1);
    }

    public static interface OnItemClickListener {
        public void onItemClicked(int var1, Object var2);
    }
}

