/*
 * Decompiled with CFR 0.152.
 */
package in.arjsna.swipecardlib;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.FrameLayout;
import in.arjsna.swipecardlib.BaseFlingAdapterView;
import in.arjsna.swipecardlib.FlingCardListener;
import in.arjsna.swipecardlib.R;

public class SwipeCardView
extends BaseFlingAdapterView {
    private static final double SCALE_OFFSET = 0.04;
    private static final float TRANS_OFFSET = 45.0f;
    protected boolean DETECT_BOTTOM_SWIPE;
    protected boolean DETECT_TOP_SWIPE;
    protected boolean DETECT_RIGHT_SWIPE;
    protected boolean DETECT_LEFT_SWIPE;
    private float CURRENT_TRANSY_VAL = 0.0f;
    private float CURRENT_SCALE_VAL = 0.0f;
    private int MAX_VISIBLE = 3;
    private int MIN_ADAPTER_STACK = 6;
    private float ROTATION_DEGREES = 15.0f;
    private int currentAdapterCount = 0;
    private Adapter mAdapter;
    private int LAST_OBJECT_IN_STACK = 0;
    private OnCardFlingListener mFlingListener;
    private AdapterDataSetObserver mDataSetObserver;
    private boolean mInLayout = false;
    private View mActiveCard = null;
    private OnItemClickListener mOnItemClickListener;
    private FlingCardListener flingCardListener;
    private PointF mLastTouchPoint;
    private int START_STACK_FROM = 0;
    private int adapterCount = 0;

    public SwipeCardView(Context context) {
        this(context, null);
    }

    public SwipeCardView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.SwipeFlingStyle);
    }

    public SwipeCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeCardView, defStyle, 0);
        this.MAX_VISIBLE = a.getInt(R.styleable.SwipeCardView_max_visible, this.MAX_VISIBLE);
        this.MIN_ADAPTER_STACK = a.getInt(R.styleable.SwipeCardView_min_adapter_stack, this.MIN_ADAPTER_STACK);
        this.ROTATION_DEGREES = a.getFloat(R.styleable.SwipeCardView_rotation_degrees, this.ROTATION_DEGREES);
        this.DETECT_LEFT_SWIPE = a.getBoolean(R.styleable.SwipeCardView_left_swipe_detect, true);
        this.DETECT_RIGHT_SWIPE = a.getBoolean(R.styleable.SwipeCardView_right_swipe_detect, true);
        this.DETECT_BOTTOM_SWIPE = a.getBoolean(R.styleable.SwipeCardView_bottom_swipe_detect, true);
        this.DETECT_TOP_SWIPE = a.getBoolean(R.styleable.SwipeCardView_top_swipe_detect, true);
        a.recycle();
    }

    public void init(Context context, Adapter mAdapter) {
        if (!(context instanceof OnCardFlingListener)) {
            throw new RuntimeException("Activity does not implement SwipeFlingAdapterView.OnCardFlingListener");
        }
        this.mFlingListener = (OnCardFlingListener)context;
        if (context instanceof OnItemClickListener) {
            this.mOnItemClickListener = (OnItemClickListener)context;
        }
        this.setAdapter(mAdapter);
    }

    public View getSelectedView() {
        return this.mActiveCard;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mAdapter == null) {
            return;
        }
        this.mInLayout = true;
        if (this.adapterCount == 0) {
            this.removeAllViewsInLayout();
        } else {
            View topCard = this.getChildAt(this.LAST_OBJECT_IN_STACK);
            if (this.mActiveCard != null && topCard != null && topCard == this.mActiveCard) {
                if (this.flingCardListener.isTouching()) {
                    PointF lastPoint = this.flingCardListener.getLastPoint();
                    if (this.mLastTouchPoint == null || !this.mLastTouchPoint.equals((Object)lastPoint)) {
                        this.mLastTouchPoint = lastPoint;
                        this.removeViewsInLayout(0, this.LAST_OBJECT_IN_STACK);
                        this.layoutChildren(1, this.adapterCount);
                    }
                }
            } else {
                this.removeAllViewsInLayout();
                this.layoutChildren(this.START_STACK_FROM, this.adapterCount);
                this.setTopView();
            }
        }
        this.mInLayout = false;
        if (this.currentAdapterCount <= this.MIN_ADAPTER_STACK) {
            this.mFlingListener.onAdapterAboutToEmpty(this.currentAdapterCount);
        }
    }

    private void layoutChildren(int startingIndex, int adapterCount) {
        View newUnderChild;
        this.resetOffsets();
        if (adapterCount - startingIndex < this.MAX_VISIBLE) {
            this.MAX_VISIBLE = adapterCount - startingIndex;
        }
        int viewStack = 0;
        while (startingIndex < this.START_STACK_FROM + this.MAX_VISIBLE && startingIndex < adapterCount) {
            newUnderChild = this.mAdapter.getView(startingIndex, null, (ViewGroup)this);
            if (newUnderChild.getVisibility() != 8) {
                this.makeAndAddView(newUnderChild, false);
            }
            ++startingIndex;
            ++viewStack;
        }
        if (startingIndex >= adapterCount) {
            this.LAST_OBJECT_IN_STACK = --viewStack;
            return;
        }
        newUnderChild = this.mAdapter.getView(startingIndex, null, (ViewGroup)this);
        if (newUnderChild != null && newUnderChild.getVisibility() != 8) {
            this.makeAndAddView(newUnderChild, true);
            this.LAST_OBJECT_IN_STACK = viewStack;
        }
    }

    private void resetOffsets() {
        this.CURRENT_TRANSY_VAL = 0.0f;
        this.CURRENT_SCALE_VAL = 0.0f;
    }

    @TargetApi(value=17)
    private void makeAndAddView(View child, boolean isBase) {
        int childTop;
        int childLeft;
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
        if (isBase) {
            child.setScaleX((float)((double)child.getScaleX() - ((double)this.CURRENT_SCALE_VAL - 0.04)));
            child.setScaleY((float)((double)child.getScaleY() - ((double)this.CURRENT_SCALE_VAL - 0.04)));
            child.setY(child.getTranslationY() + this.CURRENT_TRANSY_VAL - 45.0f);
        } else {
            child.setScaleX(child.getScaleX() - this.CURRENT_SCALE_VAL);
            child.setScaleY(child.getScaleY() - this.CURRENT_SCALE_VAL);
            child.setY(child.getTranslationY() + this.CURRENT_TRANSY_VAL);
        }
        this.CURRENT_SCALE_VAL = (float)((double)this.CURRENT_SCALE_VAL + 0.04);
        this.CURRENT_TRANSY_VAL += 45.0f;
        this.addViewInLayout(child, 0, (ViewGroup.LayoutParams)lp, true);
        boolean needToMeasure = child.isLayoutRequested();
        if (needToMeasure) {
            int childWidthSpec = SwipeCardView.getChildMeasureSpec((int)this.getWidthMeasureSpec(), (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
            int childHeightSpec = SwipeCardView.getChildMeasureSpec((int)this.getHeightMeasureSpec(), (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
            child.measure(childWidthSpec, childHeightSpec);
        } else {
            this.cleanupLayoutState(child);
        }
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int gravity = lp.gravity;
        if (gravity == -1) {
            gravity = 0x800033;
        }
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
        int verticalGravity = gravity & 0x70;
        switch (absoluteGravity & 7) {
            case 1: {
                childLeft = (this.getWidth() + this.getPaddingLeft() - this.getPaddingRight() - w) / 2 + lp.leftMargin - lp.rightMargin;
                break;
            }
            case 0x800005: {
                childLeft = this.getWidth() + this.getPaddingRight() - w - lp.rightMargin;
                break;
            }
            default: {
                childLeft = this.getPaddingLeft() + lp.leftMargin;
            }
        }
        switch (verticalGravity) {
            case 16: {
                childTop = (this.getHeight() + this.getPaddingTop() - this.getPaddingBottom() - h) / 2 + lp.topMargin - lp.bottomMargin;
                break;
            }
            case 80: {
                childTop = this.getHeight() - this.getPaddingBottom() - h - lp.bottomMargin;
                break;
            }
            default: {
                childTop = this.getPaddingTop() + lp.topMargin;
            }
        }
        child.layout(childLeft, childTop, childLeft + w, childTop + h);
    }

    public void relayoutChild(View child, float scrollDis, int childcount) {
        float absScrollDis = scrollDis > 1.0f ? 1.0f : scrollDis;
        float newScale = (float)(1.0 - 0.04 * (double)(this.MAX_VISIBLE - childcount) + (double)absScrollDis * 0.04);
        child.setScaleX(newScale);
        child.setScaleY(newScale);
        child.setTranslationY(45.0f * (float)(this.MAX_VISIBLE - childcount) - absScrollDis * 45.0f);
    }

    private void setTopView() {
        if (this.getChildCount() > 0) {
            this.mActiveCard = this.getChildAt(this.LAST_OBJECT_IN_STACK);
            if (this.mActiveCard != null) {
                this.flingCardListener = new FlingCardListener(this, this.mActiveCard, this.mAdapter.getItem(this.START_STACK_FROM), this.ROTATION_DEGREES, new FlingCardListener.FlingListener(){

                    @Override
                    public void onCardExited() {
                        SwipeCardView.this.mActiveCard = null;
                        SwipeCardView.this.START_STACK_FROM++;
                        SwipeCardView.this.currentAdapterCount--;
                        SwipeCardView.this.requestLayout();
                    }

                    @Override
                    public void leftExit(Object dataObject) {
                        SwipeCardView.this.mFlingListener.onCardExitLeft(dataObject);
                    }

                    @Override
                    public void rightExit(Object dataObject) {
                        SwipeCardView.this.mFlingListener.onCardExitRight(dataObject);
                    }

                    @Override
                    public void onClick(Object dataObject) {
                        if (SwipeCardView.this.mOnItemClickListener != null) {
                            SwipeCardView.this.mOnItemClickListener.onItemClicked(0, dataObject);
                        }
                    }

                    @Override
                    public void onScroll(float scrollProgressPercent) {
                        int childCount;
                        SwipeCardView.this.mFlingListener.onScroll(scrollProgressPercent);
                        if (childCount < SwipeCardView.this.MAX_VISIBLE) {
                            for (childCount = SwipeCardView.this.getChildCount() - 1; childCount > 0; --childCount) {
                                SwipeCardView.this.relayoutChild(SwipeCardView.this.getChildAt(childCount - 1), Math.abs(scrollProgressPercent), childCount);
                            }
                        } else {
                            while (childCount > 1) {
                                SwipeCardView.this.relayoutChild(SwipeCardView.this.getChildAt(childCount - 1), Math.abs(scrollProgressPercent), childCount - 1);
                                --childCount;
                            }
                        }
                    }

                    @Override
                    public void topExit(Object dataObject) {
                        SwipeCardView.this.mFlingListener.onCardExitTop(dataObject);
                    }

                    @Override
                    public void bottomExit(Object dataObject) {
                        SwipeCardView.this.mFlingListener.onCardExitBottom(dataObject);
                    }
                });
                this.mActiveCard.setOnTouchListener((View.OnTouchListener)this.flingCardListener);
            }
        }
    }

    public FlingCardListener getTopCardListener() throws NullPointerException {
        if (this.flingCardListener == null) {
            throw new NullPointerException();
        }
        return this.flingCardListener;
    }

    public void setMaxVisible(int MAX_VISIBLE) {
        this.MAX_VISIBLE = MAX_VISIBLE;
    }

    public void setMinStackInAdapter(int MIN_ADAPTER_STACK) {
        this.MIN_ADAPTER_STACK = MIN_ADAPTER_STACK;
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(Adapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        this.mAdapter = adapter;
        this.currentAdapterCount = adapter.getCount();
        this.adapterCount = this.mAdapter.getCount();
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
    }

    public void setFlingListener(OnCardFlingListener OnCardFlingListener2) {
        this.mFlingListener = OnCardFlingListener2;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new FrameLayout.LayoutParams(this.getContext(), attrs);
    }

    public void throwLeft() {
        this.flingCardListener.selectLeft();
    }

    public void throwRight() {
        this.flingCardListener.selectRight();
    }

    public void throwTop() {
        this.flingCardListener.selectTop();
    }

    public void throwBottom() {
        this.flingCardListener.selectBottom();
    }

    public static interface OnCardFlingListener {
        public void onCardExitLeft(Object var1);

        public void onCardExitRight(Object var1);

        public void onAdapterAboutToEmpty(int var1);

        public void onScroll(float var1);

        public void onCardExitTop(Object var1);

        public void onCardExitBottom(Object var1);
    }

    public static interface OnItemClickListener {
        public void onItemClicked(int var1, Object var2);
    }

    private class AdapterDataSetObserver
    extends DataSetObserver {
        private AdapterDataSetObserver() {
        }

        public void onChanged() {
            int newAdapterCount = SwipeCardView.this.mAdapter.getCount();
            SwipeCardView.this.currentAdapterCount = SwipeCardView.this.currentAdapterCount + (newAdapterCount - SwipeCardView.this.adapterCount);
            SwipeCardView.this.adapterCount = newAdapterCount;
            SwipeCardView.this.requestLayout();
        }

        public void onInvalidated() {
            SwipeCardView.this.requestLayout();
        }
    }
}

