/*
 * Decompiled with CFR 0.152.
 */
package in.arjsna.swipecardlib;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import in.arjsna.swipecardlib.LinearRegression;
import in.arjsna.swipecardlib.SwipeCardView;

public class FlingCardListener
implements View.OnTouchListener {
    private static final String TAG = FlingCardListener.class.getSimpleName();
    private static final int INVALID_POINTER_ID = -1;
    private final SwipeCardView parentView;
    private Rect RECT_TOP;
    private Rect RECT_BOTTOM;
    private Rect RECT_LEFT;
    private Rect RECT_RIGHT;
    private final float objectX;
    private final float objectY;
    private final int objectH;
    private final int objectW;
    private final int parentWidth;
    private final FlingListener mFlingListener;
    private final Object dataObject;
    private final float halfWidth;
    private final float halfHeight;
    private final int parentHeight;
    private float BASE_ROTATION_DEGREES;
    private float aPosX;
    private float aPosY;
    private float aDownTouchX;
    private float aDownTouchY;
    private int mActivePointerId = -1;
    private View frame = null;
    private final int TOUCH_ABOVE = 0;
    private final int TOUCH_BELOW = 1;
    private int touchPosition;
    private boolean isAnimationRunning = false;
    private float MAX_COS = (float)Math.cos(Math.toRadians(45.0));

    public FlingCardListener(SwipeCardView parent, View frame, Object itemAtPosition, FlingListener flingListener) {
        this(parent, frame, itemAtPosition, 15.0f, flingListener);
    }

    public FlingCardListener(SwipeCardView parent, View frame, Object itemAtPosition, float rotation_degrees, FlingListener flingListener) {
        this.parentView = parent;
        this.frame = frame;
        this.objectX = frame.getX();
        this.objectY = frame.getY();
        this.objectH = frame.getHeight();
        this.objectW = frame.getWidth();
        this.halfWidth = (float)this.objectW / 2.0f;
        this.halfHeight = (float)this.objectH / 2.0f;
        this.dataObject = itemAtPosition;
        this.parentWidth = ((ViewGroup)frame.getParent()).getWidth();
        this.parentHeight = ((ViewGroup)frame.getParent()).getHeight();
        this.BASE_ROTATION_DEGREES = rotation_degrees;
        this.mFlingListener = flingListener;
        this.RECT_TOP = new Rect((int)Math.max((float)frame.getLeft(), this.leftBorder()), 0, (int)Math.min((float)frame.getRight(), this.rightBorder()), (int)this.topBorder());
        this.RECT_BOTTOM = new Rect((int)Math.max((float)frame.getLeft(), this.leftBorder()), (int)this.bottomBorder(), (int)Math.min((float)frame.getRight(), this.rightBorder()), this.parentHeight);
        this.RECT_LEFT = new Rect(0, (int)Math.max((float)frame.getTop(), this.topBorder()), (int)this.leftBorder(), (int)Math.min((float)frame.getBottom(), this.bottomBorder()));
        this.RECT_RIGHT = new Rect((int)this.rightBorder(), (int)Math.max((float)frame.getTop(), this.topBorder()), this.parentWidth, (int)Math.min((float)frame.getBottom(), this.bottomBorder()));
    }

    public boolean onTouch(View view, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mActivePointerId = event.getPointerId(0);
                float x = 0.0f;
                float y = 0.0f;
                boolean success = false;
                try {
                    x = event.getX(this.mActivePointerId);
                    y = event.getY(this.mActivePointerId);
                    success = true;
                }
                catch (IllegalArgumentException e) {
                    Log.w((String)TAG, (String)("Exception in onTouch(view, event) : " + this.mActivePointerId), (Throwable)e);
                }
                if (success) {
                    this.aDownTouchX = x;
                    this.aDownTouchY = y;
                    if (this.aPosX == 0.0f) {
                        this.aPosX = this.frame.getX();
                    }
                    if (this.aPosY == 0.0f) {
                        this.aPosY = this.frame.getY();
                    }
                    this.touchPosition = y < (float)(this.objectH / 2) ? 0 : 1;
                }
                view.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: {
                this.mActivePointerId = -1;
                this.resetCardViewOnStack();
                view.getParent().requestDisallowInterceptTouchEvent(false);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                int pointerIndex = (event.getAction() & 0xFF00) >> 8;
                int pointerId = event.getPointerId(pointerIndex);
                if (pointerId != this.mActivePointerId) break;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.aDownTouchX = event.getX(newPointerIndex);
                this.aDownTouchY = event.getY(newPointerIndex);
                this.mActivePointerId = event.getPointerId(newPointerIndex);
                break;
            }
            case 2: {
                int pointerIndexMove = event.findPointerIndex(this.mActivePointerId);
                float xMove = event.getX(pointerIndexMove);
                float yMove = event.getY(pointerIndexMove);
                float dx = xMove - this.aDownTouchX;
                float dy = yMove - this.aDownTouchY;
                this.aPosX += dx;
                this.aPosY += dy;
                float distobjectX = this.aPosX - this.objectX;
                float rotation = this.BASE_ROTATION_DEGREES * 2.0f * distobjectX / (float)this.parentWidth;
                if (this.touchPosition == 1) {
                    rotation = -rotation;
                }
                this.frame.setX(this.aPosX);
                this.frame.setY(this.aPosY);
                this.frame.setRotation(rotation);
                this.mFlingListener.onScroll(this.getScrollProgressPercent());
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                view.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return true;
    }

    private float getScrollProgressPercent() {
        if (this.movedBeyondLeftBorder()) {
            return -1.0f;
        }
        if (this.movedBeyondRightBorder()) {
            return 1.0f;
        }
        float zeroToOneValue = (this.aPosX + this.halfWidth - this.leftBorder()) / (this.rightBorder() - this.leftBorder());
        return zeroToOneValue * 2.0f - 1.0f;
    }

    private boolean resetCardViewOnStack() {
        if (this.movedBeyondLeftBorder() && this.parentView.DETECT_LEFT_SWIPE) {
            this.onSelectedX(true, this.getExitPoint(-this.objectW), 100L);
            this.mFlingListener.onScroll(-1.0f);
        } else if (this.movedBeyondRightBorder() && this.parentView.DETECT_RIGHT_SWIPE) {
            this.onSelectedX(false, this.getExitPoint(this.parentWidth), 100L);
            this.mFlingListener.onScroll(1.0f);
        } else if (this.movedBeyondTopBorder() && this.parentView.DETECT_TOP_SWIPE) {
            this.onSelectedY(true, this.getExitPointX(-this.objectH), 100);
            this.mFlingListener.onScroll(-1.0f);
        } else if (this.movedBeyondBottomBorder() && this.parentView.DETECT_BOTTOM_SWIPE) {
            this.onSelectedY(false, this.getExitPointX(this.parentHeight), 100);
            this.mFlingListener.onScroll(1.0f);
        } else {
            float abslMoveDistance = Math.abs(this.aPosX - this.objectX);
            this.aPosX = 0.0f;
            this.aPosY = 0.0f;
            this.aDownTouchX = 0.0f;
            this.aDownTouchY = 0.0f;
            this.frame.animate().setDuration(200L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.5f)).x(this.objectX).y(this.objectY).rotation(0.0f);
            this.mFlingListener.onScroll(0.0f);
            if ((double)abslMoveDistance < 4.0) {
                this.mFlingListener.onClick(this.dataObject);
            }
        }
        return false;
    }

    private boolean movedBeyondLeftBorder() {
        int centerY;
        int centerX = (int)(this.frame.getX() + this.halfWidth);
        return this.RECT_LEFT.contains(centerX, centerY = (int)(this.frame.getY() + this.halfHeight)) || centerX < this.RECT_LEFT.left && this.RECT_LEFT.contains(0, centerY);
    }

    private boolean movedBeyondRightBorder() {
        int centerY;
        int centerX = (int)(this.frame.getX() + this.halfWidth);
        return this.RECT_RIGHT.contains(centerX, centerY = (int)(this.frame.getY() + this.halfHeight)) || centerX > this.RECT_RIGHT.right && this.RECT_RIGHT.contains(this.RECT_RIGHT.left, centerY);
    }

    private boolean movedBeyondBottomBorder() {
        int centerY;
        int centerX = (int)(this.frame.getX() + this.halfWidth);
        return this.RECT_BOTTOM.contains(centerX, centerY = (int)(this.frame.getY() + this.halfHeight)) || centerY > this.RECT_BOTTOM.bottom && this.RECT_BOTTOM.contains(centerX, this.RECT_BOTTOM.top);
    }

    private boolean movedBeyondTopBorder() {
        int centerY;
        int centerX = (int)(this.frame.getX() + this.halfWidth);
        return this.RECT_TOP.contains(centerX, centerY = (int)(this.frame.getY() + this.halfHeight)) || centerY < this.RECT_TOP.top && this.RECT_TOP.contains(centerX, 0);
    }

    private float leftBorder() {
        return (float)this.parentWidth / 4.0f;
    }

    private float rightBorder() {
        return (float)(3 * this.parentWidth) / 4.0f;
    }

    private float bottomBorder() {
        return (float)(3 * this.parentHeight) / 4.0f;
    }

    private float topBorder() {
        return (float)this.parentHeight / 4.0f;
    }

    private void onSelectedY(final boolean isTop, float exitX, int duration) {
        this.isAnimationRunning = true;
        float exitY = isTop ? (float)(-this.objectH) - this.getRotationWidthOffset() : (float)this.parentHeight + this.getRotationWidthOffset();
        this.frame.animate().setDuration((long)duration).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).x(exitX).y(exitY).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (isTop) {
                    FlingCardListener.this.mFlingListener.onCardExited();
                    FlingCardListener.this.mFlingListener.topExit(FlingCardListener.this.dataObject);
                } else {
                    FlingCardListener.this.mFlingListener.onCardExited();
                    FlingCardListener.this.mFlingListener.bottomExit(FlingCardListener.this.dataObject);
                }
                FlingCardListener.this.isAnimationRunning = false;
            }
        }).rotation(this.getVerticalExitRotation(isTop));
    }

    private void onSelectedX(final boolean isLeft, float exitY, long duration) {
        this.isAnimationRunning = true;
        float exitX = isLeft ? (float)(-this.objectW) - this.getRotationWidthOffset() : (float)this.parentWidth + this.getRotationWidthOffset();
        this.frame.animate().setDuration(duration).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).x(exitX).y(exitY).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (isLeft) {
                    FlingCardListener.this.mFlingListener.onCardExited();
                    FlingCardListener.this.mFlingListener.leftExit(FlingCardListener.this.dataObject);
                } else {
                    FlingCardListener.this.mFlingListener.onCardExited();
                    FlingCardListener.this.mFlingListener.rightExit(FlingCardListener.this.dataObject);
                }
                FlingCardListener.this.isAnimationRunning = false;
            }
        }).rotation(this.getHorizontalExitRotation(isLeft));
    }

    void selectLeft() {
        if (!this.isAnimationRunning) {
            this.onSelectedX(true, this.objectY, 200L);
        }
    }

    void selectRight() {
        if (!this.isAnimationRunning) {
            this.onSelectedX(false, this.objectY, 200L);
        }
    }

    void selectTop() {
        if (!this.isAnimationRunning) {
            this.onSelectedY(true, this.objectX, 200);
        }
    }

    void selectBottom() {
        if (!this.isAnimationRunning) {
            this.onSelectedY(false, this.objectX, 200);
        }
    }

    private float getExitPoint(int exitXPoint) {
        float[] x = new float[]{this.objectX, this.aPosX};
        float[] y = new float[]{this.objectY, this.aPosY};
        LinearRegression regression = new LinearRegression(x, y);
        return (float)regression.slope() * (float)exitXPoint + (float)regression.intercept();
    }

    private float getExitPointX(int exitYPoint) {
        float[] x = new float[]{this.objectX, this.aPosX};
        float[] y = new float[]{this.objectY, this.aPosY};
        LinearRegression regression = new LinearRegression(x, y);
        return (float)((double)((float)exitYPoint - (float)regression.intercept()) / regression.slope());
    }

    private float getHorizontalExitRotation(boolean isLeft) {
        float rotation = this.BASE_ROTATION_DEGREES * 2.0f * ((float)this.parentWidth - this.objectX) / (float)this.parentWidth;
        if (this.touchPosition == 1) {
            rotation = -rotation;
        }
        if (isLeft) {
            rotation = -rotation;
        }
        return rotation;
    }

    private float getVerticalExitRotation(boolean isTop) {
        float rotation = this.BASE_ROTATION_DEGREES * 2.0f * ((float)this.parentHeight - this.objectY) / (float)this.parentHeight;
        if (this.touchPosition == 1) {
            rotation = -rotation;
        }
        if (isTop) {
            rotation = -rotation;
        }
        return rotation;
    }

    private float getRotationWidthOffset() {
        return (float)this.objectW / this.MAX_COS - (float)this.objectW;
    }

    public void setRotationDegrees(float degrees) {
        this.BASE_ROTATION_DEGREES = degrees;
    }

    boolean isTouching() {
        return this.mActivePointerId != -1;
    }

    PointF getLastPoint() {
        return new PointF(this.aPosX, this.aPosY);
    }

    static interface FlingListener {
        public void onCardExited();

        public void leftExit(Object var1);

        public void rightExit(Object var1);

        public void onClick(Object var1);

        public void onScroll(float var1);

        public void topExit(Object var1);

        public void bottomExit(Object var1);
    }
}

