/*
 * Decompiled with CFR 0.152.
 */
package in.arjsna.swipecardlib;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import in.arjsna.swipecardlib.LinearRegression;

public class FlingPageListener
implements View.OnTouchListener {
    private static final String TAG = "FlingPageListener";
    private static final int INVALID_POINTER_ID = -1;
    private final Rect RECT_BOTTOM;
    private final Rect RECT_TOP;
    private final Rect RECT_RIGHT;
    private final Rect RECT_LEFT;
    private final View frame;
    private final float objectX;
    private final float objectY;
    private final int objectH;
    private final int objectW;
    private final float halfWidth;
    private final float halfHeight;
    private final Object dataObject;
    private final int parentWidth;
    private final int parentHeight;
    private final FlingListener mFlingListener;
    private int mActivePointerId = -1;
    private float aDownTouchX;
    private float aDownTouchY;
    private float aPosX;
    private float aPosY;
    private boolean isAnimationRunning = false;

    public FlingPageListener(View frame, Object itemAtPosition, FlingListener flingListener) {
        this.frame = frame;
        this.objectX = frame.getX();
        this.objectY = frame.getY();
        this.objectH = frame.getHeight();
        this.objectW = frame.getWidth();
        this.halfWidth = (float)this.objectW / 2.0f;
        this.halfHeight = (float)this.objectH / 2.0f;
        this.dataObject = itemAtPosition;
        this.parentWidth = ((ViewGroup)frame.getParent()).getWidth();
        this.parentHeight = ((ViewGroup)frame.getParent()).getHeight();
        this.mFlingListener = flingListener;
        this.RECT_TOP = new Rect((int)Math.max((float)frame.getLeft(), this.leftBorder()), 0, (int)Math.min((float)frame.getRight(), this.rightBorder()), (int)this.topBorder());
        this.RECT_BOTTOM = new Rect((int)Math.max((float)frame.getLeft(), this.leftBorder()), (int)this.bottomBorder(), (int)Math.min((float)frame.getRight(), this.rightBorder()), this.parentHeight);
        this.RECT_LEFT = new Rect(0, (int)Math.max((float)frame.getTop(), this.topBorder()), (int)this.leftBorder(), (int)Math.min((float)frame.getBottom(), this.bottomBorder()));
        this.RECT_RIGHT = new Rect((int)this.rightBorder(), (int)Math.max((float)frame.getTop(), this.topBorder()), this.parentWidth, (int)Math.min((float)frame.getBottom(), this.bottomBorder()));
    }

    public float leftBorder() {
        return (float)this.parentWidth / 4.0f;
    }

    public float rightBorder() {
        return (float)(3 * this.parentWidth) / 4.0f;
    }

    public float bottomBorder() {
        return (float)(3 * this.parentHeight) / 4.0f;
    }

    public float topBorder() {
        return (float)this.parentHeight / 4.0f;
    }

    public boolean onTouch(View view, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mActivePointerId = event.getPointerId(0);
                float x = 0.0f;
                float y = 0.0f;
                boolean success = false;
                try {
                    x = event.getX(this.mActivePointerId);
                    y = event.getY(this.mActivePointerId);
                    success = true;
                }
                catch (IllegalArgumentException e) {
                    Log.w((String)TAG, (String)("Exception in onTouch(view, event) : " + this.mActivePointerId), (Throwable)e);
                }
                if (success) {
                    this.aDownTouchX = x;
                    this.aDownTouchY = y;
                    if (this.aPosX == 0.0f) {
                        this.aPosX = this.frame.getX();
                    }
                    if (this.aPosY == 0.0f) {
                        this.aPosY = this.frame.getY();
                    }
                }
                view.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: {
                this.mActivePointerId = -1;
                this.resetCardViewOnStack();
                view.getParent().requestDisallowInterceptTouchEvent(false);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                int pointerIndex = (event.getAction() & 0xFF00) >> 8;
                int pointerId = event.getPointerId(pointerIndex);
                if (pointerId != this.mActivePointerId) break;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.aDownTouchX = event.getX(newPointerIndex);
                this.aDownTouchY = event.getY(newPointerIndex);
                this.mActivePointerId = event.getPointerId(newPointerIndex);
                break;
            }
            case 2: {
                int pointerIndexMove = event.findPointerIndex(this.mActivePointerId);
                float xMove = event.getX(pointerIndexMove);
                float yMove = event.getY(pointerIndexMove);
                float dx = xMove - this.aDownTouchX;
                float dy = yMove - this.aDownTouchY;
                this.aPosX += dx;
                this.aPosY += dy;
                this.frame.setY(this.aPosY);
                this.mFlingListener.onScroll(this.getScrollProgressPercent());
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                view.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return true;
    }

    private float getScrollProgressPercent() {
        if (this.movedBeyondTopBorder()) {
            return -1.0f;
        }
        if (this.movedBeyondBottomBorder()) {
            return 1.0f;
        }
        float zeroToOneValue = (this.aPosY + this.halfHeight - this.topBorder()) / (this.bottomBorder() - this.topBorder());
        return zeroToOneValue * 2.0f - 1.0f;
    }

    private boolean resetCardViewOnStack() {
        if (this.movedBeyondTopBorder()) {
            Log.i((String)"Swipe ", (String)"top");
            this.onSelectedY(true, 100);
            this.mFlingListener.onScroll(-1.0f);
        } else if (this.movedBeyondBottomBorder()) {
            Log.i((String)"Swipe ", (String)"bottom");
            this.onSelectedY(false, 100);
            this.mFlingListener.onScroll(1.0f);
        } else {
            float abslMoveDistance = Math.abs(this.aPosX - this.objectX);
            this.aPosX = 0.0f;
            this.aPosY = 0.0f;
            this.aDownTouchX = 0.0f;
            this.aDownTouchY = 0.0f;
            this.frame.animate().setDuration(200L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.5f)).x(this.objectX).y(this.objectY).rotation(0.0f);
            this.mFlingListener.onScroll(0.0f);
            if ((double)abslMoveDistance < 4.0) {
                this.mFlingListener.onClick(this.dataObject);
            }
        }
        return false;
    }

    private boolean movedBeyondBottomBorder() {
        int centerY;
        int centerX = (int)(this.frame.getX() + this.halfWidth);
        return this.RECT_BOTTOM.contains(centerX, centerY = (int)(this.frame.getY() + this.halfHeight)) || centerY > this.RECT_BOTTOM.bottom && this.RECT_BOTTOM.contains(centerX, this.RECT_BOTTOM.top);
    }

    private boolean movedBeyondTopBorder() {
        int centerY;
        int centerX = (int)(this.frame.getX() + this.halfWidth);
        return this.RECT_TOP.contains(centerX, centerY = (int)(this.frame.getY() + this.halfHeight)) || centerY < this.RECT_TOP.top && this.RECT_TOP.contains(centerX, 0);
    }

    private void onSelectedY(final boolean isTop, int duration) {
        this.isAnimationRunning = true;
        float exitY = isTop ? (float)(-this.objectH) : (float)this.parentHeight;
        this.frame.animate().setDuration((long)duration).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).y(exitY).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (isTop) {
                    FlingPageListener.this.mFlingListener.onCardExited();
                    FlingPageListener.this.mFlingListener.topExit(FlingPageListener.this.dataObject);
                } else {
                    FlingPageListener.this.mFlingListener.onCardExited();
                    FlingPageListener.this.mFlingListener.bottomExit(FlingPageListener.this.dataObject);
                }
                FlingPageListener.this.isAnimationRunning = false;
            }
        });
    }

    private float getExitPointX(int exitYPoint) {
        float[] x = new float[]{this.objectX, this.aPosX};
        float[] y = new float[]{this.objectY, this.aPosY};
        LinearRegression regression = new LinearRegression(y, x);
        return (float)regression.slope() * (float)exitYPoint + (float)regression.intercept();
    }

    public boolean isTouching() {
        return this.mActivePointerId != -1;
    }

    public PointF getLastPoint() {
        return new PointF(this.aPosX, this.aPosY);
    }

    protected static interface FlingListener {
        public void onCardExited();

        public void onClick(Object var1);

        public void onScroll(float var1);

        public void topExit(Object var1);

        public void bottomExit(Object var1);
    }
}

