/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zim.internal.util;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public final class ZIMSysUtil {
    private static final int BUFFER_SIZE = 65536;

    public static String getOsInfo() {
        StringBuilder oriInfo = new StringBuilder();
        oriInfo.append(Build.MANUFACTURER);
        oriInfo.append(":");
        oriInfo.append(Build.VERSION.RELEASE);
        oriInfo.append(":");
        oriInfo.append(Build.MODEL);
        oriInfo.append(":");
        oriInfo.append(Build.VERSION.SDK_INT);
        String finalInfo = oriInfo.toString().replaceAll(",", ".");
        return finalInfo;
    }

    public static String getVersion() {
        String version = Build.VERSION.RELEASE;
        version = version.replaceAll(",", ".");
        return version;
    }

    public static boolean loadSpecialLibrary(String customizeSoPath, Context context) {
        File soFile = new File(customizeSoPath);
        if (!soFile.exists()) {
            Log.e((String)"ZIM", (String)"failed to load the external so. ");
            return false;
        }
        try {
            System.load(customizeSoPath);
        }
        catch (UnsatisfiedLinkError e) {
            File soPath = ZIMSysUtil.getCustomizeLibDir(context, "ext");
            File targetSo = new File(soPath, soFile.getName());
            if (!targetSo.exists() || targetSo.length() != soFile.length()) {
                try {
                    ZIMSysUtil.copyFile(soFile, targetSo);
                }
                catch (Exception e1) {
                    Log.e((String)"ZIM", (String)String.format("copyFile from %s to %s failed", soFile, targetSo), (Throwable)e1);
                }
            }
            System.load(targetSo.getAbsolutePath());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File srcFile, File targetFile) throws IOException {
        File parentDir = targetFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int readSize;
            bis = new BufferedInputStream(new FileInputStream(srcFile));
            bos = new BufferedOutputStream(new FileOutputStream(targetFile, false));
            byte[] buffer = new byte[65536];
            int loopCount = 0;
            while ((readSize = bis.read(buffer, 0, 65536)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, readSize);
                if (++loopCount % 10 != 0) continue;
                ((BufferedOutputStream)bos).flush();
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return true;
    }

    private static File getCustomizeLibDir(Context context, String subDirName) {
        File rootDir = context.getDir("libs", 0);
        return new File(rootDir, subDirName);
    }
}

