/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zim.internal.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class Background
implements Application.ActivityLifecycleCallbacks {
    private static final long CHECK_DELAY = 10L;
    public static final String TAG = "BackgroundMonitor";
    private static Callback becameForeground = new Callback(){

        @Override
        public void invoke(Listener listener) {
            listener.onBecameForeground();
        }
    };
    private static Callback becameBackground = new Callback(){

        @Override
        public void invoke(Listener listener) {
            listener.onBecameBackground();
        }
    };
    private static Background instance = new Background();
    private boolean background;
    private Listeners listeners = new Listeners();
    private Application application;
    private boolean isInit = false;
    private Set<Integer> pageList = new HashSet<Integer>();
    private Set<Integer> pagePauseList = new HashSet<Integer>();
    private Lock lock = new ReentrantLock();

    Background() {
    }

    public boolean isInited() {
        return this.isInit;
    }

    public Background init(Application app) {
        this.uninit();
        this.application = app;
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.lock.lock();
        try {
            this.background = this.checkBackground();
            this.isInit = true;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public Background uninit() {
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.application = null;
        }
        this.lock.lock();
        try {
            this.pageList.clear();
            this.pagePauseList.clear();
            this.isInit = false;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public static Background get() {
        return instance;
    }

    public boolean isBackground() {
        return this.background;
    }

    public boolean isForeground() {
        return !this.background;
    }

    public Binding addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public void onActivityResumed(Activity activity) {
        int code = activity.hashCode();
        this.lock.lock();
        try {
            if (this.isInit) {
                this.handleActivityOpen(code);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onActivityPaused(Activity activity) {
        int code = activity.hashCode();
        this.lock.lock();
        try {
            if (this.isInit) {
                this.handleActivityPause(code);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onActivityStarted(Activity activity) {
        int code = activity.hashCode();
        this.lock.lock();
        try {
            if (this.isInit) {
                this.handleActivityOpen(code);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onActivityStopped(Activity activity) {
        int code = activity.hashCode();
        this.lock.lock();
        try {
            if (this.isInit) {
                this.handleActivityStop(code);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        int code = activity.hashCode();
        this.lock.lock();
        try {
            if (this.isInit) {
                this.handleActivityOpen(code);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        int code = activity.hashCode();
        this.lock.lock();
        try {
            if (this.isInit) {
                this.handleActivityStop(code);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleActivityOpen(int hashCode) {
        if (!this.pageList.contains(hashCode)) {
            this.pageList.add(hashCode);
            if (this.background) {
                this.background = false;
                this.listeners.each(becameForeground);
            }
        }
    }

    private void handleActivityPause(int hashCode) {
        if (!this.pagePauseList.contains(hashCode)) {
            this.pagePauseList.add(hashCode);
        }
    }

    private void handleActivityStop(int hashCode) {
        if (this.pageList.contains(hashCode)) {
            this.pageList.remove(hashCode);
            if (this.pageList.size() == 0) {
                if (!this.background) {
                    this.background = true;
                    this.listeners.each(becameBackground);
                }
            } else if (this.background) {
                this.background = false;
                this.listeners.each(becameForeground);
            }
        } else if (this.pageList.size() == 0) {
            if (this.pagePauseList.contains(hashCode) && !this.background) {
                this.background = true;
                this.listeners.each(becameBackground);
            }
        } else if (this.background) {
            this.background = false;
            this.listeners.each(becameForeground);
        }
        this.pagePauseList.remove(hashCode);
    }

    private boolean checkBackground() {
        String packageName = this.application.getPackageName();
        ActivityManager am = (ActivityManager)this.application.getSystemService("activity");
        ActivityManager.RunningAppProcessInfo outState = new ActivityManager.RunningAppProcessInfo();
        ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)outState);
        return outState.importance != 100 && outState.importance != 200;
    }

    private static class Listeners {
        private List<WeakReference<Listener>> listeners = new CopyOnWriteArrayList<WeakReference<Listener>>();

        private Listeners() {
        }

        public Binding add(Listener listener) {
            final WeakReference<Listener> wr = new WeakReference<Listener>(listener);
            this.listeners.add(wr);
            return new Binding(){

                @Override
                public void unbind() {
                    listeners.remove(wr);
                }
            };
        }

        public void each(Callback callback) {
            ArrayList<WeakReference<Listener>> toRemove = new ArrayList<WeakReference<Listener>>();
            Iterator<WeakReference<Listener>> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    WeakReference<Listener> wr = it.next();
                    Listener l = (Listener)wr.get();
                    if (l != null) {
                        callback.invoke(l);
                        continue;
                    }
                    toRemove.add(wr);
                }
                catch (Exception exc) {
                    Log.e((String)Background.TAG, (String)"Listener threw exception!", (Throwable)exc);
                }
            }
            if (!toRemove.isEmpty()) {
                this.listeners.removeAll(toRemove);
            }
        }
    }

    private static interface Callback {
        public void invoke(Listener var1);
    }

    public static interface Binding {
        public void unbind();
    }

    public static interface Listener {
        public void onBecameForeground();

        public void onBecameBackground();
    }
}

