/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zim.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import im.zego.zim.ZIM;
import im.zego.zim.callback.ZIMBlacklistCheckedCallback;
import im.zego.zim.callback.ZIMBlacklistQueriedCallback;
import im.zego.zim.callback.ZIMBlacklistUsersAddedCallback;
import im.zego.zim.callback.ZIMBlacklistUsersRemovedCallback;
import im.zego.zim.callback.ZIMCallAcceptanceSentCallback;
import im.zego.zim.callback.ZIMCallCancelSentCallback;
import im.zego.zim.callback.ZIMCallEndSentCallback;
import im.zego.zim.callback.ZIMCallInvitationListQueriedCallback;
import im.zego.zim.callback.ZIMCallInvitationSentCallback;
import im.zego.zim.callback.ZIMCallJoinSentCallback;
import im.zego.zim.callback.ZIMCallQuitSentCallback;
import im.zego.zim.callback.ZIMCallRejectionSentCallback;
import im.zego.zim.callback.ZIMCallingInvitationSentCallback;
import im.zego.zim.callback.ZIMCombineMessageDetailQueriedCallback;
import im.zego.zim.callback.ZIMConversationDeletedCallback;
import im.zego.zim.callback.ZIMConversationDraftSetCallback;
import im.zego.zim.callback.ZIMConversationListQueriedCallback;
import im.zego.zim.callback.ZIMConversationMarkSetCallback;
import im.zego.zim.callback.ZIMConversationMessageReceiptReadSentCallback;
import im.zego.zim.callback.ZIMConversationMessagesAllDeletedCallback;
import im.zego.zim.callback.ZIMConversationNotificationStatusSetCallback;
import im.zego.zim.callback.ZIMConversationPinnedListQueriedCallback;
import im.zego.zim.callback.ZIMConversationPinnedStateUpdatedCallback;
import im.zego.zim.callback.ZIMConversationQueriedCallback;
import im.zego.zim.callback.ZIMConversationTotalUnreadMessageCountClearedCallback;
import im.zego.zim.callback.ZIMConversationTotalUnreadMessageCountQueriedCallback;
import im.zego.zim.callback.ZIMConversationUnreadMessageCountClearedCallback;
import im.zego.zim.callback.ZIMConversationsAllDeletedCallback;
import im.zego.zim.callback.ZIMConversationsSearchedCallback;
import im.zego.zim.callback.ZIMEventHandler;
import im.zego.zim.callback.ZIMFileCacheClearedCallback;
import im.zego.zim.callback.ZIMFileCacheQueriedCallback;
import im.zego.zim.callback.ZIMFriendAddedCallback;
import im.zego.zim.callback.ZIMFriendAliasUpdatedCallback;
import im.zego.zim.callback.ZIMFriendApplicationAcceptedCallback;
import im.zego.zim.callback.ZIMFriendApplicationListQueriedCallback;
import im.zego.zim.callback.ZIMFriendApplicationRejectedCallback;
import im.zego.zim.callback.ZIMFriendApplicationSentCallback;
import im.zego.zim.callback.ZIMFriendAttributesUpdatedCallback;
import im.zego.zim.callback.ZIMFriendListQueriedCallback;
import im.zego.zim.callback.ZIMFriendsDeletedCallback;
import im.zego.zim.callback.ZIMFriendsInfoQueriedCallback;
import im.zego.zim.callback.ZIMFriendsRelationCheckedCallback;
import im.zego.zim.callback.ZIMFriendsSearchedCallback;
import im.zego.zim.callback.ZIMGroupAliasUpdatedCallback;
import im.zego.zim.callback.ZIMGroupApplicationListQueriedCallback;
import im.zego.zim.callback.ZIMGroupAttributesOperatedCallback;
import im.zego.zim.callback.ZIMGroupAttributesQueriedCallback;
import im.zego.zim.callback.ZIMGroupAvatarUrlUpdatedCallback;
import im.zego.zim.callback.ZIMGroupBeInviteModeUpdatedCallback;
import im.zego.zim.callback.ZIMGroupCreatedCallback;
import im.zego.zim.callback.ZIMGroupDismissedCallback;
import im.zego.zim.callback.ZIMGroupInfoQueriedCallback;
import im.zego.zim.callback.ZIMGroupInviteApplicationAcceptedCallback;
import im.zego.zim.callback.ZIMGroupInviteApplicationRejectedCallback;
import im.zego.zim.callback.ZIMGroupInviteApplicationsSentCallback;
import im.zego.zim.callback.ZIMGroupInviteModeUpdatedCallback;
import im.zego.zim.callback.ZIMGroupJoinApplicationAcceptedCallback;
import im.zego.zim.callback.ZIMGroupJoinApplicationRejectedCallback;
import im.zego.zim.callback.ZIMGroupJoinApplicationSentCallback;
import im.zego.zim.callback.ZIMGroupJoinModeUpdatedCallback;
import im.zego.zim.callback.ZIMGroupJoinedCallback;
import im.zego.zim.callback.ZIMGroupLeftCallback;
import im.zego.zim.callback.ZIMGroupListQueriedCallback;
import im.zego.zim.callback.ZIMGroupMemberCountQueriedCallback;
import im.zego.zim.callback.ZIMGroupMemberInfoQueriedCallback;
import im.zego.zim.callback.ZIMGroupMemberKickedCallback;
import im.zego.zim.callback.ZIMGroupMemberListQueriedCallback;
import im.zego.zim.callback.ZIMGroupMemberMutedListQueriedCallback;
import im.zego.zim.callback.ZIMGroupMemberNicknameUpdatedCallback;
import im.zego.zim.callback.ZIMGroupMemberRoleUpdatedCallback;
import im.zego.zim.callback.ZIMGroupMembersMutedCallback;
import im.zego.zim.callback.ZIMGroupMembersSearchedCallback;
import im.zego.zim.callback.ZIMGroupMessageReceiptMemberListQueriedCallback;
import im.zego.zim.callback.ZIMGroupMutedCallback;
import im.zego.zim.callback.ZIMGroupNameUpdatedCallback;
import im.zego.zim.callback.ZIMGroupNoticeUpdatedCallback;
import im.zego.zim.callback.ZIMGroupOwnerTransferredCallback;
import im.zego.zim.callback.ZIMGroupUsersInvitedCallback;
import im.zego.zim.callback.ZIMGroupsSearchedCallback;
import im.zego.zim.callback.ZIMLogUploadedCallback;
import im.zego.zim.callback.ZIMLoggedInCallback;
import im.zego.zim.callback.ZIMMediaDownloadedCallback;
import im.zego.zim.callback.ZIMMediaMessageSentCallback;
import im.zego.zim.callback.ZIMMessageDeletedCallback;
import im.zego.zim.callback.ZIMMessageExportedCallback;
import im.zego.zim.callback.ZIMMessageImportedCallback;
import im.zego.zim.callback.ZIMMessageInsertedCallback;
import im.zego.zim.callback.ZIMMessageLocalExtendedDataUpdatedCallback;
import im.zego.zim.callback.ZIMMessageQueriedCallback;
import im.zego.zim.callback.ZIMMessageReactionAddedCallback;
import im.zego.zim.callback.ZIMMessageReactionDeletedCallback;
import im.zego.zim.callback.ZIMMessageReactionUserListQueriedCallback;
import im.zego.zim.callback.ZIMMessageReceiptsInfoQueriedCallback;
import im.zego.zim.callback.ZIMMessageReceiptsReadSentCallback;
import im.zego.zim.callback.ZIMMessageRepliedListQueriedCallback;
import im.zego.zim.callback.ZIMMessageRevokedCallback;
import im.zego.zim.callback.ZIMMessageSentCallback;
import im.zego.zim.callback.ZIMMessageSentFullCallback;
import im.zego.zim.callback.ZIMMessagesGlobalSearchedCallback;
import im.zego.zim.callback.ZIMMessagesSearchedCallback;
import im.zego.zim.callback.ZIMRoomAllLeftCallback;
import im.zego.zim.callback.ZIMRoomAttributesBatchOperatedCallback;
import im.zego.zim.callback.ZIMRoomAttributesOperatedCallback;
import im.zego.zim.callback.ZIMRoomAttributesQueriedCallback;
import im.zego.zim.callback.ZIMRoomCreatedCallback;
import im.zego.zim.callback.ZIMRoomEnteredCallback;
import im.zego.zim.callback.ZIMRoomJoinedCallback;
import im.zego.zim.callback.ZIMRoomLeftCallback;
import im.zego.zim.callback.ZIMRoomMemberAttributesListQueriedCallback;
import im.zego.zim.callback.ZIMRoomMemberQueriedCallback;
import im.zego.zim.callback.ZIMRoomMembersAttributesOperatedCallback;
import im.zego.zim.callback.ZIMRoomMembersAttributesQueriedCallback;
import im.zego.zim.callback.ZIMRoomMembersQueriedCallback;
import im.zego.zim.callback.ZIMRoomOnlineMemberCountQueriedCallback;
import im.zego.zim.callback.ZIMRoomSwitchedCallback;
import im.zego.zim.callback.ZIMSelfUserInfoQueriedCallback;
import im.zego.zim.callback.ZIMSubscribedUserStatusListQueriedCallback;
import im.zego.zim.callback.ZIMTokenRenewedCallback;
import im.zego.zim.callback.ZIMUserAvatarUrlUpdatedCallback;
import im.zego.zim.callback.ZIMUserExtendedDataUpdatedCallback;
import im.zego.zim.callback.ZIMUserNameUpdatedCallback;
import im.zego.zim.callback.ZIMUserOfflinePushRuleUpdatedCallback;
import im.zego.zim.callback.ZIMUsersInfoQueriedCallback;
import im.zego.zim.callback.ZIMUsersStatusQueriedCallback;
import im.zego.zim.callback.ZIMUsersStatusSubscribedCallback;
import im.zego.zim.callback.ZIMUsersStatusUnsubscribedCallback;
import im.zego.zim.entity.ZIMAppConfig;
import im.zego.zim.entity.ZIMBlacklistQueryConfig;
import im.zego.zim.entity.ZIMCacheConfig;
import im.zego.zim.entity.ZIMCallAcceptConfig;
import im.zego.zim.entity.ZIMCallCancelConfig;
import im.zego.zim.entity.ZIMCallEndConfig;
import im.zego.zim.entity.ZIMCallInvitationQueryConfig;
import im.zego.zim.entity.ZIMCallInviteConfig;
import im.zego.zim.entity.ZIMCallJoinConfig;
import im.zego.zim.entity.ZIMCallQuitConfig;
import im.zego.zim.entity.ZIMCallRejectConfig;
import im.zego.zim.entity.ZIMCallingInviteConfig;
import im.zego.zim.entity.ZIMCombineMessage;
import im.zego.zim.entity.ZIMConversationBaseInfo;
import im.zego.zim.entity.ZIMConversationDeleteConfig;
import im.zego.zim.entity.ZIMConversationFilterOption;
import im.zego.zim.entity.ZIMConversationQueryConfig;
import im.zego.zim.entity.ZIMConversationSearchConfig;
import im.zego.zim.entity.ZIMConversationTotalUnreadMessageCountQueryConfig;
import im.zego.zim.entity.ZIMFileCacheClearConfig;
import im.zego.zim.entity.ZIMFileCacheQueryConfig;
import im.zego.zim.entity.ZIMFriendAddConfig;
import im.zego.zim.entity.ZIMFriendApplicationAcceptConfig;
import im.zego.zim.entity.ZIMFriendApplicationListQueryConfig;
import im.zego.zim.entity.ZIMFriendApplicationRejectConfig;
import im.zego.zim.entity.ZIMFriendApplicationSendConfig;
import im.zego.zim.entity.ZIMFriendDeleteConfig;
import im.zego.zim.entity.ZIMFriendListQueryConfig;
import im.zego.zim.entity.ZIMFriendRelationCheckConfig;
import im.zego.zim.entity.ZIMFriendSearchConfig;
import im.zego.zim.entity.ZIMGroupAdvancedConfig;
import im.zego.zim.entity.ZIMGroupApplicationListQueryConfig;
import im.zego.zim.entity.ZIMGroupInfo;
import im.zego.zim.entity.ZIMGroupInviteApplicationAcceptConfig;
import im.zego.zim.entity.ZIMGroupInviteApplicationRejectConfig;
import im.zego.zim.entity.ZIMGroupInviteApplicationSendConfig;
import im.zego.zim.entity.ZIMGroupJoinApplicationAcceptConfig;
import im.zego.zim.entity.ZIMGroupJoinApplicationRejectConfig;
import im.zego.zim.entity.ZIMGroupJoinApplicationSendConfig;
import im.zego.zim.entity.ZIMGroupMemberMuteConfig;
import im.zego.zim.entity.ZIMGroupMemberMutedListQueryConfig;
import im.zego.zim.entity.ZIMGroupMemberQueryConfig;
import im.zego.zim.entity.ZIMGroupMemberSearchConfig;
import im.zego.zim.entity.ZIMGroupMessageReceiptMemberQueryConfig;
import im.zego.zim.entity.ZIMGroupMuteConfig;
import im.zego.zim.entity.ZIMGroupSearchConfig;
import im.zego.zim.entity.ZIMLogConfig;
import im.zego.zim.entity.ZIMLoginConfig;
import im.zego.zim.entity.ZIMMediaMessage;
import im.zego.zim.entity.ZIMMessage;
import im.zego.zim.entity.ZIMMessageDeleteConfig;
import im.zego.zim.entity.ZIMMessageExportConfig;
import im.zego.zim.entity.ZIMMessageImportConfig;
import im.zego.zim.entity.ZIMMessageQueryConfig;
import im.zego.zim.entity.ZIMMessageReactionUserQueryConfig;
import im.zego.zim.entity.ZIMMessageRepliedListQueryConfig;
import im.zego.zim.entity.ZIMMessageRevokeConfig;
import im.zego.zim.entity.ZIMMessageSearchConfig;
import im.zego.zim.entity.ZIMMessageSendConfig;
import im.zego.zim.entity.ZIMRoomAdvancedConfig;
import im.zego.zim.entity.ZIMRoomAttributesBatchOperationConfig;
import im.zego.zim.entity.ZIMRoomAttributesDeleteConfig;
import im.zego.zim.entity.ZIMRoomAttributesSetConfig;
import im.zego.zim.entity.ZIMRoomInfo;
import im.zego.zim.entity.ZIMRoomMemberAttributesQueryConfig;
import im.zego.zim.entity.ZIMRoomMemberAttributesSetConfig;
import im.zego.zim.entity.ZIMRoomMemberQueryConfig;
import im.zego.zim.entity.ZIMSubscribedUserStatusQueryConfig;
import im.zego.zim.entity.ZIMUserInfo;
import im.zego.zim.entity.ZIMUserOfflinePushRule;
import im.zego.zim.entity.ZIMUserStatusSubscribeConfig;
import im.zego.zim.entity.ZIMUsersInfoQueryConfig;
import im.zego.zim.enums.ZIMConversationNotificationStatus;
import im.zego.zim.enums.ZIMConversationType;
import im.zego.zim.enums.ZIMGeofencingType;
import im.zego.zim.enums.ZIMGroupBeInviteMode;
import im.zego.zim.enums.ZIMGroupInviteMode;
import im.zego.zim.enums.ZIMGroupJoinMode;
import im.zego.zim.enums.ZIMMediaFileType;
import im.zego.zim.internal.generated.ZIMBridge;
import im.zego.zim.internal.generated.ZIMCovert;
import im.zego.zim.internal.generated.ZIMGenMethod;
import im.zego.zim.internal.util.ZIMLogUtil;
import im.zego.zim.internal.util.ZIMSysUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class ZIMImpl
extends ZIM {
    private AtomicInteger sequence = new AtomicInteger(0);
    public static final Handler uiHandler = new Handler(Looper.getMainLooper());
    private static final ConcurrentHashMap<Long, ZIMImpl> zimHandleMap = new ConcurrentHashMap();
    private final long handle;
    public final Context context;
    public ZIMEventHandler eventHandler;
    public final HashMap<Integer, Object> commonCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessage> messageObjMap = new HashMap();
    public final HashMap<Integer, ZIMLogUploadedCallback> logUploadedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMLoggedInCallback> loggedInCallbacks = new HashMap();
    public final HashMap<Integer, ZIMTokenRenewedCallback> tokenRenewedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMUserNameUpdatedCallback> userNameUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMUserAvatarUrlUpdatedCallback> userAvatarUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMUserExtendedDataUpdatedCallback> userExtendedDataUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMUserOfflinePushRuleUpdatedCallback> userOfflinePushRuleInfoUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMSelfUserInfoQueriedCallback> selfUserInfoQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMUsersInfoQueriedCallback> usersInfoQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessageQueriedCallback> messageQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessagesGlobalSearchedCallback> messageGlobalSearchCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessagesSearchedCallback> messageSearchCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationsSearchedCallback> conversationMessageGlobalSearchCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessageLocalExtendedDataUpdatedCallback> messageLocalExtendedDataUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessageSentCallback> messageSentCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMediaMessageSentCallback> mediaMessageSentCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMediaDownloadedCallback> mediaDownloadedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomCreatedCallback> roomCreatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomJoinedCallback> roomJoinedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomEnteredCallback> roomEnteredCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomSwitchedCallback> roomSwitchedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomLeftCallback> roomLeftCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomAllLeftCallback> allRoomLeftCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomOnlineMemberCountQueriedCallback> onlineCountQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomMemberQueriedCallback> roomMemberQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomMembersQueriedCallback> roomMembersQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessageDeletedCallback> messageDeletedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationMessagesAllDeletedCallback> conversationMessagesAllDeletedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationListQueriedCallback> conversationListQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationQueriedCallback> conversationQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationPinnedListQueriedCallback> conversationPinnedListQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationPinnedStateUpdatedCallback> conversationPinnedStateUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationDeletedCallback> conversationDeletedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationsAllDeletedCallback> conversationsAllDeletedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationUnreadMessageCountClearedCallback> conversationUnreadMessageCountClearedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationTotalUnreadMessageCountClearedCallback> conversationsAllUnreadMessageCountClearedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMConversationNotificationStatusSetCallback> conversationNotificationStatusSetCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomAttributesOperatedCallback> roomAttributesOperatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomAttributesBatchOperatedCallback> roomAttributesBatchOperatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomAttributesQueriedCallback> roomAllAttributesQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomMemberAttributesListQueriedCallback> roomMemberAttributesListQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomMembersAttributesOperatedCallback> roomMembersAttributesOperatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMRoomMembersAttributesQueriedCallback> roomMembersAttributesQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupCreatedCallback> groupCreatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupDismissedCallback> groupDismissedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupJoinedCallback> groupJoinedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupLeftCallback> groupLeftCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupUsersInvitedCallback> groupUsersInvitedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMemberKickedCallback> groupMemberKickedoutCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupOwnerTransferredCallback> groupOwnerTransferredCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupNameUpdatedCallback> groupNameUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupAvatarUrlUpdatedCallback> groupAvatarUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupAliasUpdatedCallback> groupAliasUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupNoticeUpdatedCallback> groupNoticeUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupJoinModeUpdatedCallback> groupJoinModeUpdateCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupInviteModeUpdatedCallback> groupInviteModeUpdateCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupBeInviteModeUpdatedCallback> groupBeInviteModeUpdateCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMutedCallback> groupMutedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMembersMutedCallback> groupMembersMutedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMemberMutedListQueriedCallback> groupMemberMutedListQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupInfoQueriedCallback> groupInfoQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupAttributesOperatedCallback> groupAttributesOperatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupAttributesQueriedCallback> groupAttributesQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMemberRoleUpdatedCallback> groupMemberRoleUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMemberNicknameUpdatedCallback> groupMemberNicknameUpdatedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMemberInfoQueriedCallback> groupMemberInfoQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupListQueriedCallback> groupListQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMemberListQueriedCallback> groupMemberListQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMemberCountQueriedCallback> groupMemberCountQueriedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMCallInvitationSentCallback> callInvitationSentCallback = new HashMap();
    public final HashMap<Integer, ZIMCallingInvitationSentCallback> callingInvitationSentCallback = new HashMap();
    public final HashMap<Integer, ZIMCallJoinSentCallback> callJoinSentCallback = new HashMap();
    public final HashMap<Integer, ZIMCallQuitSentCallback> callQuitSentCallback = new HashMap();
    public final HashMap<Integer, ZIMCallEndSentCallback> callEndSentCallback = new HashMap();
    public final HashMap<Integer, ZIMCallInvitationListQueriedCallback> callListQueriedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendAddedCallback> friendAddedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendsRelationCheckedCallback> friendCheckedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendsDeletedCallback> friendDeletedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendAliasUpdatedCallback> friendAliasCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendsInfoQueriedCallback> friendQueriedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendApplicationRejectedCallback> friendApplicationRejectedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendListQueriedCallback> friendListQueriedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendApplicationListQueriedCallback> friendApplicationListQueriedCallback = new HashMap();
    public final HashMap<Integer, ZIMBlacklistUsersRemovedCallback> blacklistUsersRemovedCallback = new HashMap();
    public final HashMap<Integer, ZIMBlacklistQueriedCallback> blacklistQueriedCallback = new HashMap();
    public final HashMap<Integer, ZIMBlacklistCheckedCallback> blacklistCheckedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendsSearchedCallback> friendSearchedCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMBlacklistUsersAddedCallback> blacklistUsersAddedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendApplicationAcceptedCallback> friendApplicationAcceptedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendAttributesUpdatedCallback> friendAttributesUpdatedCallback = new HashMap();
    public final HashMap<Integer, ZIMFriendApplicationSentCallback> sendFriendAddedCallback = new HashMap();
    public final HashMap<Integer, ZIMCallCancelSentCallback> callCancelSentCallback = new HashMap();
    public final HashMap<Integer, ZIMCallAcceptanceSentCallback> callAcceptanceSentCallback = new HashMap();
    public final HashMap<Integer, ZIMCallRejectionSentCallback> callRejectionSentCallback = new HashMap();
    public final HashMap<Integer, ZIMMessageInsertedCallback> messageInsertedCallback = new HashMap();
    public final HashMap<Integer, ZIMMessageRevokedCallback> messageRevokedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessageReceiptsReadSentCallback> messageReceiptsReadCallback = new HashMap();
    public final HashMap<Integer, ZIMConversationMessageReceiptReadSentCallback> conversationReceiptReadCallback = new HashMap();
    public final HashMap<Integer, ZIMMessageImportedCallback> messageImportedCallback = new HashMap();
    public final HashMap<Integer, ZIMMessageExportedCallback> messageExportedCallback = new HashMap();
    public final HashMap<Integer, ZIMFileCacheClearedCallback> fileCacheClearedCallback = new HashMap();
    public final HashMap<Integer, ZIMFileCacheQueriedCallback> fileCacheQueriedCallback = new HashMap();
    public final HashMap<Integer, ZIMConversationDraftSetCallback> conversationDraftSetCallback = new HashMap();
    public final HashMap<Integer, ZIMConversationMarkSetCallback> conversationMarkSetCallback = new HashMap();
    public final HashMap<Integer, ZIMConversationTotalUnreadMessageCountQueriedCallback> conversationTotalUnreadMessageCountQueriedCallback = new HashMap();
    public final HashMap<Integer, ZIMMessageReceiptsInfoQueriedCallback> messageReceiptsInfoQueriedCallback = new HashMap();
    public final HashMap<Integer, ZIMMessageReactionAddedCallback> messageReactionAddCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMMessageReactionDeletedCallback> messageReactionDeleteCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMCombineMessageDetailQueriedCallback> combineMessageDetailQueriedCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMMessageReactionUserListQueriedCallback> messageReactionUsersQueryCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMGroupMessageReceiptMemberListQueriedCallback> groupMessageReceiptMemberListCallback = new HashMap();
    public final HashMap<Integer, ZIMGroupsSearchedCallback> groupsSearchedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMGroupMembersSearchedCallback> groupMembersSearchedCallbacks = new HashMap();
    public final HashMap<Integer, ZIMMessageSentFullCallback> sentFullCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMMessageRepliedListQueriedCallback> repliedListQueriedCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMUsersStatusQueriedCallback> usersStatusQueriedCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMUsersStatusSubscribedCallback> usersStatusSubscribedCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMUsersStatusUnsubscribedCallback> usersStatusUnsubscribedCallbackHashMap = new HashMap();
    public final HashMap<Integer, ZIMSubscribedUserStatusListQueriedCallback> subscribedUserStatusListQueriedCallbackHashMap = new HashMap();
    ZIMBridge zimBridge;

    private ZIMImpl(long handle, Context context) {
        this.handle = handle;
        this.context = context;
        this.zimBridge = new ZIMBridge();
        zimHandleMap.put(handle, this);
    }

    public static ZIMImpl getZIMInstance() {
        long handle = ZIMGenMethod.getInstance();
        if (handle == 0L) {
            return null;
        }
        return zimHandleMap.get(handle);
    }

    public static ZIMImpl getInstance(long handle) {
        return zimHandleMap.get(handle);
    }

    public static String getVersion() {
        return ZIMGenMethod.getVersion();
    }

    public static ZIM createZIM(ZIMAppConfig config, Context context) {
        if (!"2.18.2.3019".equals(ZIMImpl.getVersion())) {
            throw new RuntimeException("[ZEGO] The version of SDK jar and native shared library (.so) does not match!");
        }
        if (context == null) {
            throw new RuntimeException("[ZEGO] Android application context not set!");
        }
        if (config == null) {
            config = new ZIMAppConfig();
        }
        ZIMLogUtil.setContext(context);
        long handle = ZIMImpl.create(config.appID, config.appSign, context);
        if (handle != 0L) {
            return new ZIMImpl(handle, context);
        }
        return null;
    }

    public static void setPushID(String pushID) {
        ZIMGenMethod.setPushID(pushID);
    }

    @Override
    public void destroy() {
        zimHandleMap.remove(this.handle);
        ZIMGenMethod.destroy(this.handle);
    }

    public static void setAdvancedConfig(String key, String value) {
        ZIMGenMethod.setAdvancedConfig(key, value);
    }

    public static boolean setGeofencingConfig(ArrayList<Integer> areaList, ZIMGeofencingType type) {
        return ZIMGenMethod.setGeofencingConfig(type.value(), areaList);
    }

    public static void setLogConfig(ZIMLogConfig config) {
        ZIMGenMethod.setLogConfig(config.logPath, config.logSize);
    }

    @Override
    public void uploadLog(ZIMLogUploadedCallback callback) {
        int sequence = this.genSeq();
        this.logUploadedCallbacks.put(sequence, callback);
        ZIMGenMethod.uploadLog(this.handle, sequence);
    }

    public static void setCacheConfig(ZIMCacheConfig config) {
        ZIMGenMethod.setCacheConfig(config.cachePath);
    }

    @Override
    public void setEventHandler(ZIMEventHandler handler) {
        this.eventHandler = handler;
    }

    @Override
    public void login(ZIMUserInfo userInfo, ZIMLoggedInCallback callback) {
        int sequence = this.genSeq();
        this.loggedInCallbacks.put(sequence, callback);
        ZIMLoginConfig config = new ZIMLoginConfig();
        config.userName = userInfo.userName;
        config.token = "";
        config.isOfflineLogin = false;
        ZIMGenMethod.login(this.handle, userInfo.userID, ZIMCovert.loginConfigToGenLoginConfig(config), sequence);
    }

    private int genSeq() {
        return this.sequence.incrementAndGet();
    }

    @Override
    public void login(ZIMUserInfo userInfo, String token, ZIMLoggedInCallback callback) {
        int sequence = this.genSeq();
        this.loggedInCallbacks.put(sequence, callback);
        ZIMLoginConfig config = new ZIMLoginConfig();
        config.userName = userInfo.userName;
        config.token = token;
        config.isOfflineLogin = false;
        ZIMGenMethod.login(this.handle, userInfo.userID, ZIMCovert.loginConfigToGenLoginConfig(config), sequence);
    }

    @Override
    public void login(String userID, ZIMLoginConfig config, ZIMLoggedInCallback callback) {
        int sequence = this.genSeq();
        this.loggedInCallbacks.put(sequence, callback);
        ZIMGenMethod.login(this.handle, userID, ZIMCovert.loginConfigToGenLoginConfig(config), sequence);
    }

    @Override
    public void logout() {
        ZIMGenMethod.logout(this.handle);
    }

    @Override
    public void renewToken(String token, ZIMTokenRenewedCallback callback) {
        int sequence = this.genSeq();
        this.tokenRenewedCallbacks.put(sequence, callback);
        ZIMGenMethod.renewToken(this.handle, token, sequence);
    }

    @Override
    public void updateUserName(String name, ZIMUserNameUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.userNameUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateUserName(this.handle, name, sequence);
    }

    @Override
    public void updateUserAvatarUrl(String userAvatarUrl, ZIMUserAvatarUrlUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.userAvatarUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateUserAvatarUrl(this.handle, userAvatarUrl, sequence);
    }

    @Override
    public void updateUserExtendedData(String extendedData, ZIMUserExtendedDataUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.userExtendedDataUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateUserExtendedData(this.handle, extendedData, sequence);
    }

    @Override
    public void updateUserOfflinePushRule(ZIMUserOfflinePushRule offlinePushRule, ZIMUserOfflinePushRuleUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.userOfflinePushRuleInfoUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateUserOfflinePushRule(this.handle, ZIMCovert.getGenUserOfflinePushRule(offlinePushRule), sequence);
    }

    @Override
    public void queryUsersStatus(ArrayList<String> userIDs, ZIMUsersStatusQueriedCallback callback) {
        int sequence = this.genSeq();
        this.usersStatusQueriedCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.queryUsersStatus(this.handle, userIDs, sequence);
    }

    @Override
    public void subscribeUsersStatus(ArrayList<String> userIDs, ZIMUserStatusSubscribeConfig config, ZIMUsersStatusSubscribedCallback callback) {
        int sequence = this.genSeq();
        this.usersStatusSubscribedCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.subscribeUsersStatus(this.handle, userIDs, ZIMCovert.getZIMGenUserStatusSubscribeConfig(config), sequence);
    }

    @Override
    public void unsubscribeUsersStatus(ArrayList<String> userIDs, ZIMUsersStatusUnsubscribedCallback callback) {
        int sequence = this.genSeq();
        this.usersStatusUnsubscribedCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.unsubscribeUserStatus(this.handle, userIDs, sequence);
    }

    @Override
    public void querySubscribedUserStatusList(ZIMSubscribedUserStatusQueryConfig config, ZIMSubscribedUserStatusListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.subscribedUserStatusListQueriedCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.querySubscribedUserStatusList(this.handle, ZIMCovert.getZIMGenSubscribedUserStatusQueryConfig(config), sequence);
    }

    @Override
    public void queryUsersInfo(List<String> userIDList, ZIMUsersInfoQueryConfig config, ZIMUsersInfoQueriedCallback callback) {
        int sequence = this.genSeq();
        this.usersInfoQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryUsersInfo(this.handle, ZIMCovert.listToArrayList(userIDList), ZIMCovert.usersInfoQueryConfigToGenUsersInfoQueryConfig(config), sequence);
    }

    @Override
    public void querySelfUserInfo(ZIMSelfUserInfoQueriedCallback callback) {
        int sequence = this.genSeq();
        this.selfUserInfoQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.querySelfUserInfo(this.handle, sequence);
    }

    @Override
    public void sendPeerMessage(ZIMMessage message, String toUserID, ZIMMessageSendConfig config, ZIMMessageSentCallback callback) {
        int sequence = this.genSeq();
        this.messageSentCallbacks.put(sequence, callback);
        if (message.getMessageID() == 0L && message.getLocalMessageID() == 0L) {
            this.messageObjMap.put(sequence, message);
        }
        ZIMGenMethod.sendPeerMessage(this.handle, ZIMCovert.getGenMessage(message), toUserID, ZIMCovert.sendConfigToGenSendConfig(config), sequence);
    }

    @Override
    public void sendRoomMessage(ZIMMessage message, String toRoomID, ZIMMessageSendConfig config, ZIMMessageSentCallback callback) {
        int sequence = this.genSeq();
        this.messageSentCallbacks.put(sequence, callback);
        if (message.getMessageID() == 0L && message.getLocalMessageID() == 0L) {
            this.messageObjMap.put(sequence, message);
        }
        ZIMGenMethod.sendRoomMessage(this.handle, ZIMCovert.getGenMessage(message), toRoomID, ZIMCovert.sendConfigToGenSendConfig(config), sequence);
    }

    @Override
    public void sendGroupMessage(ZIMMessage message, String toGroupID, ZIMMessageSendConfig config, ZIMMessageSentCallback callback) {
        int sequence = this.genSeq();
        this.messageSentCallbacks.put(sequence, callback);
        if (message.getMessageID() == 0L && message.getLocalMessageID() == 0L) {
            this.messageObjMap.put(sequence, message);
        }
        ZIMGenMethod.sendGroupMessage(this.handle, ZIMCovert.getGenMessage(message), toGroupID, ZIMCovert.sendConfigToGenSendConfig(config), sequence);
    }

    @Override
    public void sendMessage(ZIMMessage message, String toConversationID, ZIMConversationType conversationType, ZIMMessageSendConfig config, ZIMMessageSentCallback callback) {
        int sequence = this.genSeq();
        this.messageSentCallbacks.put(sequence, callback);
        if (message.getMessageID() == 0L && message.getLocalMessageID() == 0L) {
            this.messageObjMap.put(sequence, message);
        }
        ZIMGenMethod.sendMessage(this.handle, ZIMCovert.getGenMessage(message), toConversationID, conversationType.value(), ZIMCovert.sendConfigToGenSendConfig(config), sequence);
    }

    @Override
    public void sendMediaMessage(ZIMMediaMessage message, String toConversationID, ZIMConversationType conversationType, ZIMMessageSendConfig config, ZIMMediaMessageSentCallback callback) {
        int sequence = this.genSeq();
        this.mediaMessageSentCallbacks.put(sequence, callback);
        if (message.getMessageID() == 0L && message.getLocalMessageID() == 0L) {
            this.messageObjMap.put(sequence, message);
        }
        ZIMGenMethod.sendMediaMessage(this.handle, ZIMCovert.getGenMessage(message), toConversationID, conversationType.value(), ZIMCovert.sendConfigToGenSendConfig(config), sequence);
    }

    @Override
    public void downloadMediaFile(ZIMMediaMessage message, ZIMMediaFileType type, ZIMMediaDownloadedCallback callback) {
        int sequence = this.genSeq();
        this.messageObjMap.put(sequence, message);
        this.mediaDownloadedCallbacks.put(sequence, callback);
        ZIMGenMethod.downloadMediaFile(this.handle, ZIMCovert.getGenMessage(message), type.value(), sequence);
    }

    @Override
    public void sendMessageReceiptsRead(List<ZIMMessage> messageList, String conversationID, ZIMConversationType conversationType, ZIMMessageReceiptsReadSentCallback callback) {
        int sequence = this.genSeq();
        this.messageReceiptsReadCallback.put(sequence, callback);
        ZIMGenMethod.sendMessageReceiptsRead(this.handle, ZIMCovert.zimMessageListToGenMessageList(messageList), conversationID, conversationType.value(), sequence);
    }

    @Override
    public void queryMessageReceiptsInfo(List<ZIMMessage> messageList, String conversationID, ZIMConversationType conversationType, ZIMMessageReceiptsInfoQueriedCallback callback) {
        int sequence = this.genSeq();
        this.messageReceiptsInfoQueriedCallback.put(sequence, callback);
        ZIMGenMethod.queryMessageReceiptsInfo(this.handle, ZIMCovert.zimMessageListToGenMessageList(messageList), conversationID, conversationType.value(), sequence);
    }

    @Override
    public void addMessageReaction(String reactionType, ZIMMessage message, ZIMMessageReactionAddedCallback callback) {
        int sequence = this.genSeq();
        this.messageReactionAddCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.addMessageReaction(this.handle, reactionType, ZIMCovert.getGenMessage(message), sequence);
    }

    @Override
    public void deleteMessageReaction(String reactionType, ZIMMessage message, ZIMMessageReactionDeletedCallback callback) {
        int sequence = this.genSeq();
        this.messageReactionDeleteCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.deleteMessageReaction(this.handle, reactionType, ZIMCovert.getGenMessage(message), sequence);
    }

    @Override
    public void queryMessageReactionUserList(ZIMMessage message, ZIMMessageReactionUserQueryConfig config, ZIMMessageReactionUserListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.messageReactionUsersQueryCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.queryMessageReactionUserList(this.handle, ZIMCovert.getGenMessage(message), ZIMCovert.getGenMessageReactionUserQueryConfig(config), sequence);
    }

    @Override
    public void createRoom(ZIMRoomInfo roomInfo, ZIMRoomCreatedCallback callback) {
        int sequence = this.genSeq();
        this.roomCreatedCallbacks.put(sequence, callback);
        ZIMGenMethod.createRoom(this.handle, ZIMCovert.roomAdvancedConfigToGenRoomAdvancedConfig(null), ZIMCovert.roomInfoToGenRoomInfo(roomInfo), sequence);
    }

    @Override
    public void createRoom(ZIMRoomInfo roomInfo, ZIMRoomAdvancedConfig config, ZIMRoomCreatedCallback callback) {
        int sequence = this.genSeq();
        this.roomCreatedCallbacks.put(sequence, callback);
        ZIMGenMethod.createRoom(this.handle, ZIMCovert.roomAdvancedConfigToGenRoomAdvancedConfig(config), ZIMCovert.roomInfoToGenRoomInfo(roomInfo), sequence);
    }

    @Override
    public void joinRoom(String roomID, ZIMRoomJoinedCallback callback) {
        int sequence = this.genSeq();
        this.roomJoinedCallbacks.put(sequence, callback);
        ZIMGenMethod.joinRoom(this.handle, roomID, sequence);
    }

    @Override
    public void enterRoom(ZIMRoomInfo roomInfo, ZIMRoomAdvancedConfig config, ZIMRoomEnteredCallback callback) {
        int sequence = this.genSeq();
        this.roomEnteredCallbacks.put(sequence, callback);
        ZIMGenMethod.enterRoom(this.handle, ZIMCovert.roomInfoToGenRoomInfo(roomInfo), ZIMCovert.roomAdvancedConfigToGenRoomAdvancedConfig(config), sequence);
    }

    @Override
    public void switchRoom(String fromRoomID, ZIMRoomInfo toRoomInfo, boolean isCreateWhenRoomNotExisted, ZIMRoomAdvancedConfig config, ZIMRoomSwitchedCallback callback) {
        int sequence = this.genSeq();
        this.roomSwitchedCallbacks.put(sequence, callback);
        ZIMGenMethod.switchRoom(this.handle, fromRoomID, ZIMCovert.roomInfoToGenRoomInfo(toRoomInfo), isCreateWhenRoomNotExisted, ZIMCovert.roomAdvancedConfigToGenRoomAdvancedConfig(config), sequence);
    }

    @Override
    public void leaveRoom(String roomID, ZIMRoomLeftCallback callback) {
        int sequence = this.genSeq();
        this.roomLeftCallbacks.put(sequence, callback);
        ZIMGenMethod.leaveRoom(this.handle, roomID, sequence);
    }

    @Override
    public void leaveAllRoom(ZIMRoomAllLeftCallback callback) {
        int sequence = this.genSeq();
        this.allRoomLeftCallbacks.put(sequence, callback);
        ZIMGenMethod.leaveAllRoom(this.handle, sequence);
    }

    @Override
    public void queryRoomMemberList(String roomID, ZIMRoomMemberQueryConfig config, ZIMRoomMemberQueriedCallback callback) {
        int sequence = this.genSeq();
        this.roomMemberQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryRoomMemberList(this.handle, roomID, ZIMCovert.roomMemberQueryConfigToGenRoomMemberQueryConfig(config), sequence);
    }

    @Override
    public void queryRoomMembers(ArrayList<String> userIDs, String roomId, ZIMRoomMembersQueriedCallback callback) {
        int sequence = this.genSeq();
        this.roomMembersQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryRoomMembers(this.handle, userIDs, roomId, sequence);
    }

    @Override
    public void queryRoomOnlineMemberCount(String roomID, ZIMRoomOnlineMemberCountQueriedCallback callback) {
        int sequence = this.genSeq();
        this.onlineCountQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryRoomOnlineMemberCount(this.handle, roomID, sequence);
    }

    @Override
    public void setRoomAttributes(HashMap<String, String> roomAttributes, String roomID, ZIMRoomAttributesSetConfig config, ZIMRoomAttributesOperatedCallback callback) {
        int sequence = this.genSeq();
        this.roomAttributesOperatedCallbacks.put(sequence, callback);
        ZIMGenMethod.setRoomAttributes(this.handle, roomAttributes, roomID, ZIMCovert.roomAttributesSetConfigToGenRoomAttributesSetConfig(config), sequence);
    }

    @Override
    public void deleteRoomAttributes(List<String> keys, String roomID, ZIMRoomAttributesDeleteConfig config, ZIMRoomAttributesOperatedCallback callback) {
        int sequence = this.genSeq();
        this.roomAttributesOperatedCallbacks.put(sequence, callback);
        ZIMGenMethod.deleteRoomAttributes(this.handle, ZIMCovert.listToArrayList(keys), roomID, ZIMCovert.roomAttributesDeleteConfigToGenRoomAttributesDeleteConfig(config), sequence);
    }

    @Override
    public void beginRoomAttributesBatchOperation(String roomID, ZIMRoomAttributesBatchOperationConfig config) {
        int sequence = this.genSeq();
        ZIMGenMethod.beginRoomAttributesBatchOperation(this.handle, roomID, ZIMCovert.roomAttributesBatchOperationConfigToGenRoomAttributesBatchOperationConfig(config), sequence);
    }

    @Override
    public void endRoomAttributesBatchOperation(String roomID, ZIMRoomAttributesBatchOperatedCallback callback) {
        int sequence = this.genSeq();
        this.roomAttributesBatchOperatedCallbacks.put(sequence, callback);
        ZIMGenMethod.endRoomAttributesBatchOperation(this.handle, roomID, sequence);
    }

    @Override
    public void queryRoomAllAttributes(String roomID, ZIMRoomAttributesQueriedCallback callback) {
        int sequence = this.genSeq();
        this.roomAllAttributesQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryRoomAllAttributes(this.handle, roomID, sequence);
    }

    @Override
    public void setRoomMembersAttributes(HashMap<String, String> attributes, List<String> userIDs, String roomID, ZIMRoomMemberAttributesSetConfig config, ZIMRoomMembersAttributesOperatedCallback callback) {
        int sequence = this.genSeq();
        this.roomMembersAttributesOperatedCallbacks.put(sequence, callback);
        ZIMGenMethod.setRoomMembersAttributes(this.handle, attributes, ZIMCovert.listToArrayList(userIDs), roomID, ZIMCovert.roomMemberAttributesSetConfigToGenRoomMemberAttributesSetConfig(config), sequence);
    }

    @Override
    public void queryRoomMembersAttributes(List<String> userIDs, String roomID, ZIMRoomMembersAttributesQueriedCallback callback) {
        int sequence = this.genSeq();
        this.roomMembersAttributesQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryRoomMembersAttributes(this.handle, ZIMCovert.listToArrayList(userIDs), roomID, sequence);
    }

    @Override
    public void queryRoomMemberAttributesList(String roomID, ZIMRoomMemberAttributesQueryConfig config, ZIMRoomMemberAttributesListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.roomMemberAttributesListQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryRoomMemberAttributesList(this.handle, roomID, ZIMCovert.roomMemberAttributesQueryConfigToGenRoomMemberAttributesQueryConfig(config), sequence);
    }

    @Override
    public void createGroup(ZIMGroupInfo groupInfo, List<String> userIDList, ZIMGroupCreatedCallback callback) {
        int sequence = this.genSeq();
        this.groupCreatedCallbacks.put(sequence, callback);
        ZIMGenMethod.createGroup(this.handle, ZIMCovert.groupInfoToGenGroupInfo(groupInfo), ZIMCovert.listToArrayList(userIDList), ZIMCovert.groupAdvancedConfigToGenGroupAdvancedConfig(null), sequence);
    }

    @Override
    public void createGroup(ZIMGroupInfo groupInfo, List<String> userIDList, ZIMGroupAdvancedConfig config, ZIMGroupCreatedCallback callback) {
        int sequence = this.genSeq();
        this.groupCreatedCallbacks.put(sequence, callback);
        ZIMGenMethod.createGroup(this.handle, ZIMCovert.groupInfoToGenGroupInfo(groupInfo), ZIMCovert.listToArrayList(userIDList), ZIMCovert.groupAdvancedConfigToGenGroupAdvancedConfig(config), sequence);
    }

    @Override
    public void dismissGroup(String groupID, ZIMGroupDismissedCallback callback) {
        int sequence = this.genSeq();
        this.groupDismissedCallbacks.put(sequence, callback);
        ZIMGenMethod.dismissGroup(this.handle, groupID, sequence);
    }

    @Override
    public void joinGroup(String groupID, ZIMGroupJoinedCallback callback) {
        int sequence = this.genSeq();
        this.groupJoinedCallbacks.put(sequence, callback);
        ZIMGenMethod.joinGroup(this.handle, groupID, sequence);
    }

    @Override
    public void leaveGroup(String groupID, ZIMGroupLeftCallback callback) {
        int sequence = this.genSeq();
        this.groupLeftCallbacks.put(sequence, callback);
        ZIMGenMethod.leaveGroup(this.handle, groupID, sequence);
    }

    @Override
    public void inviteUsersIntoGroup(List<String> userIDs, String groupID, ZIMGroupUsersInvitedCallback callback) {
        int sequence = this.genSeq();
        this.groupUsersInvitedCallbacks.put(sequence, callback);
        ZIMGenMethod.inviteUsersIntoGroup(this.handle, ZIMCovert.listToArrayList(userIDs), groupID, sequence);
    }

    @Override
    public void kickGroupMembers(List<String> userIDs, String groupID, ZIMGroupMemberKickedCallback callback) {
        int sequence = this.genSeq();
        this.groupMemberKickedoutCallbacks.put(sequence, callback);
        ZIMGenMethod.kickGroupMembers(this.handle, ZIMCovert.listToArrayList(userIDs), groupID, sequence);
    }

    @Override
    public void transferGroupOwner(String toUserID, String groupID, ZIMGroupOwnerTransferredCallback callback) {
        int sequence = this.genSeq();
        this.groupOwnerTransferredCallbacks.put(sequence, callback);
        ZIMGenMethod.transferGroupOwner(this.handle, toUserID, groupID, sequence);
    }

    @Override
    public void updateGroupName(String groupName, String groupID, ZIMGroupNameUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupNameUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateGroupName(this.handle, groupName, groupID, sequence);
    }

    @Override
    public void updateGroupAlias(String groupAlias, String groupID, ZIMGroupAliasUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupAliasUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateGroupAlias(this.handle, groupAlias, groupID, sequence);
    }

    @Override
    public void updateGroupAvatarUrl(String groupAvatarUrl, String groupID, ZIMGroupAvatarUrlUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupAvatarUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateGroupAvatarUrl(this.handle, groupAvatarUrl, groupID, sequence);
    }

    @Override
    public void updateGroupNotice(String groupNotice, String groupID, ZIMGroupNoticeUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupNoticeUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateGroupNotice(this.handle, groupNotice, groupID, sequence);
    }

    @Override
    public void updateGroupJoinMode(ZIMGroupJoinMode mode, String groupID, ZIMGroupJoinModeUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupJoinModeUpdateCallbacks.put(sequence, callback);
        ZIMGenMethod.updateGroupJoinMode(this.handle, mode.value(), groupID, sequence);
    }

    @Override
    public void updateGroupInviteMode(ZIMGroupInviteMode mode, String groupID, ZIMGroupInviteModeUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupInviteModeUpdateCallbacks.put(sequence, callback);
        ZIMGenMethod.updateGroupInviteMode(this.handle, mode.value(), groupID, sequence);
    }

    @Override
    public void updateGroupBeInviteMode(ZIMGroupBeInviteMode mode, String groupID, ZIMGroupBeInviteModeUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupBeInviteModeUpdateCallbacks.put(sequence, callback);
        ZIMGenMethod.updateGroupBeInviteMode(this.handle, mode.value(), groupID, sequence);
    }

    @Override
    public void sendGroupJoinApplication(String groupID, ZIMGroupJoinApplicationSendConfig config, ZIMGroupJoinApplicationSentCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.sendGroupJoinApplication(this.handle, groupID, ZIMCovert.getZIMGenGroupJoinApplicationSendConfig(config), sequence);
    }

    @Override
    public void acceptGroupJoinApplication(String userID, String groupID, ZIMGroupJoinApplicationAcceptConfig config, ZIMGroupJoinApplicationAcceptedCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.acceptGroupJoinApplication(this.handle, userID, groupID, ZIMCovert.getZIMGenGroupJoinApplicationAcceptConfig(config), sequence);
    }

    @Override
    public void rejectGroupJoinApplication(String userID, String groupID, ZIMGroupJoinApplicationRejectConfig config, ZIMGroupJoinApplicationRejectedCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.rejectGroupJoinApplication(this.handle, userID, groupID, ZIMCovert.getZIMGenGroupJoinApplicationRejectConfig(config), sequence);
    }

    @Override
    public void sendGroupInviteApplications(List<String> userIDs, String groupID, ZIMGroupInviteApplicationSendConfig config, ZIMGroupInviteApplicationsSentCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.sendGroupInviteApplications(this.handle, ZIMCovert.listToArrayList(userIDs), groupID, ZIMCovert.getZIMGenGroupInviteApplicationSendConfig(config), sequence);
    }

    @Override
    public void acceptGroupInviteApplication(String inviterUserID, String groupID, ZIMGroupInviteApplicationAcceptConfig config, ZIMGroupInviteApplicationAcceptedCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.acceptGroupInviteApplication(this.handle, inviterUserID, groupID, ZIMCovert.getZIMGroupInviteApplicationAcceptConfig(config), sequence);
    }

    @Override
    public void rejectGroupInviteApplication(String inviterUserID, String groupID, ZIMGroupInviteApplicationRejectConfig config, ZIMGroupInviteApplicationRejectedCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.rejectGroupInviteApplication(this.handle, inviterUserID, groupID, ZIMCovert.getZIMGroupInviteApplicationRejectConfig(config), sequence);
    }

    @Override
    public void queryGroupApplicationList(ZIMGroupApplicationListQueryConfig config, ZIMGroupApplicationListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupApplicationList(this.handle, ZIMCovert.getZIMGroupApplicationListQueryConfig(config), sequence);
    }

    @Override
    public void queryGroupInfo(String groupID, ZIMGroupInfoQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupInfoQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupInfo(this.handle, groupID, sequence);
    }

    @Override
    public void setGroupAttributes(HashMap<String, String> groupAttributes, String groupID, ZIMGroupAttributesOperatedCallback callback) {
        int sequence = this.genSeq();
        this.groupAttributesOperatedCallbacks.put(sequence, callback);
        ZIMGenMethod.setGroupAttributes(this.handle, groupAttributes, groupID, sequence);
    }

    @Override
    public void deleteGroupAttributes(List<String> keys, String groupID, ZIMGroupAttributesOperatedCallback callback) {
        int sequence = this.genSeq();
        this.groupAttributesOperatedCallbacks.put(sequence, callback);
        ZIMGenMethod.deleteGroupAttributes(this.handle, ZIMCovert.listToArrayList(keys), groupID, sequence);
    }

    @Override
    public void queryGroupAttributes(List<String> keys, String groupID, ZIMGroupAttributesQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupAttributesQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupAttributes(this.handle, ZIMCovert.listToArrayList(keys), groupID, sequence);
    }

    @Override
    public void queryGroupAllAttributes(String groupID, ZIMGroupAttributesQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupAttributesQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupAllAttributes(this.handle, groupID, sequence);
    }

    @Override
    public void setGroupMemberRole(int role, String forUserID, String groupID, ZIMGroupMemberRoleUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupMemberRoleUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.setGroupMemberRole(this.handle, role, forUserID, groupID, sequence);
    }

    @Override
    public void setGroupMemberNickname(String nickname, String forUserID, String groupID, ZIMGroupMemberNicknameUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.groupMemberNicknameUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.setGroupMemberNickname(this.handle, nickname, forUserID, groupID, sequence);
    }

    @Override
    public void muteGroup(boolean isMute, String groupID, ZIMGroupMuteConfig config, ZIMGroupMutedCallback callback) {
        int sequence = this.genSeq();
        this.groupMutedCallbacks.put(sequence, callback);
        ZIMGenMethod.muteGroup(this.handle, isMute, groupID, ZIMCovert.groupMuteConfigToGenGroupAdvancedConfig(config), sequence);
    }

    @Override
    public void muteGroupMembers(boolean isMute, ArrayList<String> userIDs, String groupID, ZIMGroupMemberMuteConfig config, ZIMGroupMembersMutedCallback callback) {
        int sequence = this.genSeq();
        this.groupMembersMutedCallbacks.put(sequence, callback);
        ZIMGenMethod.muteGroupMemberList(this.handle, isMute, userIDs, groupID, ZIMCovert.groupMemberMuteConfigToGenGroupMemberMuteConfig(config), sequence);
    }

    @Override
    public void queryGroupMemberMutedList(String groupID, ZIMGroupMemberMutedListQueryConfig config, ZIMGroupMemberMutedListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupMemberMutedListQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupMemberMutedList(this.handle, groupID, ZIMCovert.getGenGroupMemberMutedListQueryConfig(config), sequence);
    }

    @Override
    public void queryGroupMemberInfo(String userID, String groupID, ZIMGroupMemberInfoQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupMemberInfoQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupMemberInfo(this.handle, userID, groupID, sequence);
    }

    @Override
    public void queryGroupList(ZIMGroupListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupListQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupList(this.handle, sequence);
    }

    @Override
    public void queryGroupMemberList(String groupID, ZIMGroupMemberQueryConfig config, ZIMGroupMemberListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupMemberListQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupMemberList(this.handle, groupID, ZIMCovert.getGenGroupMemberQueryConfig(config), sequence);
    }

    @Override
    public void queryGroupMemberCount(String groupID, ZIMGroupMemberCountQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupMemberCountQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryGroupMemberCount(this.handle, groupID, sequence);
    }

    @Override
    public void queryGroupMessageReceiptReadMemberList(ZIMMessage message, String groupID, ZIMGroupMessageReceiptMemberQueryConfig config, ZIMGroupMessageReceiptMemberListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupMessageReceiptMemberListCallback.put(sequence, callback);
        ZIMGenMethod.queryGroupMessageReceiptReadMemberList(this.handle, ZIMCovert.getGenMessage(message), groupID, ZIMCovert.getGroupMessageReceiptMemberQueryConfig(config), sequence);
    }

    @Override
    public void queryGroupMessageReceiptUnreadMemberList(ZIMMessage message, String groupID, ZIMGroupMessageReceiptMemberQueryConfig config, ZIMGroupMessageReceiptMemberListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.groupMessageReceiptMemberListCallback.put(sequence, callback);
        ZIMGenMethod.queryGroupMessageReceiptUnReadMemberList(this.handle, ZIMCovert.getGenMessage(message), groupID, ZIMCovert.getGroupMessageReceiptMemberQueryConfig(config), sequence);
    }

    @Override
    public void searchLocalGroups(ZIMGroupSearchConfig config, ZIMGroupsSearchedCallback callback) {
        int sequence = this.genSeq();
        this.groupsSearchedCallbacks.put(sequence, callback);
        ZIMGenMethod.searchGroups(this.handle, ZIMCovert.getGroupSearchConfig(config), sequence);
    }

    @Override
    public void searchLocalGroupMembers(String groupID, ZIMGroupMemberSearchConfig config, ZIMGroupMembersSearchedCallback callback) {
        int sequence = this.genSeq();
        this.groupMembersSearchedCallbacks.put(sequence, callback);
        ZIMGenMethod.searchGroupMembers(this.handle, groupID, ZIMCovert.getGroupMemberSearchConfig(config), sequence);
    }

    @Override
    public void callInvite(List<String> invitees, ZIMCallInviteConfig config, ZIMCallInvitationSentCallback callback) {
        int sequence = this.genSeq();
        this.callInvitationSentCallback.put(sequence, callback);
        ZIMGenMethod.callInvite(this.handle, ZIMCovert.listToArrayList(invitees), ZIMCovert.getGenCallInviteConfig(config), sequence);
    }

    @Override
    public void callCancel(List<String> invitees, String callID, ZIMCallCancelConfig config, ZIMCallCancelSentCallback callback) {
        int sequence = this.genSeq();
        this.callCancelSentCallback.put(sequence, callback);
        ZIMGenMethod.callCancel(this.handle, ZIMCovert.listToArrayList(invitees), callID, ZIMCovert.getGenCallCancelConfig(config), sequence);
    }

    @Override
    public void callAccept(String callID, ZIMCallAcceptConfig config, ZIMCallAcceptanceSentCallback callback) {
        int sequence = this.genSeq();
        this.callAcceptanceSentCallback.put(sequence, callback);
        ZIMGenMethod.callAccept(this.handle, callID, ZIMCovert.getGenCallAcceptConfig(config), sequence);
    }

    @Override
    public void callReject(String callID, ZIMCallRejectConfig config, ZIMCallRejectionSentCallback callback) {
        int sequence = this.genSeq();
        this.callRejectionSentCallback.put(sequence, callback);
        ZIMGenMethod.callReject(this.handle, callID, ZIMCovert.getGenCallRejectConfig(config), sequence);
    }

    @Override
    public void callJoin(String callID, ZIMCallJoinConfig config, ZIMCallJoinSentCallback callback) {
        int sequence = this.genSeq();
        this.callJoinSentCallback.put(sequence, callback);
        ZIMGenMethod.callJoin(this.handle, callID, ZIMCovert.getGenCallJoinConfig(config), sequence);
    }

    @Override
    public void callQuit(String callID, ZIMCallQuitConfig config, ZIMCallQuitSentCallback callback) {
        int sequence = this.genSeq();
        this.callQuitSentCallback.put(sequence, callback);
        ZIMGenMethod.callQuit(this.handle, callID, ZIMCovert.getGenCallQuitConfig(config), sequence);
    }

    @Override
    public void callEnd(String callID, ZIMCallEndConfig config, ZIMCallEndSentCallback callback) {
        int sequence = this.genSeq();
        this.callEndSentCallback.put(sequence, callback);
        ZIMGenMethod.callEnd(this.handle, callID, ZIMCovert.getGenCallEndConfig(config), sequence);
    }

    @Override
    public void callingInvite(List<String> invitees, String callID, ZIMCallingInviteConfig config, ZIMCallingInvitationSentCallback callback) {
        int sequence = this.genSeq();
        this.callingInvitationSentCallback.put(sequence, callback);
        ZIMGenMethod.callingInvite(this.handle, callID, ZIMCovert.listToArrayList(invitees), ZIMCovert.getGenCallingInviteConfig(config), sequence);
    }

    @Override
    public void queryCallInvitationList(ZIMCallInvitationQueryConfig config, ZIMCallInvitationListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.callListQueriedCallback.put(sequence, callback);
        ZIMGenMethod.queryCallList(this.handle, ZIMCovert.getGenQueryCallListConfig(config), sequence);
    }

    @Override
    public void addFriend(String userID, ZIMFriendAddConfig config, ZIMFriendAddedCallback callback) {
        int sequence = this.genSeq();
        this.friendAddedCallback.put(sequence, callback);
        ZIMGenMethod.addFriend(this.handle, userID, ZIMCovert.getGenZIMFriendAddConfig(config), sequence);
    }

    @Override
    public void sendFriendApplication(String applyUser, ZIMFriendApplicationSendConfig config, ZIMFriendApplicationSentCallback callback) {
        int sequence = this.genSeq();
        this.sendFriendAddedCallback.put(sequence, callback);
        ZIMGenMethod.sendFriendApplication(this.handle, applyUser, ZIMCovert.getGenZIMSendFriendApplicationConfig(config), sequence);
    }

    @Override
    public void deleteFriends(ArrayList<String> userIDs, ZIMFriendDeleteConfig config, ZIMFriendsDeletedCallback callback) {
        int sequence = this.genSeq();
        this.friendDeletedCallback.put(sequence, callback);
        ZIMGenMethod.deleteFriends(this.handle, userIDs, ZIMCovert.getGenZIMFriendDeleteConfig(config), sequence);
    }

    @Override
    public void checkFriendsRelation(ArrayList<String> userIDs, ZIMFriendRelationCheckConfig config, ZIMFriendsRelationCheckedCallback callback) {
        int sequence = this.genSeq();
        this.friendCheckedCallback.put(sequence, callback);
        ZIMGenMethod.checkFriendsRelation(this.handle, userIDs, ZIMCovert.getGenZIMFriendCheckConfig(config), sequence);
    }

    @Override
    public void updateFriendAlias(String friendAlias, String userID, ZIMFriendAliasUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.friendAliasCallback.put(sequence, callback);
        ZIMGenMethod.updateFriendAlias(this.handle, friendAlias, userID, sequence);
    }

    @Override
    public void updateFriendAttributes(HashMap<String, String> friendAttributes, String userID, ZIMFriendAttributesUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.friendAttributesUpdatedCallback.put(sequence, callback);
        ZIMGenMethod.updateFriendAttributes(this.handle, friendAttributes, userID, sequence);
    }

    @Override
    public void queryFriendsInfo(ArrayList<String> userIDs, ZIMFriendsInfoQueriedCallback callback) {
        int sequence = this.genSeq();
        this.friendQueriedCallback.put(sequence, callback);
        ZIMGenMethod.queryFriendsInfo(this.handle, userIDs, sequence);
    }

    @Override
    public void acceptFriendApplication(String userID, ZIMFriendApplicationAcceptConfig config, ZIMFriendApplicationAcceptedCallback callback) {
        int sequence = this.genSeq();
        this.friendApplicationAcceptedCallback.put(sequence, callback);
        ZIMGenMethod.acceptFriendApplication(this.handle, userID, ZIMCovert.getGenZIMFriendApplicationAcceptConfig(config), sequence);
    }

    @Override
    public void rejectFriendApplication(String userID, ZIMFriendApplicationRejectConfig config, ZIMFriendApplicationRejectedCallback callback) {
        int sequence = this.genSeq();
        this.friendApplicationRejectedCallback.put(sequence, callback);
        ZIMGenMethod.rejectFriendApplication(this.handle, userID, ZIMCovert.getGenZIMFriendApplicationRejectConfig(config), sequence);
    }

    @Override
    public void queryFriendList(ZIMFriendListQueryConfig config, ZIMFriendListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.friendListQueriedCallback.put(sequence, callback);
        ZIMGenMethod.queryFriendList(this.handle, ZIMCovert.getGenZIMFriendListQueryConfig(config), sequence);
    }

    @Override
    public void queryFriendApplicationList(ZIMFriendApplicationListQueryConfig config, ZIMFriendApplicationListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.friendApplicationListQueriedCallback.put(sequence, callback);
        ZIMGenMethod.queryFriendApplicationList(this.handle, ZIMCovert.getGenZIMFriendApplicationListQueryConfig(config), sequence);
    }

    @Override
    public void addUsersToBlacklist(ArrayList<String> userIDs, ZIMBlacklistUsersAddedCallback callback) {
        int sequence = this.genSeq();
        this.blacklistUsersAddedCallback.put(sequence, callback);
        ZIMGenMethod.addUsersToBlacklist(this.handle, userIDs, sequence);
    }

    @Override
    public void removeUsersFromBlacklist(ArrayList<String> userIDs, ZIMBlacklistUsersRemovedCallback callback) {
        int sequence = this.genSeq();
        this.blacklistUsersRemovedCallback.put(sequence, callback);
        ZIMGenMethod.removeUsersFromBlacklist(this.handle, userIDs, sequence);
    }

    @Override
    public void queryBlacklist(ZIMBlacklistQueryConfig config, ZIMBlacklistQueriedCallback callback) {
        int sequence = this.genSeq();
        this.blacklistQueriedCallback.put(sequence, callback);
        ZIMGenMethod.queryBlacklist(this.handle, ZIMCovert.getGenZIMBlacklistQueryConfig(config), sequence);
    }

    @Override
    public void checkUserIsInBlacklist(String userID, ZIMBlacklistCheckedCallback callback) {
        int sequence = this.genSeq();
        this.blacklistCheckedCallback.put(sequence, callback);
        ZIMGenMethod.checkUserIsInBlacklist(this.handle, userID, sequence);
    }

    @Override
    public void searchLocalFriends(ZIMFriendSearchConfig config, ZIMFriendsSearchedCallback callback) {
        int sequence = this.genSeq();
        this.friendSearchedCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.searchLocalFriends(this.handle, ZIMCovert.getGenZIMFriendSearchConfig(config), sequence);
    }

    @Override
    public void insertMessageToLocalDB(ZIMMessage message, String conversationID, ZIMConversationType conversationType, String senderUserID, ZIMMessageInsertedCallback callback) {
        int sequence = this.genSeq();
        this.messageInsertedCallback.put(sequence, callback);
        if (message.getMessageID() == 0L && message.getLocalMessageID() == 0L) {
            this.messageObjMap.put(sequence, message);
        }
        ZIMGenMethod.insertMessageToLocalDB(this.handle, ZIMCovert.getGenMessage(message), conversationID, conversationType.value(), senderUserID, sequence);
    }

    @Override
    public void queryHistoryMessage(String conversationID, ZIMConversationType conversationType, ZIMMessageQueryConfig config, ZIMMessageQueriedCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.queryHistoryMessage(this.handle, conversationID, conversationType.value(), ZIMCovert.getMessageQueryConfig(config), sequence);
    }

    @Override
    public void searchLocalMessages(String conversationID, ZIMConversationType conversationType, ZIMMessageSearchConfig config, ZIMMessagesSearchedCallback callback) {
        int sequence = this.genSeq();
        this.messageSearchCallbacks.put(sequence, callback);
        ZIMGenMethod.searchLocalMessages(this.handle, conversationID, conversationType.value(), ZIMCovert.getGenMessageSearchConfig(config), sequence);
    }

    @Override
    public void searchGlobalLocalMessages(ZIMMessageSearchConfig config, ZIMMessagesGlobalSearchedCallback callback) {
        int sequence = this.genSeq();
        this.messageGlobalSearchCallbacks.put(sequence, callback);
        ZIMGenMethod.searchGlobalLocalMessages(this.handle, ZIMCovert.getGenMessageSearchConfig(config), sequence);
    }

    @Override
    public void searchLocalConversations(ZIMConversationSearchConfig config, ZIMConversationsSearchedCallback callback) {
        int sequence = this.genSeq();
        this.conversationMessageGlobalSearchCallbacks.put(sequence, callback);
        ZIMGenMethod.searchLocalConversations(this.handle, ZIMCovert.getGenMessageGlobalSearchConfig(config), sequence);
    }

    @Override
    public void updateMessageLocalExtendedData(String localExtendedData, ZIMMessage message, ZIMMessageLocalExtendedDataUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.messageObjMap.put(sequence, message);
        this.messageLocalExtendedDataUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateMessageLocalExtendedData(this.handle, localExtendedData, ZIMCovert.getGenMessage(message), sequence);
    }

    @Override
    public void revokeMessage(ZIMMessage message, ZIMMessageRevokeConfig config, ZIMMessageRevokedCallback callback) {
        int sequence = this.genSeq();
        this.messageRevokedCallbacks.put(sequence, callback);
        ZIMGenMethod.revokeMessage(this.handle, ZIMCovert.getGenMessage(message), ZIMCovert.getGenMessageRevokeConfig(config), sequence);
    }

    @Override
    public void queryCombineMessageDetail(ZIMCombineMessage message, ZIMCombineMessageDetailQueriedCallback callback) {
        int sequence = this.genSeq();
        this.combineMessageDetailQueriedCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.queryCombineMessage(this.handle, ZIMCovert.getGenMessage(message), sequence);
    }

    @Override
    public void replyMessage(ZIMMessage message, ZIMMessage repliedMessage, ZIMMessageSendConfig config, ZIMMessageSentFullCallback callback) {
        int sequence = this.genSeq();
        this.sentFullCallbackHashMap.put(sequence, callback);
        if (message.getMessageID() == 0L && message.getLocalMessageID() == 0L) {
            this.messageObjMap.put(sequence, message);
        }
        ZIMGenMethod.replyMessage(this.handle, ZIMCovert.getGenMessage(message), ZIMCovert.getGenMessage(repliedMessage), ZIMCovert.sendConfigToGenSendConfig(config), sequence);
    }

    @Override
    public void queryMessageRepliedList(ZIMMessage message, ZIMMessageRepliedListQueryConfig config, ZIMMessageRepliedListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.repliedListQueriedCallbackHashMap.put(sequence, callback);
        ZIMGenMethod.queryRepliedMessageList(this.handle, ZIMCovert.getGenMessage(message), ZIMCovert.getGenRepliedListQueryConfig(config), sequence);
    }

    @Override
    public void queryMessages(ArrayList<Long> messageSeqs, String conversationID, ZIMConversationType conversationType, ZIMMessageQueriedCallback callback) {
        int sequence = this.genSeq();
        this.commonCallbacks.put(sequence, callback);
        ZIMGenMethod.queryMessages(this.handle, messageSeqs, conversationID, conversationType.value(), sequence);
    }

    @Override
    public void deleteMessages(List<ZIMMessage> messageList, String conversationID, ZIMConversationType type, ZIMMessageDeleteConfig config, ZIMMessageDeletedCallback callback) {
        int sequence = this.genSeq();
        this.messageDeletedCallbacks.put(sequence, callback);
        ZIMGenMethod.deleteMessages(this.handle, ZIMCovert.zimMessageListToGenMessageList(messageList), conversationID, type.value(), ZIMCovert.getGenMessageDeleteConfig(config), sequence);
    }

    @Override
    public void deleteAllMessage(String conversationID, ZIMConversationType type, ZIMMessageDeleteConfig config, ZIMMessageDeletedCallback callback) {
        int sequence = this.genSeq();
        this.messageDeletedCallbacks.put(sequence, callback);
        ZIMGenMethod.deleteAllMessage(this.handle, conversationID, type.value(), ZIMCovert.getGenMessageDeleteConfig(config), sequence);
    }

    @Override
    public void deleteAllConversationMessages(ZIMMessageDeleteConfig config, ZIMConversationMessagesAllDeletedCallback callback) {
        int sequence = this.genSeq();
        this.conversationMessagesAllDeletedCallbacks.put(sequence, callback);
        ZIMGenMethod.deleteAllConversationMessages(this.handle, ZIMCovert.getGenMessageDeleteConfig(config), sequence);
    }

    @Override
    public void queryConversationList(ZIMConversationQueryConfig config, ZIMConversationListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.conversationListQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryConversationList(this.handle, ZIMCovert.getGenConversationQueryConfig(config), sequence);
    }

    @Override
    public void queryConversationList(ZIMConversationQueryConfig config, ZIMConversationFilterOption option, ZIMConversationListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.conversationListQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryConversationListWithConfig(this.handle, ZIMCovert.getGenConversationQueryConfig(config), ZIMCovert.getGenConversationFilterOption(option), sequence);
    }

    @Override
    public void queryConversation(String conversationID, ZIMConversationType conversationType, ZIMConversationQueriedCallback callback) {
        int sequence = this.genSeq();
        this.conversationQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryConversation(this.handle, conversationID, conversationType.value(), sequence);
    }

    @Override
    public void queryConversationPinnedList(ZIMConversationQueryConfig config, ZIMConversationPinnedListQueriedCallback callback) {
        int sequence = this.genSeq();
        this.conversationPinnedListQueriedCallbacks.put(sequence, callback);
        ZIMGenMethod.queryConversationPinnedList(this.handle, ZIMCovert.getGenConversationQueryConfig(config), sequence);
    }

    @Override
    public void queryConversationTotalUnreadMessageCount(ZIMConversationTotalUnreadMessageCountQueryConfig config, ZIMConversationTotalUnreadMessageCountQueriedCallback callback) {
        int sequence = this.genSeq();
        this.conversationTotalUnreadMessageCountQueriedCallback.put(sequence, callback);
        ZIMGenMethod.queryConversationTotalUnreadCount(this.handle, ZIMCovert.getGenConversationTotalUnreadCountQueryConfig(config), sequence);
    }

    @Override
    public void updateConversationPinnedState(boolean isPinned, String conversationID, ZIMConversationType conversationType, ZIMConversationPinnedStateUpdatedCallback callback) {
        int sequence = this.genSeq();
        this.conversationPinnedStateUpdatedCallbacks.put(sequence, callback);
        ZIMGenMethod.updateConversationPinnedState(this.handle, isPinned, conversationID, conversationType.value(), sequence);
    }

    @Override
    public void deleteConversation(String conversationID, ZIMConversationType type, ZIMConversationDeleteConfig config, ZIMConversationDeletedCallback callback) {
        int sequence = this.genSeq();
        this.conversationDeletedCallbacks.put(sequence, callback);
        ZIMGenMethod.deleteConversation(this.handle, conversationID, type.value(), ZIMCovert.getGenConversationDeleteConfig(config), sequence);
    }

    @Override
    public void deleteAllConversations(ZIMConversationDeleteConfig config, ZIMConversationsAllDeletedCallback callback) {
        int sequence = this.genSeq();
        this.conversationsAllDeletedCallbacks.put(sequence, callback);
        ZIMGenMethod.deleteAllConversations(this.handle, ZIMCovert.getGenConversationDeleteConfig(config), sequence);
    }

    @Override
    public void clearConversationUnreadMessageCount(String conversationID, ZIMConversationType type, ZIMConversationUnreadMessageCountClearedCallback callback) {
        int sequence = this.genSeq();
        this.conversationUnreadMessageCountClearedCallbacks.put(sequence, callback);
        ZIMGenMethod.clearConversationUnreadMessageCount(this.handle, conversationID, type.value(), sequence);
    }

    @Override
    public void clearConversationTotalUnreadMessageCount(ZIMConversationTotalUnreadMessageCountClearedCallback callback) {
        int sequence = this.genSeq();
        this.conversationsAllUnreadMessageCountClearedCallbacks.put(sequence, callback);
        ZIMGenMethod.clearConversationTotalUnreadMessageCount(this.handle, sequence);
    }

    @Override
    public void setConversationNotificationStatus(ZIMConversationNotificationStatus status, String conversationID, ZIMConversationType type, ZIMConversationNotificationStatusSetCallback callback) {
        int sequence = this.genSeq();
        this.conversationNotificationStatusSetCallbacks.put(sequence, callback);
        ZIMGenMethod.setConversationNotificationStatus(this.handle, status.value(), conversationID, type.value(), sequence);
    }

    @Override
    public void sendConversationMessageReceiptRead(String conversationID, ZIMConversationType conversationType, ZIMConversationMessageReceiptReadSentCallback callback) {
        int sequence = this.genSeq();
        this.conversationReceiptReadCallback.put(sequence, callback);
        ZIMGenMethod.sendConversationMessageReceiptRead(this.handle, conversationID, conversationType.value(), sequence);
    }

    @Override
    public void importLocalMessages(String folderPath, ZIMMessageImportConfig config, ZIMMessageImportedCallback callback) {
        int sequence = this.genSeq();
        this.messageImportedCallback.put(sequence, callback);
        ZIMGenMethod.importLocalMessages(this.handle, folderPath, ZIMCovert.getGenMessageImportConfig(config), sequence);
    }

    @Override
    public void exportLocalMessages(String folderPath, ZIMMessageExportConfig config, ZIMMessageExportedCallback callback) {
        int sequence = this.genSeq();
        this.messageExportedCallback.put(sequence, callback);
        ZIMGenMethod.exportLocalMessages(this.handle, folderPath, ZIMCovert.getGenMessageExportConfig(config), sequence);
    }

    @Override
    public void clearLocalFileCache(ZIMFileCacheClearConfig config, ZIMFileCacheClearedCallback callback) {
        int sequence = this.genSeq();
        this.fileCacheClearedCallback.put(sequence, callback);
        ZIMGenMethod.clearLocalFileCache(this.handle, ZIMCovert.getGenFileCacheClearConfig(config), sequence);
    }

    @Override
    public void queryLocalFileCache(ZIMFileCacheQueryConfig config, ZIMFileCacheQueriedCallback callback) {
        int sequence = this.genSeq();
        this.fileCacheQueriedCallback.put(sequence, callback);
        ZIMGenMethod.queryLocalFileCache(this.handle, ZIMCovert.getGenFileCacheQueryConfig(config), sequence);
    }

    @Override
    public void setConversationDraft(String draft, String conversationID, ZIMConversationType conversationType, ZIMConversationDraftSetCallback callback) {
        int sequence = this.genSeq();
        this.conversationDraftSetCallback.put(sequence, callback);
        ZIMGenMethod.setConversationDraft(this.handle, draft, conversationID, conversationType.value(), sequence);
    }

    @Override
    public void setConversationMark(Integer markType, boolean enable, ArrayList<ZIMConversationBaseInfo> infos, ZIMConversationMarkSetCallback callback) {
        int sequence = this.genSeq();
        this.conversationMarkSetCallback.put(sequence, callback);
        ZIMGenMethod.setConversationMark(this.handle, markType, enable, ZIMCovert.zimConversationBaseInfoListToGenConversationBaseInfoList(infos), sequence);
    }

    public static native long create(long var0, String var2, Context var3);

    static {
        try {
            if (ZIM.externalSoPath != null && ZIM.context != null) {
                ZIMSysUtil.loadSpecialLibrary(ZIM.externalSoPath, (Context)ZIM.context);
            } else {
                System.loadLibrary("ZIM");
            }
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)"ZIM", (String)"Load ZIM native library failed!", (Throwable)e);
        }
    }
}

