/*
 * Decompiled with CFR 0.152.
 */
package im.zego.connection;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.CellSignalStrength;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import java.util.List;

public class NetworkStateChangeReceiver40461
extends BroadcastReceiver {
    private long mThis;
    private Context mContext;
    private PhoneStateListener mPhoneStateListener;
    private int mCellSignalDbm = 0;
    private int mCellSignalLevel = 0;
    private TelephonyManager mTelephonyManager;

    public void setThis(long pThis) {
        this.mThis = pThis;
    }

    public synchronized int init(Context ctx) {
        this.mContext = ctx;
        if (this.mContext == null) {
            return -1;
        }
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        IntentFilter intentFilterNetwork = new IntentFilter();
        intentFilterNetwork.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver((BroadcastReceiver)this, intentFilterNetwork);
        this.CheckNotify();
        return 0;
    }

    public synchronized int uninit() {
        if (this.mContext == null) {
            return -1;
        }
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
        this.mContext = null;
        return 0;
    }

    public void checkCurrentNetType() {
        this.CheckNotify();
    }

    public synchronized void CheckNotify() {
        if (this.mContext == null) {
            return;
        }
        int nt = 32;
        int active_vpn = 0;
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo ni = null;
        if (cm != null) {
            NetworkCapabilities networkCapabilities;
            Network activeNetwork;
            ni = cm.getActiveNetworkInfo();
            if (Build.VERSION.SDK_INT >= 23 && (activeNetwork = cm.getActiveNetwork()) != null && (networkCapabilities = cm.getNetworkCapabilities(activeNetwork)) != null && networkCapabilities.hasTransport(4)) {
                active_vpn = 1;
            }
        }
        String networkInfo = "";
        if (ni == null) {
            nt = 0;
        } else {
            networkInfo = ni.toString();
            nt = this.getNetTypeDetail(ni);
        }
        NetworkStateChangeReceiver40461.onNetTypeChanged(this.mThis, nt, active_vpn, networkInfo);
    }

    public synchronized void onReceive(Context context, Intent intent) {
        this.CheckNotify();
    }

    private int getNetTypeDetail(NetworkInfo ni) {
        int nt;
        block0 : switch (ni.getType()) {
            case 1: {
                nt = 2;
                break;
            }
            case 0: {
                switch (ni.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        nt = 3;
                        break block0;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        nt = 4;
                        break block0;
                    }
                    case 13: 
                    case 18: {
                        nt = 5;
                        break block0;
                    }
                    case 20: {
                        nt = 6;
                        break block0;
                    }
                }
                nt = 32;
                break;
            }
            case 9: {
                nt = 1;
                break;
            }
            default: {
                nt = 32;
            }
        }
        return nt;
    }

    public int getWifiSignalDbm() {
        WifiInfo wifiInfo;
        int signal = 0;
        WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        if (wifiManager != null && wifiManager.isWifiEnabled() && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
            signal = wifiInfo.getRssi();
        }
        return signal;
    }

    public int getWifiSignalLevel() {
        WifiInfo wifiInfo;
        int level = 0;
        WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        if (wifiManager != null && wifiManager.isWifiEnabled() && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
            level = WifiManager.calculateSignalLevel((int)wifiInfo.getRssi(), (int)5);
        }
        return level;
    }

    public int getCellSignalDbm() {
        return this.mCellSignalDbm;
    }

    public int getCellSignalLevel() {
        return this.mCellSignalLevel;
    }

    private void registerPhoneStateListener() {
    }

    private void unregisterPhoneStateListener() {
    }

    private void getCachedCellSignalInfo() {
        SignalStrength signalStrength;
        if (Build.VERSION.SDK_INT >= 28 && this.mTelephonyManager != null && (signalStrength = this.mTelephonyManager.getSignalStrength()) != null) {
            int[] info = this.getCellSignalDetail(signalStrength);
            this.mCellSignalDbm = info[0];
            this.mCellSignalLevel = info[1];
        }
    }

    private int[] getCellSignalDetail(SignalStrength signalStrength) {
        int dbm = 0;
        int level = 0;
        if (signalStrength == null) {
            int[] result = new int[]{dbm, level};
            return result;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            List cells = signalStrength.getCellSignalStrengths();
            if (cells.size() > 0) {
                dbm = ((CellSignalStrength)cells.get(0)).getDbm();
                level = ((CellSignalStrength)cells.get(0)).getLevel();
            }
            int[] result = new int[]{dbm, level};
            return result;
        }
        if (signalStrength.isGsm()) {
            int asu = signalStrength.getGsmSignalStrength();
            if (asu >= 0 && asu <= 31) {
                dbm = asu * 2 - 113;
                level = this.calculateGsmSignalLevel(asu);
            }
        } else {
            dbm = signalStrength.getCdmaDbm();
            level = this.calculateCdmaSignalLevel(dbm);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            level = signalStrength.getLevel();
        }
        int[] result = new int[]{dbm, level};
        return result;
    }

    private int calculateGsmSignalLevel(int asu) {
        int level = 0;
        level = asu <= 2 || asu == 99 ? 0 : (asu >= 12 ? 4 : (asu >= 8 ? 3 : (asu >= 5 ? 2 : 1)));
        return level;
    }

    private int calculateCdmaSignalLevel(int dbm) {
        int level = 0;
        level = dbm >= -89 ? 4 : (dbm >= -97 ? 3 : (dbm >= -105 ? 2 : (dbm >= -113 ? 1 : 0)));
        return level;
    }

    static native void onNetTypeChanged(long var0, int var2, int var3, String var4);
}

