package im.zego.zegoexpress.constants;

/** Video frame flip mode */
public enum ZegoVideoFlipMode {
    /** No flip */
    NONE(0),
    /** X-axis flip */
    X(1);

    private int value;

    private ZegoVideoFlipMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoVideoFlipMode getZegoVideoFlipMode(int value) {
        try {

            if (NONE.value == value) {
                return NONE;
            }

            if (X.value == value) {
                return X;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}