package im.zego.zegoexpress.constants;

/** Audio Codec ID */
public enum ZegoAudioCodecID {
    /** default */
    DEFAULT(0),
    /** Normal */
    NORMAL(1),
    /** Normal2 */
    NORMAL2(2),
    /** Normal3 */
    NORMAL3(3),
    /** Low */
    LOW(4),
    /** Low2 */
    LOW2(5),
    /** Low3 */
    LOW3(6);

    private int value;

    private ZegoAudioCodecID(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoAudioCodecID getZegoAudioCodecID(int value) {
        try {

            if (DEFAULT.value == value) {
                return DEFAULT;
            }

            if (NORMAL.value == value) {
                return NORMAL;
            }

            if (NORMAL2.value == value) {
                return NORMAL2;
            }

            if (NORMAL3.value == value) {
                return NORMAL3;
            }

            if (LOW.value == value) {
                return LOW;
            }

            if (LOW2.value == value) {
                return LOW2;
            }

            if (LOW3.value == value) {
                return LOW3;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}