package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

/**
 * Mixer input
 *
 * Configure the mix stream input stream ID, type, and the layout
 */
public class ZegoMixerInput {

    /** Stream ID, a string of up to 256 characters. You cannot include URL keywords, otherwise publishing stream and playing stream will fails. Only support numbers, English characters and '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '=', '-', '`', ';', '’', ',', '.', '<', '>', '/', '\'. */
    public String streamID;

    /** Mix stream content type */
    public ZegoMixerInputContentType contentType;

    /** Stream layout */
    public Rect layout;

    /** If enable soundLevel in mix stream task, an unique soundLevelID is need for every stream */
    public int soundLevelID;

    public ZegoMixerInput(String streamID, ZegoMixerInputContentType contentType, Rect layout){
        this.streamID = streamID;
        this.contentType = contentType;
        this.layout = layout;
    }

    public ZegoMixerInput(String streamID, ZegoMixerInputContentType contentType, Rect layout, int soundLevelID){
        this.streamID = streamID;
        this.contentType = contentType;
        this.layout = layout;
        this.soundLevelID = soundLevelID;
    }

}
