package im.zego.zegoexpress.constants;

/** Audio Config Preset */
public enum ZegoAudioConfigPreset {
    /** basic-quality */
    BASIC_QUALITY(0),
    /** standard-quality */
    STANDARD_QUALITY(1),
    /** standard-quality-stereo */
    STANDARD_QUALITY_STEREO(2),
    /** high-quality */
    HIGH_QUALITY(3),
    /** high-quality-stereo */
    HIGH_QUALITY_STEREO(4);

    private int value;

    private ZegoAudioConfigPreset(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoAudioConfigPreset getZegoAudioConfigPreset(int value) {
        try {

            if (BASIC_QUALITY.value == value) {
                return BASIC_QUALITY;
            }

            if (STANDARD_QUALITY.value == value) {
                return STANDARD_QUALITY;
            }

            if (STANDARD_QUALITY_STEREO.value == value) {
                return STANDARD_QUALITY_STEREO;
            }

            if (HIGH_QUALITY.value == value) {
                return HIGH_QUALITY;
            }

            if (HIGH_QUALITY_STEREO.value == value) {
                return HIGH_QUALITY_STEREO;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}