package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoMediaPlayerEventHandler {

    /**
     * Media player playback status callback notification
     *
     * @param mediaPlayer Callback player object
     * @param state Media player status
     * @param errorCode Error code, please refer to the common error code document [https://doc-en.zego.im/en/308.html] for details
     */
    public void onMediaPlayerStateUpdate(ZegoMediaPlayer mediaPlayer, ZegoMediaPlayerState state, int errorCode){

    }

    /**
     * Media player network status event callback notification
     *
     * @param mediaPlayer Callback player object
     * @param networkEvent Network status event
     */
    public void onMediaPlayerNetworkEvent(ZegoMediaPlayer mediaPlayer, ZegoMediaPlayerNetworkEvent networkEvent){

    }

    /**
     * Media player playback progress notification
     *
     * @param mediaPlayer Callback player object
     * @param millisecond Progress in milliseconds
     */
    public void onMediaPlayerPlayingProgress(ZegoMediaPlayer mediaPlayer, long millisecond){

    }

}

