/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.hardwaremonitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;

public class ZegoCPUUtils {
    private static double mLastProcessCpu = 0.0;
    private static double mLastAllCpu = 0.0;
    private static double mLastAllCpuForSystem = 0.0;
    private static double mLastIdleCpu = 0.0;

    public static synchronized double getProcessCPUUsage(int pid) {
        double result = 0.0;
        double[] resultP = null;
        double[] resultA = null;
        double currentProcessCpu = 0.0;
        double currentAllCpu = 0.0;
        if (pid <= 0) {
            return result;
        }
        resultP = ZegoCPUUtils.getProcessCpuAction(pid);
        if (null != resultP) {
            currentProcessCpu = resultP[1] + resultP[2];
        }
        if (null != (resultA = ZegoCPUUtils.getCpuAction())) {
            for (int i = 0; i < resultA.length; ++i) {
                currentAllCpu += resultA[i];
            }
        }
        if (mLastAllCpu == 0.0 && mLastProcessCpu == 0.0) {
            mLastAllCpu = currentAllCpu;
            mLastProcessCpu = currentProcessCpu;
            return result;
        }
        if (currentAllCpu - mLastAllCpu > 0.0 && (result = ZegoCPUUtils.div((currentProcessCpu - mLastProcessCpu) * 100.0, currentAllCpu - mLastAllCpu, 2)) < 0.0) {
            result = 0.0;
        }
        mLastAllCpu = currentAllCpu;
        mLastProcessCpu = currentProcessCpu;
        return result;
    }

    public static synchronized double getSystemCPUUsage() {
        double result = 0.0;
        double[] resultA = null;
        double currentAllCpu = 0.0;
        double currentIdleCpu = 0.0;
        resultA = ZegoCPUUtils.getCpuAction();
        if (null != resultA) {
            for (int i = 0; i < resultA.length; ++i) {
                currentAllCpu += resultA[i];
            }
            if (resultA.length > 3) {
                currentIdleCpu = resultA[3];
            }
        }
        if (mLastAllCpuForSystem == 0.0 && mLastIdleCpu == 0.0) {
            mLastAllCpuForSystem = currentAllCpu;
            mLastIdleCpu = currentIdleCpu;
            return result;
        }
        double allCpuDelta = currentAllCpu - mLastAllCpuForSystem;
        double idleCpuDelta = currentIdleCpu - mLastIdleCpu;
        if (allCpuDelta > 0.0 && idleCpuDelta > 0.0 && (result = ZegoCPUUtils.div((allCpuDelta - idleCpuDelta) * 100.0, allCpuDelta, 2)) < 0.0) {
            result = 0.0;
        }
        mLastAllCpuForSystem = currentAllCpu;
        mLastIdleCpu = currentIdleCpu;
        return result;
    }

    private static double[] getCpuAction() {
        String cpuPath = "/proc/stat";
        String cpu = "";
        double[] result = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        File f = new File(cpuPath);
        if (!f.exists() || !f.canRead()) {
            return result;
        }
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        try {
            fr = new FileReader(f);
            localBufferedReader = new BufferedReader(fr, 8192);
            cpu = localBufferedReader.readLine();
            if (null != cpu) {
                String[] cpuInfo = cpu.split(" ");
                for (int i = 2; i < cpuInfo.length && i - 2 < result.length; ++i) {
                    try {
                        result[i - 2] = Double.parseDouble(cpuInfo[i]);
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ZegoCPUUtils.closeReader(localBufferedReader);
        return result;
    }

    private static double[] getProcessCpuAction(int pid) {
        BufferedReader localBufferedReader;
        double[] result;
        block15: {
            String cpuPath = "/proc/" + pid + "/stat";
            String cpu = "";
            result = new double[]{0.0, 0.0, 0.0};
            File f = new File(cpuPath);
            if (!f.exists() || !f.canRead()) {
                return result;
            }
            FileReader fr = null;
            localBufferedReader = null;
            try {
                fr = new FileReader(f);
                localBufferedReader = new BufferedReader(fr, 8192);
                cpu = localBufferedReader.readLine();
                if (null == cpu) break block15;
                String[] cpuSplit = cpu.split(" ");
                if (cpuSplit.length > 2) {
                    try {
                        result[0] = Double.parseDouble(cpuSplit[1]);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (cpuSplit.length > 13) {
                    try {
                        result[1] = Double.parseDouble(cpuSplit[13]);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (cpuSplit.length > 14) {
                    try {
                        result[2] = Double.parseDouble(cpuSplit[14]);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ZegoCPUUtils.closeReader(localBufferedReader);
        return result;
    }

    public static double div(double d1, double d2, int scale) {
        BigDecimal bd1 = new BigDecimal(Double.toString(d1));
        BigDecimal bd2 = new BigDecimal(Double.toString(d2));
        try {
            return bd1.divide(bd2, scale, 1).doubleValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private static void closeReader(Reader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

