package im.zego.zegoexpress.constants;

/** Video frame buffer type */
public enum ZegoVideoBufferType {
    /** Raw data type video frame */
    UNKNOWN(0),
    /** Raw data type video frame */
    RAW_DATA(1),
    /** Texture 2D type video frame */
    GL_TEXTURE_2D(3),
    /** Surface Texture type video frame */
    SURFACE_TEXTURE(5);

    private int value;

    private ZegoVideoBufferType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoVideoBufferType getZegoVideoBufferType(int value) {
        try {
            return ZegoVideoBufferType.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}