package im.zego.zegoexpress.constants;

public enum ZegoStreamRelayCDNReason {
    /** 无
     */
    NONE(0),
    /** 服务器错误
     */
    SERVER_ERROR(1),
    /** 握手失败
     */
    HANDSHAKE_FAILED(2),
    /** 接入点错误
     */
    ACCESS_POINT_ERROR(3),
    /** 创建流失败
     */
    CREATE_STREAM_FAILED(4),
    /** BAD NAME
     */
    BAD_NAME(5),
    /** CDN 服务器主动断开
     */
    CDN_SERVER_DISCONNECTED(6),
    /** 主动断开
     */
    DISCONNECTED(7);

    private int value;

    private ZegoStreamRelayCDNReason(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
