package im.zego.zegoexpress.constants;

/** Application scenario */
public enum ZegoScenario {
    /** General scenario */
    GENERAL(0),
    /** Communication scenario */
    COMMUNICATION(1),
    /** Live scenario */
    LIVE(2);

    private int value;

    private ZegoScenario(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoScenario getZegoScenario(int value) {
        try {
            return ZegoScenario.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}