package im.zego.zegoexpress.constants;

/** Language */
public enum ZegoLanguage {
    /** English */
    ENGLISH(0),
    /** Chinese */
    CHINESE(1);

    private int value;

    private ZegoLanguage(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoLanguage getZegoLanguage(int value) {
        try {
            return ZegoLanguage.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}