package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

/**
 * Mix stream task object
 *
 * This class is the configuration class of the mixing stream task. When a mixing stream task is requested to the ZEGO audio and video cloud, the configuration of the mixing task is required.
 * This class describes the detailed configuration information of this mixed task.
 */
public class ZegoMixerTask {

    /** Mix stream task ID */
    private String taskID;

    /** Mix stream audio config */
    private ZegoMixerAudioConfig audioConfig;

    /** Mix stream audio config */
    private ZegoMixerVideoConfig videoConfig;

    /** Mix stream task input list */
    private ArrayList<ZegoMixerInput> inputList;

    /** Mix stream task output list */
    private ArrayList<ZegoMixerOutput> outputList;

    /** Mix stream wate rmark */
    private ZegoWatermark watermark;

    /** Mix stream background image URL */
    private String backgroundImageURL;

    /** Enable or disable sound level callback for the task. If enabled, then the remote player can get the soundLevel of every stream in the inputlist by [onMixerSoundLevelUpdate] callback. */
    private boolean soundLevel;

    /**
     * Create a mix stream task object with TaskID
     */
    public ZegoMixerTask(String taskID){
        this.taskID = taskID;
        inputList = new ArrayList<>();
        outputList = new ArrayList<>();
        audioConfig = new ZegoMixerAudioConfig();
        videoConfig = new ZegoMixerVideoConfig();
        backgroundImageURL = "";
    }

    public String getTaskID(){
        return taskID;
    }

    public void setInputList(ArrayList<ZegoMixerInput> inputList){
        this.inputList.addAll(inputList);
    }

    public void setOutputList(ArrayList<ZegoMixerOutput> outputList){
        this.outputList.addAll(outputList);
    }

    public void setAudioConfig(ZegoMixerAudioConfig config){
        this.audioConfig = config;
    }

    public void setVideoConfig(ZegoMixerVideoConfig config){
        this.videoConfig = config;
    }

    public void setBackgroundImageURL(String backgroundImageURL){
        this.backgroundImageURL = backgroundImageURL;
    }

    public void setWatermark(ZegoWatermark watermark){
        this.watermark = watermark;
    }

    public void enableSoundLevel(boolean enable){
        this.soundLevel = enable;
    }

}
