/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.receiver;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AudioRouteMonitor
extends BroadcastReceiver {
    private long mThis;
    private volatile Context mContext;
    private int mBluetoothOpSeq;
    private AtomicBoolean mIsInited = new AtomicBoolean(false);
    private final int AUDIO_ROUTE_SPEAKER = 0;
    private final int AUDIO_ROUTE_HEADSET = 1;
    private final int AUDIO_ROUTE_BLUETOOTH = 2;
    private final int AUDIO_ROUTE_RECEIVER = 3;
    private final int AUDIO_ROUTE_USB_AUDIO = 4;

    public void setThis(long pThis) {
        this.mThis = pThis;
    }

    public int init(final Context ctx) {
        this.mContext = ctx;
        if (this.mContext == null) {
            return -1;
        }
        IntentFilter intentHeadSetPlug = new IntentFilter();
        intentHeadSetPlug.addAction("android.intent.action.HEADSET_PLUG");
        intentHeadSetPlug.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentHeadSetPlug.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        if (Build.VERSION.SDK_INT >= 21) {
            intentHeadSetPlug.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            intentHeadSetPlug.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        }
        this.mContext.registerReceiver((BroadcastReceiver)this, intentHeadSetPlug);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                AudioRouteMonitor.this.mBluetoothOpSeq = 0;
                if (AudioRouteMonitor.this.mContext == null) {
                    return;
                }
                AudioRouteMonitor.this.mIsInited.set(true);
                boolean headsetConnected = false;
                boolean bluetoothConnected = false;
                boolean usbAudioConnected = false;
                try {
                    int state;
                    AudioManager audioManager = (AudioManager)ctx.getSystemService("audio");
                    if (audioManager != null) {
                        headsetConnected = audioManager.isWiredHeadsetOn();
                    }
                    bluetoothConnected = (state = BluetoothAdapter.getDefaultAdapter().getProfileConnectionState(1)) == 2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    usbAudioConnected = AudioRouteMonitor.this.detectUsbDeviceState(ctx);
                }
                AudioRouteMonitor.onDeviceStateInited(AudioRouteMonitor.this.mThis, headsetConnected, bluetoothConnected, usbAudioConnected);
            }
        });
        return 0;
    }

    public int uninit() {
        if (this.mContext == null) {
            return -1;
        }
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
        this.mContext = null;
        this.mIsInited.set(false);
        return 0;
    }

    @TargetApi(value=21)
    private boolean detectUsbDeviceState(Context ctx) {
        boolean usbAudioConnected = false;
        try {
            UsbManager usbManager = (UsbManager)ctx.getSystemService("usb");
            HashMap deviceHashMap = usbManager.getDeviceList();
            for (Map.Entry entry : deviceHashMap.entrySet()) {
                UsbDevice device = (UsbDevice)entry.getValue();
                if (null == device) continue;
                block3: for (int i = 0; !usbAudioConnected && i < device.getConfigurationCount(); ++i) {
                    UsbConfiguration configuration = device.getConfiguration(i);
                    if (null == configuration) continue;
                    for (int j = 0; j < configuration.getInterfaceCount(); ++j) {
                        UsbInterface usbInterface = configuration.getInterface(j);
                        if (null == usbInterface || 1 != usbInterface.getInterfaceClass()) continue;
                        usbAudioConnected = true;
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return usbAudioConnected;
    }

    public void onReceive(Context context, Intent intent) {
        boolean hasAudio;
        if (!this.mIsInited.get()) {
            return;
        }
        String action = intent.getAction();
        Bundle extras = intent.getExtras();
        final String strInent = "action: " + action + (extras != null && extras.size() > 0 ? ", " + extras.toString() : "");
        if ("android.intent.action.HEADSET_PLUG".equals(action)) {
            if (intent.hasExtra("state")) {
                int state = intent.getIntExtra("state", 0);
                AudioRouteMonitor.onDeviceStateChanged(this.mThis, 1, state == 1, strInent);
            }
        } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            if (state == 10) {
                ++this.mBluetoothOpSeq;
                AudioRouteMonitor.onDeviceStateChanged(this.mThis, 2, false, strInent);
            }
        } else if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(action)) {
            int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", Integer.MIN_VALUE);
            if (state == 2) {
                ++this.mBluetoothOpSeq;
                final int currentOpSeq = this.mBluetoothOpSeq;
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!AudioRouteMonitor.this.mIsInited.get()) {
                            return;
                        }
                        if (AudioRouteMonitor.this.mBluetoothOpSeq == currentOpSeq) {
                            AudioRouteMonitor.onDeviceStateChanged(AudioRouteMonitor.this.mThis, 2, true, strInent);
                        }
                    }
                }, 1500L);
            } else if (state == 0) {
                ++this.mBluetoothOpSeq;
                AudioRouteMonitor.onDeviceStateChanged(this.mThis, 2, false, strInent);
            }
        } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
            boolean hasAudio2 = this.hasUsbAudioDevice(intent);
            if (hasAudio2) {
                AudioRouteMonitor.onDeviceStateChanged(this.mThis, 4, true, strInent);
            }
        } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (hasAudio = this.hasUsbAudioDevice(intent))) {
            AudioRouteMonitor.onDeviceStateChanged(this.mThis, 4, false, strInent);
        }
    }

    @TargetApi(value=21)
    private boolean hasUsbAudioDevice(Intent intent) {
        boolean hasAudio = false;
        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
        if (device != null) {
            int count = device.getConfigurationCount();
            block0: for (int i = 0; !hasAudio && i < count; ++i) {
                UsbConfiguration configuration = device.getConfiguration(i);
                if (null == configuration) continue;
                int interfaceCount = configuration.getInterfaceCount();
                for (int j = 0; j < interfaceCount; ++j) {
                    UsbInterface usbInterface = configuration.getInterface(j);
                    if (null == usbInterface || usbInterface.getInterfaceClass() != 1) continue;
                    hasAudio = true;
                    continue block0;
                }
            }
        }
        return hasAudio;
    }

    static native void onDeviceStateInited(long var0, boolean var2, boolean var3, boolean var4);

    static native void onDeviceStateChanged(long var0, int var2, boolean var3, String var4);
}

