package im.zego.zegoexpress.utils;

import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.widget.Toast;

import java.io.File;

public class ZegoJniUtil {

    public static void showToastMsg(final String msg, final Context context) {
        //todo 是否有可能线程不安全
        if (context != null) {
            try {
                if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                    Toast.makeText(context, msg, Toast.LENGTH_LONG).show();
                } else {
                    Handler handler = new  Handler(Looper.getMainLooper());
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(context, msg, Toast.LENGTH_LONG).show();
                        }
                    });
                    handler = null;
                }
            } catch (Exception e) {
                //do nothing
            }
        }
    }

}
