package im.zego.zegoexpress.constants;

/** Video frame format */
public enum ZegoVideoFrameFormat {
    /** Unknown format, will take platform default */
    Unknown(0),
    /** I420 (YUV420Planar) format */
    I420(1),
    /** NV12 (YUV420SemiPlanar) format */
    NV12(2),
    /** NV21 (YUV420SemiPlanar) format */
    NV21(3),
    /** BGRA32 format */
    BGRA32(4),
    /** RGBA32 format */
    RGBA32(5),
    /** ARGB32 format */
    ARGB32(6),
    /** ABGR32 format */
    ABGR32(7),
    /** I422 (YUV422Planar) format */
    I422(8);

    private int value;

    private ZegoVideoFrameFormat(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoVideoFrameFormat getZegoVideoFrameFormat(int value) {
        try {
            return ZegoVideoFrameFormat.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}