package im.zego.zegoexpress.constants;

/** Remote device status */
public enum ZegoRemoteDeviceState {
    /** Device on */
    OPEN(0),
    /** General device error */
    GENERIC_ERROR(1),
    /** Invalid device ID */
    INVALID_ID(2),
    /** No permission */
    NO_AUTHORIZATION(3),
    /** Captured frame rate is 0 */
    ZERO_FPS(4),
    /** The device is occupied */
    IN_USE_BY_OTHER(5),
    /** The device is not plugged in or unplugged */
    UNPLUGGED(6),
    /** The system needs to be restarted */
    REBOOT_REQUIRED(7),
    /** System media services stop, such as under the iOS platform, when the system detects that the current pressure is huge (such as playing a lot of animation), it is possible to disable all media related services. */
    SYSTEM_MEDIA_SERVICES_LOST(8),
    /** Capturing disabled */
    DISABLE(9),
    /** The remote device is muted */
    MUTE(10),
    /** The device is interrupted, such as a phone call interruption, etc. */
    INTERRUPTION(11),
    /** There are multiple apps at the same time in the foreground, such as the iPad app split screen, the system will prohibit all apps from using the camera. */
    IN_BACKGROUND(12),
    /** CDN server actively disconnected */
    MULTI_FOREGROUND_APP(13),
    /** The system is under high load pressure and may cause abnormal equipment. */
    BY_SYSTEM_PRESSURE(14);

    private int value;

    private ZegoRemoteDeviceState(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoRemoteDeviceState getZegoRemoteDeviceState(int value) {
        try {
            return ZegoRemoteDeviceState.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}