package im.zego.zegoexpress.constants;

/** Traffic control property (bitmask enumeration) */
public enum ZegoTrafficControlProperty {
    /** Basic */
    BASIC(0),
    /** Adaptive FPS */
    ADAPTIVE_FPS(1),
    /** Adaptive resolution */
    ADAPTIVE_RESOLUTION(1 << 1),
    /** Adaptive Audio bitrate */
    ADAPTIVE_AUDIO_BITRATE(1 << 2);

    private int value;

    private ZegoTrafficControlProperty(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoTrafficControlProperty getZegoTrafficControlProperty(int value) {
        try {
            return ZegoTrafficControlProperty.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}