package im.zego.zegoexpress.constants;

/** Stream quality level */
public enum ZegoStreamQualityLevel {
    /** Excellent */
    EXCELLENT(0),
    /** Good */
    GOOD(1),
    /** Normal */
    MEDIUM(2),
    /** Bad */
    BAD(3),
    /** Failed */
    DIE(4);

    private int value;

    private ZegoStreamQualityLevel(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoStreamQualityLevel getZegoStreamQualityLevel(int value) {
        try {
            return ZegoStreamQualityLevel.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}