package im.zego.zegoexpress.constants;

/** Media event when playing */
public enum ZegoPlayerMediaEvent {
    /** Audio stuck event when playing */
    AUDIO_BREAK_OCCUR(0),
    /** Audio stuck event recovery when playing */
    AUDIO_BREAK_RESUME(1),
    /** Video stuck event when playing */
    VIDEO_BREAK_OCCUR(2),
    /** Video stuck event recovery when playing */
    VIDEO_BREAK_RESUME(3);

    private int value;

    private ZegoPlayerMediaEvent(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoPlayerMediaEvent getZegoPlayerMediaEvent(int value) {
        try {
            return ZegoPlayerMediaEvent.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}