
package im.zego.zegoexpress;

final public class ZegoExpressErrorCode{

    /** 执行成功 */
    final static public int CommonSuccess                                      = 0;

    /** 未初始化引擎，在调用非静态方法前需要先初始化引擎 */
    final static public int CommonEngineNotCreate                              = 1000001;

    /** 未登陆房间, 在调用推流或拉流前，请先登陆房间 */
    final static public int CommonNotLoginRoom                                 = 1000002;

    /** 引擎未启动，请先调用预览/推流/拉流接口 */
    final static public int CommonEngineNotStarted                             = 1000003;

    /** 调用了当前平台不支持的接口, 例如在非Android平台调用了设置Android上下文环境的接口 */
    final static public int CommonUnsupportedPlatform                          = 1000006;

    /** 无效的 Android 上下文环境 */
    final static public int CommonInvalidAndroidEnvironment                    = 1000007;

    /** SDK没有包含此模块功能，请联系技术支持提供 */
    final static public int CommonSdkNoModule                                  = 1000010;

    /** 输入流ID超长, 最大支持输入256个字符 */
    final static public int CommonStreamIdTooLong                              = 1000014;

    /** 输入流ID为空 */
    final static public int CommonStreamIdNull                                 = 1000015;

    /** 输入流ID包含非法字符 */
    final static public int CommonStreamIdInvalidCharacter                     = 1000016;

    /** 该AppID已经下线 */
    final static public int CommonAppOfflineError                              = 1000037;

    /** 后台配置有错误，请检查APP配置项 */
    final static public int CommonAppFlexiableConfigError                      = 1000038;

    /** CDN地址有误，请检查支持的协议和格式 */
    final static public int CommonCdnUrlInvalid                                = 1000055;

    /** DNS解析失败，请检查网络配置 */
    final static public int CommonDnsResolveError                              = 1000060;

    /** 服务器调度异常，请联系技术支持解决 */
    final static public int CommonDispatchError                                = 1000065;

    /** 内部空指针错误，请联系技术支持解决 */
    final static public int CommonInnerNullptr                                 = 1000090;

    /** app ID不能为0，请检查app ID是否正确 */
    final static public int EngineAppidZero                                    = 1001000;

    /** 输入AppSign长度必须为64字节 */
    final static public int EngineAppsignInvalidLength                         = 1001001;

    /** 输入AppSign包含非法字符, 仅支持'0'-'9','a'-'f','A'-'F' */
    final static public int EngineAppsignInvalidCharacter                      = 1001002;

    /** 输入AppSign为空 */
    final static public int EngineAppsignNull                                  = 1001003;

    /** 认证失败，请检查app ID是否正确；或是否在没有向ZEGO申请上线的情况下选择了正式环境初始化 */
    final static public int EngineAppidIncorrectOrNotOnline                    = 1001004;

    /** AppSign认证失败，请检查AppSign是否正确 */
    final static public int EngineAppsignIncorrect                             = 1001005;

    /** 日志没有写入权限 */
    final static public int EngineLogNoWritePermission                         = 1001014;

    /** 输入日志的路径超长 */
    final static public int EngineLogPathTooLong                               = 1001015;

    /** 登陆房间数量超过上限，当前仅支持同时登陆1个房间 */
    final static public int RoomCountExceed                                    = 1002001;

    /** 输入用户ID为空 */
    final static public int RoomUserIdNull                                     = 1002005;

    /** 输入用户ID包含非法字符 */
    final static public int RoomUserIdInvalidCharacter                         = 1002006;

    /** 输入用户ID超长，最大支持输入64个字符 */
    final static public int RoomUserIdTooLong                                  = 1002007;

    /** 输入用户名为空 */
    final static public int RoomUserNameNull                                   = 1002008;

    /** 输入用户名包含非法字符 */
    final static public int RoomUserNameInvalidCharacter                       = 1002009;

    /** 输入用户ID超长，最大支持输入256个字符 */
    final static public int RoomUserNameTooLong                                = 1002010;

    /** 输入房间ID为空 */
    final static public int RoomRoomidNull                                     = 1002011;

    /** 输入房间ID包含非法字符 */
    final static public int RoomRoomidInvalidCharacter                         = 1002012;

    /** 输入房间ID超长，最大支持输入128个字符 */
    final static public int RoomRoomidTooLong                                  = 1002013;

    /** 登陆房间失败，可能是由于网络原因 */
    final static public int RoomErrorConnectFailed                             = 1002030;

    /** 登陆房间超时，可能是由于网络原因 */
    final static public int RoomErrorLoginTimeout                              = 1002031;

    /** 登陆房间鉴权失败 */
    final static public int RoomErrorAuthenticationFailed                      = 1002033;

    /** 登陆房间的用户数超过该房间配置的最大用户数量限制 */
    final static public int RoomErrorExceedMaximumMember                       = 1002034;

    /** 用户被踢出房间，可能是相同用户ID在其他设备登陆 */
    final static public int RoomKickedOut                                      = 1002050;

    /** 网络原因导致房间连接临时中断，正在重试 */
    final static public int RoomConnectTemporaryBroken                         = 1002051;

    /** 房间连接断开，可能是由于网络原因导致 */
    final static public int RoomDisconnect                                     = 1002052;

    /** 重试登录房间超过最大的重试时间 */
    final static public int RoomRetryTimeout                                   = 1002053;

    /** 业务后台发出了踢出房间信令，请查看被踢原因 */
    final static public int RoomManualKickedOut                                = 1002055;

    /** 系统内部异常导致房间登陆失败 */
    final static public int RoomInnerError                                     = 1002099;

    /** 推流失败，有可能是推流没有数据 */
    final static public int PublisherPublishStreamFailed                       = 1003001;

    /** 码率设置有误，请检查单位(kbps)是否有误 */
    final static public int PublisherBitrateInvalid                            = 1003002;

    /** 推流流控参数设置有误 */
    final static public int PublisherTrafficModeInvalid                        = 1003005;

    /** 推流临时中断，正在重试 */
    final static public int PublisherErrorNetworkInterrupt                     = 1003020;

    /** 推流失败，该用户已在推流 */
    final static public int PublisherErrorAlreadyDoPublish                     = 1003023;

    /** 推流失败，该流被后台系统配置为禁止推送 */
    final static public int PublisherErrorServerForbid                         = 1003025;

    /** 推流失败，房间内已有相同的流 */
    final static public int PublisherErrorRepetitivePublishStream              = 1003028;

    /** 更新转推CDN状态失败，请检测URL是否合法 */
    final static public int PublisherUpdateCdnTargetError                      = 1003040;

    /** 发送SEI失败，data为空 */
    final static public int PublisherSeiDataNull                               = 1003043;

    /** 发送SEI失败，data超长，最大支持4096个字符 */
    final static public int PublisherSeiDataTooLong                            = 1003044;

    /** 流附加信息为空 */
    final static public int PublisherExtraInfoNull                             = 1003050;

    /** 流附加信息超长，最大为1024个字符 */
    final static public int PublisherExtraInfoTooLong                          = 1003051;

    /** 更新流附加信息失败，请检查网络连接 */
    final static public int PublisherUpdateExtraInfoFailed                     = 1003053;

    /** 推流水印路径为空 */
    final static public int PublisherWatermarkUrlNull                          = 1003055;

    /** 推流水印路径超长，最大为1024个字符 */
    final static public int PublisherWatermarkUrlTooLong                       = 1003056;

    /** 推流水印格式错误，仅支持 jpg 和 png 格式 */
    final static public int PublisherWatermarkUrlInvalid                       = 1003057;

    /** 推流水印布局有误，布局区域不能超出编码分辨率大小 */
    final static public int PublisherWatermarkLayoutInvalid                    = 1003058;

    /** 系统内部异常导致推流失败 */
    final static public int PublisherInnerError                                = 1003099;

    /** 推流失败，有可能是拉流没有数据 */
    final static public int PlayerPlayStreamFailed                             = 1004001;

    /** 拉流超过最大的数量，目前支持最多12路拉流（如有需要可联系技术支持扩容） */
    final static public int PlayerCountExceed                                  = 1004010;

    /** 拉流临时中断，正在重试 */
    final static public int PlayerErrorNetworkInterrupt                        = 1004020;

    /** 系统内部异常导致拉流失败 */
    final static public int PlayerInnerError                                   = 1004099;

    /** 无混流服务，请联系技术支持开启 */
    final static public int MixerNoServices                                    = 1005000;

    /** 混流任务ID为空 */
    final static public int MixerTaskIdNull                                    = 1005001;

    /** 混流任务ID超长，最大为256个字符 */
    final static public int MixerTaskIdTooLong                                 = 1005002;

    /** 混流任务ID中含有非法字符 */
    final static public int MixerTaskIdInvalidCharacter                        = 1005003;

    /** 混流任务配置未指定输出 */
    final static public int MixerNoOutputTarget                                = 1005005;

    /** 混流输出目标有误，请检查是否target为streamID时，传入了非法字符 */
    final static public int MixerOutputTargetInvalid                           = 1005006;

    /** 启动混流任务请求失败，可能是由于网络原因 */
    final static public int MixerStartRequestError                             = 1005010;

    /** 停止混流任务请求失败，可能是由于网络原因 */
    final static public int MixerStopRequestError                              = 1005011;

    /** 该混流任务必须由该任务的启动用户执行停止操作 */
    final static public int MixerNotOwnerStopMixer                             = 1005012;

    /** 混流任务启动过于频繁 */
    final static public int MixerStartQpsOverload                              = 1005015;

    /** 混流任务停止过于频繁 */
    final static public int MixerStopQpsOverload                               = 1005016;

    /** 混流任务输入流列表为空 */
    final static public int MixerInputListInvalid                              = 1005020;

    /** 混流任务输出列表为空 */
    final static public int MixerOutputListInvalid                             = 1005021;

    /** 混流任务视频配置无效 */
    final static public int MixerVideoConfigInvalid                            = 1005023;

    /** 混流任务音频配置无效，请检查是否使用了不支持的编解码 */
    final static public int MixerAudioConfigInvalid                            = 1005024;

    /** 超过最大的输入流数量，最大支持9个输入流 */
    final static public int MixerExceedMaxInputCount                           = 1005025;

    /** 输入流不存在 */
    final static public int MixerInputStreamNotExists                          = 1005026;

    /** 混流输入参数错误，可能是输入流的布局超过画布范围 */
    final static public int MixerInputParametersError                          = 1005027;

    /** 超过最大的输出流数量，最大支持3个输出流 */
    final static public int MixerExceedMaxOutputCount                          = 1005030;

    /** 混流认证失败 */
    final static public int MixerAuthenticationFailed                          = 1005050;

    /** 输入水印为空 */
    final static public int MixerWatermarkNull                                 = 1005061;

    /** 输入水印参数错误，可能是布局超过画布范围 */
    final static public int MixerWatermarkParametersError                      = 1005062;

    /** 输入水印URL非法，必须以preset-id://开头且需要是.jpg或.png结尾 */
    final static public int MixerWatermarkUrlInvalid                           = 1005063;

    /** 输入背景图URL非法，必须以preset-id://开头且需要是.jpg或.png结尾 */
    final static public int MixerBackgroundImageUrlInvalid                     = 1005067;

    /** 未找到自动混流服务器，请联系技术支持配置 */
    final static public int MixerAutoMixStreamServerNotFound                   = 1005070;

    /** 混流内部错误 */
    final static public int MixerInnerError                                    = 1005099;

    /** 设备一般错误 */
    final static public int DeviceErrorTypeGeneric                             = 1006001;

    /** 设备ID不存在 */
    final static public int DeviceErrorTypeInvalidId                           = 1006002;

    /** 没有设备权限，请检查摄像头或麦克风的权限 */
    final static public int DeviceErrorTypeNoAuthorization                     = 1006003;

    /** 视频设备采集帧率为0 */
    final static public int DeviceErrorTypeZeroFps                             = 1006004;

    /** 设备被占用 */
    final static public int DeviceErrorTypeInUseByOther                        = 1006005;

    /** 设备被拔出 */
    final static public int DeviceErrorTypeUnplugged                           = 1006006;

    /** 设备需要重启 */
    final static public int DeviceErrorTypeRebootRequired                      = 1006007;

    /** 设备媒体丢失 */
    final static public int DeviceErrorMediaServicesLost                       = 1006008;

    /** 释放释放设备列表时，列表为空 */
    final static public int DeviceFreeDeviceListNull                           = 1006020;

    /** 设备内部错误 */
    final static public int DeviceInnerError                                   = 1006099;

    /** 美颜参数非法，请检查传入的参数 */
    final static public int PreprocessBeautifyOptionInvalid                    = 1007005;

    /** 没有创建该媒体播放器实例 */
    final static public int MediaplayerNoInstance                              = 1008001;

    /** 媒体播放器播放失败，未加载资源文件 */
    final static public int MediaplayerNoFilePath                              = 1008003;

    /** 媒体播放器载入文件失败，不支持该格式文件 */
    final static public int MediaplayerFileFormatError                         = 1008005;

    /** 媒体播放器载入文件失败，路径不存在 */
    final static public int MediaplayerFilePathNotExists                       = 1008006;

    /** 媒体播放器载入文件失败，解码错误 */
    final static public int MediaplayerFileDecodeError                         = 1008007;

    /** 媒体播放器载入文件失败，无可播放的音视频流 */
    final static public int MediaplayerFileNoSupportedStream                   = 1008008;

    /** 媒体播放器播放失败，文件解析过程中出现错误 */
    final static public int MediaplayerDemuxError                              = 1008010;

    /** 媒体播放器Seek失败，可能是还没加载文件 */
    final static public int MediaplayerSeekError                               = 1008016;

    /** 媒体播放器设置了该平台不支持的视频数据格式（如iOS平台下 CVPixelBuffer 不支持NV21） */
    final static public int MediaplayerPlatformFormatNotSupported              = 1008020;

    /** 媒体播放器创建实例超过最大限制，最多可创建4个实例 */
    final static public int MediaplayerExceedMaxCount                          = 1008030;

    /** 媒体播放器内部错误 */
    final static public int MediaplayerInnerError                              = 1008099;

    /** 输入消息内容为空 */
    final static public int ImContentNull                                      = 1009001;

    /** 输入消息内容超长，最长为1024字节 */
    final static public int ImContentTooLong                                   = 1009002;

    /** 发送消息失败，可能是由于网络原因 */
    final static public int ImSendFailed                                       = 1009010;

    /** 自定义视频采集器未创建，请确保在收到OnStart回调后使用 */
    final static public int ExternalioCustomVideoCapturerNotCreated            = 1011001;

    /** 自定义视频采集模块未开启，请确保在初始化配置中已开启自定义视频采集 */
    final static public int ExternalioNoCustomVideoCapture                     = 1011002;

    /** 当前设置的自定义视频采集格式不支持该API */
    final static public int ExternalioNotSupportedFormat                       = 1011010;


}
