/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress;

import android.os.Handler;
import android.os.Looper;
import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoMediaPlayerAudioHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerSeekToCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerVideoHandler;
import im.zego.zegoexpress.constants.ZegoAudioChannel;
import im.zego.zegoexpress.constants.ZegoMediaPlayerNetworkEvent;
import im.zego.zegoexpress.constants.ZegoMediaPlayerState;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ZegoMediaPlayerJni {
    private static Handler mUIHandler = new Handler(Looper.getMainLooper());
    private static HashMap<ZegoMediaPlayer, IdxAndHandler> mediaplayerToIdxAndEventhandler = new HashMap();

    static void setEventHandler(ZegoMediaPlayer mediaplayer, IZegoMediaPlayerEventHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            idxAndHandler.eventHandler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerStateUpdateCallback(int state, final int errorcode, int idx) {
        final ZegoMediaPlayerState zegoMediaPlayerState = ZegoMediaPlayerState.values()[state];
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            for (final Map.Entry<ZegoMediaPlayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        iZegoMediaPlayerEventHandler.onMediaPlayerStateUpdate((ZegoMediaPlayer)item.getKey(), zegoMediaPlayerState, errorcode);
                    }
                });
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerNetWorkEventCallback(int event, int idx) {
        final ZegoMediaPlayerNetworkEvent zegoMediaPlayerNetworkEvent = ZegoMediaPlayerNetworkEvent.values()[event];
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            for (final Map.Entry<ZegoMediaPlayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        iZegoMediaPlayerEventHandler.onMediaPlayerNetworkEvent((ZegoMediaPlayer)item.getKey(), zegoMediaPlayerNetworkEvent);
                    }
                });
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerPlayingProgressCallback(int idx, final long millisecond) {
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            for (final Map.Entry<ZegoMediaPlayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
                        synchronized (ZegoMediaPlayerJni.class) {
                            iZegoMediaPlayerEventHandler.onMediaPlayerPlayingProgress((ZegoMediaPlayer)item.getKey(), millisecond);
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    static void setVideoHandler(ZegoMediaPlayer mediaplayer, ZegoVideoFrameFormat frameFormat, IZegoMediaPlayerVideoHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            idxAndHandler.videoHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJni.enableVideoDataJni(frameFormat.value(), false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJni.enableVideoDataJni(frameFormat.value(), true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerVideoHandlerCallback(int idx, ByteBuffer[] buffer, int[] datalength, int[] strides, int format, int width, int height) {
        ZegoVideoFrameParam videoFrameParam = new ZegoVideoFrameParam();
        videoFrameParam.height = height;
        for (int i = 0; i < strides.length; ++i) {
            videoFrameParam.strides[i] = strides[i];
        }
        videoFrameParam.width = width;
        videoFrameParam.format = ZegoVideoFrameFormat.values()[format];
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            for (Map.Entry<ZegoMediaPlayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                IZegoMediaPlayerVideoHandler mediaPlayerVideoHandler = item.getValue().videoHandler;
                if (mediaPlayerVideoHandler == null) {
                    // ** MonitorExit[var8_9] (shouldn't be in output)
                    return;
                }
                mediaPlayerVideoHandler.onVideoFrame(item.getKey(), buffer, datalength, videoFrameParam);
            }
            // ** MonitorExit[var8_9] (shouldn't be in output)
            return;
        }
    }

    static void setAudioHandler(ZegoMediaPlayer mediaplayer, IZegoMediaPlayerAudioHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            idxAndHandler.audioHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJni.enableAudioDataJni(false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJni.enableAudioDataJni(true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerAudioHandlerCallback(int idx, ByteBuffer buffer, int bufferLength, int channel, int samplesRate) {
        ZegoAudioFrameParam audioFrame = new ZegoAudioFrameParam();
        audioFrame.channel = ZegoAudioChannel.values()[channel];
        audioFrame.sampleRate = samplesRate;
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            for (Map.Entry<ZegoMediaPlayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                IZegoMediaPlayerAudioHandler mediaPlayerAudioHandler = item.getValue().audioHandler;
                if (mediaPlayerAudioHandler == null) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
                mediaPlayerAudioHandler.onAudioFrame(item.getKey(), buffer, bufferLength, audioFrame);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    static void loadResource(ZegoMediaPlayer mediaplayer, String path, IZegoMediaPlayerLoadResourceCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.loadResourceJni(idxAndHandler.kMediaPlayerIdx, path);
            idxAndHandler.loadResourceCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onLoadResourceCallback(int idx, final int errorcode) {
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            for (Map.Entry<ZegoMediaPlayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerLoadResourceCallback iZegoMediaPlayerLoadResourceCallback = item.getValue().loadResourceCallback;
                if (iZegoMediaPlayerLoadResourceCallback == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        iZegoMediaPlayerLoadResourceCallback.onLoadResourceCallback(errorcode);
                    }
                });
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static void start(ZegoMediaPlayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.startJni(idxAndHandler.kMediaPlayerIdx);
        }
    }

    static void stop(ZegoMediaPlayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.stopJni(idxAndHandler.kMediaPlayerIdx);
        }
    }

    static void pause(ZegoMediaPlayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.pauseJni(idxAndHandler.kMediaPlayerIdx);
        }
    }

    static void resume(ZegoMediaPlayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.resumeJni(idxAndHandler.kMediaPlayerIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void seekTo(ZegoMediaPlayer mediaplayer, long millisecond, IZegoMediaPlayerSeekToCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler == null) return;
        int seq = ZegoMediaPlayerJni.seekToJni(idxAndHandler.kMediaPlayerIdx, millisecond);
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            idxAndHandler.seekToTimeCallbackHashMap.put(seq, callback);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onSeekToTimeCallback(final int seq, int idx, final int errorcode) {
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            for (final Map.Entry<ZegoMediaPlayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerSeekToCallback seekToTimeCallback = item.getValue().seekToTimeCallbackHashMap.get(seq);
                if (seekToTimeCallback == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        seekToTimeCallback.onSeekToTimeCallback(errorcode);
                        ((IdxAndHandler)item.getValue()).seekToTimeCallbackHashMap.remove(seq);
                    }
                });
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static void enableRepeat(ZegoMediaPlayer mediaplayer, boolean enable) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.enableRepeatJni(idxAndHandler.kMediaPlayerIdx, enable);
        }
    }

    public static void enableAux(ZegoMediaPlayer mediaplayer, boolean enable) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.enableAuxJni(idxAndHandler.kMediaPlayerIdx, enable);
        }
    }

    public static void muteLocal(ZegoMediaPlayer mediaplayer, boolean mute) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.muteLocalJni(idxAndHandler.kMediaPlayerIdx, mute);
        }
    }

    static void setPlayerCanvas(ZegoMediaPlayer mediaplayer, ZegoCanvas canvas) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            if (canvas != null) {
                ZegoMediaPlayerJni.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, canvas.view, canvas.viewMode.value(), canvas.backgroundColor);
            } else {
                ZegoMediaPlayerJni.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, null, 0, 0);
            }
        }
    }

    static void setVolume(ZegoMediaPlayer mediaplayer, int volume) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.setVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
        }
    }

    static int getVolume(ZegoMediaPlayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJni.getVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }

    static void setProgressInterval(ZegoMediaPlayer mediaplayer, long millisecond) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJni.setProgressIntervalJni(idxAndHandler.kMediaPlayerIdx, millisecond);
        }
    }

    static long getTotalDuration(ZegoMediaPlayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJni.getTotalDurationJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1L;
    }

    static long getCurrentProgress(ZegoMediaPlayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJni.getCurrentProgressJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1L;
    }

    public static ZegoMediaPlayer createMediaPlayer() {
        int index = ZegoMediaPlayerJni.createMediaPlayerJni();
        if (index >= 0) {
            ZegoMediaPlayer zegoMediaPlayer = new ZegoMediaPlayer();
            IdxAndHandler idxAndHandler = new IdxAndHandler(index);
            idxAndHandler.seekToTimeCallbackHashMap = new HashMap();
            mediaplayerToIdxAndEventhandler.put(zegoMediaPlayer, idxAndHandler);
            return zegoMediaPlayer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyMediaPlayer(ZegoMediaPlayer mediaplayer) {
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
                if (item.getKey() != mediaplayer) continue;
                item.getValue().videoHandler = null;
                item.getValue().audioHandler = null;
                item.getValue().eventHandler = null;
                item.getValue().loadResourceCallback = null;
                Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                while (itSeekToTimeCallbackHashMap.hasNext()) {
                    itSeekToTimeCallbackHashMap.remove();
                }
                item.getValue().seekToTimeCallbackHashMap = null;
                int idx = item.getValue().kMediaPlayerIdx;
                ZegoMediaPlayerJni.destroyMediaPlayerJni(idx);
                it.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAllMediaPlayer() {
        Class<ZegoMediaPlayerJni> clazz = ZegoMediaPlayerJni.class;
        synchronized (ZegoMediaPlayerJni.class) {
            Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
                item.getValue().videoHandler = null;
                item.getValue().audioHandler = null;
                item.getValue().eventHandler = null;
                item.getValue().loadResourceCallback = null;
                Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                while (itSeekToTimeCallbackHashMap.hasNext()) {
                    itSeekToTimeCallbackHashMap.remove();
                }
                item.getValue().seekToTimeCallbackHashMap = null;
                int idx = item.getValue().kMediaPlayerIdx;
                ZegoMediaPlayerJni.destroyMediaPlayerJni(idx);
                it.remove();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static ZegoMediaPlayerState getCurrentState(ZegoMediaPlayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            int state = ZegoMediaPlayerJni.getCurrentStateJni(idxAndHandler.kMediaPlayerIdx);
            ZegoMediaPlayerState zegoMediaPlayerState = state == ZegoMediaPlayerState.NO_PLAY.value() ? ZegoMediaPlayerState.NO_PLAY : (state == ZegoMediaPlayerState.PLAYING.value() ? ZegoMediaPlayerState.PLAYING : (state == ZegoMediaPlayerState.PAUSING.value() ? ZegoMediaPlayerState.PAUSING : (state == ZegoMediaPlayerState.PLAY_ENDED.value() ? ZegoMediaPlayerState.PLAY_ENDED : ZegoMediaPlayerState.NO_PLAY)));
            return zegoMediaPlayerState;
        }
        return ZegoMediaPlayerState.NO_PLAY;
    }

    static native int getCurrentStateJni(int var0);

    static native int destroyMediaPlayerJni(int var0);

    static native int createMediaPlayerJni();

    static native int startJni(int var0);

    static native int stopJni(int var0);

    static native int pauseJni(int var0);

    static native int resumeJni(int var0);

    static native int enableRepeatJni(int var0, boolean var1);

    static native int enableAuxJni(int var0, boolean var1);

    static native int muteLocalJni(int var0, boolean var1);

    static native int setPlayerCanvasJni(int var0, Object var1, int var2, int var3);

    static native int setVolumeJni(int var0, int var1);

    static native int setProgressIntervalJni(int var0, long var1);

    static native long getTotalDurationJni(int var0);

    static native long getCurrentProgressJni(int var0);

    static native int seekToJni(int var0, long var1);

    static native int loadResourceJni(int var0, String var1);

    static native int enableAudioDataJni(boolean var0, int var1);

    static native int enableVideoDataJni(int var0, boolean var1, int var2);

    static native int getVolumeJni(int var0);

    static class IdxAndHandler {
        int kMediaPlayerIdx;
        HashMap<Integer, IZegoMediaPlayerSeekToCallback> seekToTimeCallbackHashMap;
        IZegoMediaPlayerLoadResourceCallback loadResourceCallback;
        IZegoMediaPlayerEventHandler eventHandler;
        IZegoMediaPlayerAudioHandler audioHandler;
        IZegoMediaPlayerVideoHandler videoHandler;

        IdxAndHandler(int idx) {
            this.kMediaPlayerIdx = idx;
        }
    }
}

