/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress;

import android.app.Application;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import im.zego.zegoexpress.ZegoExpressEngine;
import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.ZegoMediaPlayerJni;
import im.zego.zegoexpress.callback.IZegoCustomVideoCaptureHandler;
import im.zego.zegoexpress.callback.IZegoCustomVideoRenderHandler;
import im.zego.zegoexpress.callback.IZegoDestroyCompletionCallback;
import im.zego.zegoexpress.callback.IZegoEventHandler;
import im.zego.zegoexpress.callback.IZegoIMSendBarrageMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendBroadcastMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendCustomCommandCallback;
import im.zego.zegoexpress.callback.IZegoMixerStartCallback;
import im.zego.zegoexpress.callback.IZegoMixerStopCallback;
import im.zego.zegoexpress.callback.IZegoPublisherSetStreamExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoPublisherUpdateCdnUrlCallback;
import im.zego.zegoexpress.constants.ZegoAECMode;
import im.zego.zegoexpress.constants.ZegoCapturePipelineScaleMode;
import im.zego.zegoexpress.constants.ZegoDebugLayer;
import im.zego.zegoexpress.constants.ZegoDebugLevel;
import im.zego.zegoexpress.constants.ZegoLanguage;
import im.zego.zegoexpress.constants.ZegoOrientation;
import im.zego.zegoexpress.constants.ZegoPlayerMediaEvent;
import im.zego.zegoexpress.constants.ZegoPlayerState;
import im.zego.zegoexpress.constants.ZegoPlayerVideoLayer;
import im.zego.zegoexpress.constants.ZegoPublishChannel;
import im.zego.zegoexpress.constants.ZegoPublisherState;
import im.zego.zegoexpress.constants.ZegoRemoteDeviceState;
import im.zego.zegoexpress.constants.ZegoRoomState;
import im.zego.zegoexpress.constants.ZegoScenario;
import im.zego.zegoexpress.constants.ZegoTrafficControlMinVideoBitrateMode;
import im.zego.zegoexpress.constants.ZegoUpdateType;
import im.zego.zegoexpress.constants.ZegoVideoFlipMode;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.constants.ZegoVideoMirrorMode;
import im.zego.zegoexpress.constants.ZegoViewMode;
import im.zego.zegoexpress.entity.ZegoAudioConfig;
import im.zego.zegoexpress.entity.ZegoBarrageMessageInfo;
import im.zego.zegoexpress.entity.ZegoBeautifyOption;
import im.zego.zegoexpress.entity.ZegoBroadcastMessageInfo;
import im.zego.zegoexpress.entity.ZegoCDNConfig;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoEngineConfig;
import im.zego.zegoexpress.entity.ZegoMixerTask;
import im.zego.zegoexpress.entity.ZegoPlayStreamQuality;
import im.zego.zegoexpress.entity.ZegoPlayerConfig;
import im.zego.zegoexpress.entity.ZegoPublishStreamQuality;
import im.zego.zegoexpress.entity.ZegoReverbParam;
import im.zego.zegoexpress.entity.ZegoRoomConfig;
import im.zego.zegoexpress.entity.ZegoStream;
import im.zego.zegoexpress.entity.ZegoStreamRelayCDNInfo;
import im.zego.zegoexpress.entity.ZegoUser;
import im.zego.zegoexpress.entity.ZegoVideoConfig;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.entity.ZegoWatermark;
import im.zego.zegoexpress.utils.ZegoLibraryLoadUtil;
import im.zego.zegoexpress.utils.ZegoLogUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

final class ZegoExpressEngineJni {
    private static Handler mUIHandler;
    private static volatile boolean hasSoLoaded;
    private static volatile ZegoExpressEngine engine;
    private static Application context;
    private static boolean mIsTestEnv;
    private static ZegoLanguage language;
    private static IZegoEventHandler eventHandler;
    private static HashMap<Integer, IZegoPublisherUpdateCdnUrlCallback> sPublisherUpdateCDNURLHandler;
    private static HashMap<Integer, IZegoPublisherSetStreamExtraInfoCallback> sPublisherUpdateStreamExtraInfoHandler;
    private static HashMap<Integer, IZegoIMSendBarrageMessageCallback> sIMSendBarragetMssageHandler;
    private static HashMap<Integer, IZegoMixerStartCallback> sMixerStartResultHandler;
    private static HashMap<Integer, IZegoMixerStopCallback> sMixerStopResultHandler;
    private static HashMap<Integer, IZegoIMSendBroadcastMessageCallback> sIMSendBoradcastMssageHandler;
    private static HashMap<Integer, IZegoIMSendCustomCommandCallback> sIMSendCustomCommandHandler;
    private static boolean isNoErrorCallback;
    private static final int MAX_EVENT_HANDLE_COUNT = 16;
    private static final int ZEGO_EXPRESS_MODULE_JNI = 12;
    private static final int RESERVE_SEGMENT = 1000000;
    private static final int ERRCODE_OFFSET = 1000;
    private static final int ZEGO_ERRCODE_SUCCESS = 0;
    private static final int ZEGO_ERRCODE_COMMON_ENGINE_NOT_CREATED = 1000001;
    private static final int ZEGO_ERRCODE_ENGINE_APPID_ZERO = 1001000;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_LENGTH = 1001001;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_CHARACTER = 1001002;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_NULL = 1001003;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_NULL = 1001027;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_COUNT_EXCEED = 1001028;
    private static IZegoCustomVideoRenderHandler mCustomVideoRenderHandler;
    private static IZegoDestroyCompletionCallback iZegoDestroyCompletionCallback;
    private static IZegoCustomVideoCaptureHandler mCustomVideoCaptureHandler;
    private static ZegoEngineConfig engineConfig;
    private static boolean isCustomVideoCapturing;

    ZegoExpressEngineJni() {
    }

    static boolean ensureSoLoaded(Context appContext, String customizeSoPath) {
        if (!hasSoLoaded && !TextUtils.isEmpty((CharSequence)customizeSoPath)) {
            try {
                hasSoLoaded = ZegoLibraryLoadUtil.loadSpecialLibrary(customizeSoPath, appContext);
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)"ZEGO", (String)String.format("Load library %s failed", customizeSoPath), (Throwable)e);
                return false;
            }
            catch (Exception e) {
                Log.e((String)"ZEGO", (String)String.format("Load library %s failed", customizeSoPath), (Throwable)e);
                return false;
            }
        }
        if (!hasSoLoaded) {
            try {
                hasSoLoaded = ZegoLibraryLoadUtil.loadSoFile("libZegoExpressSDK.so", appContext);
                return hasSoLoaded;
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)"ZEGO", (String)"Load library libZegoExpressSDK.so failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static void setEngineConfig(ZegoEngineConfig engineConfig) {
        ZegoExpressEngineJni.engineConfig = engineConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZegoExpressEngine createEngine(long appID, String appSign, boolean isTestEnvironment, ZegoScenario scenario, Application application, IZegoEventHandler handler) {
        int engineConfig_zegoCustomVideoCaptureAuxType;
        boolean engineConfig_enableCustomVideoCaptureAux;
        int engineConfig_zegoCustomVideoCaptureMainType;
        boolean engineConfig_enableCustomVideoCaptureMain;
        int engineConfig_zegoCustomVideoRenderType;
        boolean engineConfig_isEngineRender;
        int engineConfig_zegoCustomVideoRenderSeries;
        boolean engineConfig_enableCustomVideoRender;
        if (engine != null) {
            return engine;
        }
        if (application == null) {
            switch (language) {
                case ENGLISH: {
                    throw new RuntimeException("Input application parameter abnormal");
                }
                case CHINESE: {
                    throw new RuntimeException("\u8f93\u5165application\u53c2\u6570\u5f02\u5e38");
                }
            }
        }
        if (engineConfig == null) {
            engineConfig = new ZegoEngineConfig();
        }
        String advanceConfig = "";
        if (ZegoExpressEngineJni.engineConfig.advancedConfig != null) {
            for (String key : ZegoExpressEngineJni.engineConfig.advancedConfig.keySet()) {
                advanceConfig = advanceConfig + key + "=" + ZegoExpressEngineJni.engineConfig.advancedConfig.get(key) + ";";
            }
        }
        if (ZegoExpressEngineJni.engineConfig.customVideoRenderConfig != null) {
            engineConfig_enableCustomVideoRender = true;
            engineConfig_zegoCustomVideoRenderSeries = ZegoExpressEngineJni.engineConfig.customVideoRenderConfig.frameFormatSeries.value();
            engineConfig_isEngineRender = ZegoExpressEngineJni.engineConfig.customVideoRenderConfig.enableEngineRender;
            engineConfig_zegoCustomVideoRenderType = ZegoExpressEngineJni.engineConfig.customVideoRenderConfig.bufferType.value();
        } else {
            engineConfig_enableCustomVideoRender = false;
            engineConfig_isEngineRender = false;
            engineConfig_zegoCustomVideoRenderSeries = -1;
            engineConfig_zegoCustomVideoRenderType = -1;
        }
        if (ZegoExpressEngineJni.engineConfig.customVideoCaptureMainConfig != null) {
            engineConfig_enableCustomVideoCaptureMain = true;
            engineConfig_zegoCustomVideoCaptureMainType = ZegoExpressEngineJni.engineConfig.customVideoCaptureMainConfig.bufferType.value();
        } else {
            engineConfig_enableCustomVideoCaptureMain = false;
            engineConfig_zegoCustomVideoCaptureMainType = -1;
        }
        if (ZegoExpressEngineJni.engineConfig.customVideoCaptureAuxConfig != null) {
            engineConfig_enableCustomVideoCaptureAux = true;
            engineConfig_zegoCustomVideoCaptureAuxType = ZegoExpressEngineJni.engineConfig.customVideoCaptureAuxConfig.bufferType.value();
        } else {
            engineConfig_enableCustomVideoCaptureAux = false;
            engineConfig_zegoCustomVideoCaptureAuxType = -1;
        }
        try {
            if (ZegoExpressEngineJni.engineConfig.logConfig.logPath.equals("")) {
                ZegoExpressEngineJni.engineConfig.logConfig.logPath = ZegoLogUtil.getLogPath((Context)application);
            }
        }
        catch (Exception ex) {
            switch (language) {
                case ENGLISH: {
                    throw new RuntimeException("Input application parameter abnormal");
                }
                case CHINESE: {
                    throw new RuntimeException("\u8f93\u5165application\u53c2\u6570\u5f02\u5e38");
                }
            }
        }
        ZegoExpressEngineJni.setEngineInitConfigToJni(engineConfig, engineConfig_enableCustomVideoRender, engineConfig_zegoCustomVideoRenderSeries, engineConfig_isEngineRender, engineConfig_zegoCustomVideoRenderType, engineConfig_enableCustomVideoCaptureMain, engineConfig_zegoCustomVideoCaptureMainType, engineConfig_enableCustomVideoCaptureAux, engineConfig_zegoCustomVideoCaptureAuxType, ZegoExpressEngineJni.engineConfig.logConfig.logPath, ZegoExpressEngineJni.engineConfig.logConfig.logSize, advanceConfig);
        int errorCode = ZegoExpressEngineJni.engineInitJni(appID, appSign, isTestEnvironment, scenario.value(), (Context)application);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 0, "createEngine", errorCode, new Object[0]);
        if (errorCode != 0) {
            switch (language) {
                default: {
                    throw new RuntimeException("Create engine failed, errorCode = " + errorCode);
                }
                case CHINESE: 
            }
            throw new RuntimeException("\u521b\u5efa\u5f15\u64ce\u5931\u8d25, errorCode = " + errorCode);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            mUIHandler = new Handler(Looper.getMainLooper());
            context = application;
            mIsTestEnv = isTestEnvironment;
            engine = new ZegoExpressEngine();
            if (handler != null) {
                engine.setEventHandler(handler);
            }
            // ** MonitorExit[var17_19] (shouldn't be in output)
            return engine;
        }
    }

    public static ZegoExpressEngine getEngine() {
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyEngine(IZegoDestroyCompletionCallback callback) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            iZegoDestroyCompletionCallback = callback;
            ZegoExpressEngineJni.release();
            int n = ZegoExpressEngineJni.engineUninitAsyncJni();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setEventHandler(IZegoEventHandler handler) {
        int errorCode = 0;
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (engine == null) {
                errorCode = 1000001;
            } else {
                eventHandler = handler;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 0, "setEventHandler", errorCode, new Object[0]);
            ZegoExpressEngineJni.logInfo(ZegoLogUtil.getFileName(), ZegoLogUtil.getMethodName(), ZegoLogUtil.getLineNumber(), ZegoDebugLevel.INFO, ZegoDebugLayer.DEBUG_LAYER_JNI, 1, "setEventHandler", new Object[0]);
            return errorCode;
        }
    }

    private static void release() {
        eventHandler = null;
        if (sPublisherUpdateCDNURLHandler != null) {
            sPublisherUpdateCDNURLHandler.clear();
        }
        if (sPublisherUpdateStreamExtraInfoHandler != null) {
            sPublisherUpdateStreamExtraInfoHandler.clear();
        }
        if (sMixerStartResultHandler != null) {
            sMixerStartResultHandler.clear();
        }
        if (sMixerStopResultHandler != null) {
            sMixerStopResultHandler.clear();
        }
        if (sIMSendBoradcastMssageHandler != null) {
            sIMSendBoradcastMssageHandler.clear();
        }
        if (sIMSendCustomCommandHandler != null) {
            sIMSendCustomCommandHandler.clear();
        }
        if (sIMSendBarragetMssageHandler != null) {
            sIMSendBarragetMssageHandler.clear();
        }
        mCustomVideoRenderHandler = null;
        mCustomVideoCaptureHandler = null;
        ZegoExpressEngine.setEngineConfig(null);
        context = null;
        engine = null;
        mIsTestEnv = true;
        mUIHandler = null;
        language = ZegoLanguage.ENGLISH;
        isNoErrorCallback = false;
        ZegoMediaPlayerJni.destroyAllMediaPlayer();
        ZegoExpressEngineJni.setCustomVideoCaptureHandler(null);
        ZegoExpressEngineJni.setCustomVideoRenderHandler(null);
    }

    public static String getVersion() {
        return ZegoExpressEngineJni.getVersionJni();
    }

    public static void setDebugVerbose(boolean enable, ZegoLanguage language) {
        ZegoExpressEngineJni.language = language;
        ZegoExpressEngineJni.setDebugVerboseJni(enable, language.value());
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 1, "setDebugVerbose", 0, new Object[0]);
    }

    public static void uploadLog() {
        ZegoExpressEngineJni.uploadLogJni();
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 1, "uploadLog", 0, new Object[0]);
    }

    public static int loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config) {
        int maxMemberCount = 0;
        int userStateNotify = 0;
        if (config != null) {
            maxMemberCount = config.maxMemberCount;
            userStateNotify = config.isUserStatusNotify ? 1 : 0;
        }
        String userID = "";
        String userName = "";
        if (user != null) {
            userID = user.userID;
            userName = user.userName;
        }
        if (roomID == null) {
            roomID = "";
        }
        ZegoExpressEngineJni.logInfo(ZegoLogUtil.getFileName(), ZegoLogUtil.getMethodName(), ZegoLogUtil.getLineNumber(), ZegoDebugLevel.INFO, ZegoDebugLayer.DEBUG_LAYER_JNI, 2, "%s, %s, %s, %d, %d", roomID, userID, userName, maxMemberCount, userStateNotify);
        int errorCode = ZegoExpressEngineJni.loginRoomJni(user, roomID, config);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "loginRoom", errorCode, new Object[0]);
        return errorCode;
    }

    public static int loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config, String token) {
        int errorCode = ZegoExpressEngineJni.loginRoomJni(user, roomID, config, token);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "loginRoom", errorCode, new Object[0]);
        return errorCode;
    }

    public static void logoutRoom(String roomID) {
        int errorCode = ZegoExpressEngineJni.logoutRoomJni(roomID);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "logoutRoom", errorCode, new Object[0]);
    }

    public static void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode, ZegoPublishChannel channel) {
        int errorCode = mirrorMode == null ? ZegoExpressEngineJni.ZegoVideoMirrorModeJni(ZegoVideoMirrorMode.ONLY_PREVIEW_MIRROR.value(), channel.value()) : ZegoExpressEngineJni.ZegoVideoMirrorModeJni(mirrorMode.value(), channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setVideoMirrorMode", errorCode, new Object[0]);
    }

    public static void setAppOrientation(ZegoOrientation orientation, ZegoPublishChannel channel) {
        int errorCode = orientation == null ? ZegoExpressEngineJni.setAppOrientationJni(ZegoOrientation.ORIENTATION_0.value(), channel.value()) : ZegoExpressEngineJni.setAppOrientationJni(orientation.value(), channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAppOrientation", errorCode, new Object[0]);
    }

    public static void startPreview(ZegoCanvas canvas, ZegoPublishChannel channel) {
        int errorCode = canvas == null ? ZegoExpressEngineJni.startPreviewJni(null, ZegoViewMode.ASPECT_FILL.value(), 0, channel.value()) : (canvas.viewMode == null ? ZegoExpressEngineJni.startPreviewJni(canvas.view, ZegoViewMode.ASPECT_FILL.value(), canvas.backgroundColor, channel.value()) : ZegoExpressEngineJni.startPreviewJni(canvas.view, canvas.viewMode.value(), canvas.backgroundColor, channel.value()));
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startPreview", errorCode, new Object[0]);
    }

    public static void stopPreview(ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.stopPreviewJni(channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopPreview", errorCode, new Object[0]);
    }

    public static void setVideoConfig(ZegoVideoConfig videoConfig, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.setVideoConfigJni(videoConfig, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setVideoConfig", errorCode, new Object[0]);
    }

    public static int startPublishingStream(String streamID, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.startPublishingStreamJni(streamID, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startPublish", errorCode, new Object[0]);
        return errorCode;
    }

    public static void stopPublishingStream(ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.stopPublishingStreamJni(channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopPublishJni", errorCode, new Object[0]);
    }

    public static void mutePublishStreamAudio(boolean mute, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.mutePublishStreamAudioJni(mute, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "mutePublishStreamAudio", errorCode, new Object[0]);
    }

    public static void mutePublishStreamVideo(boolean mute, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.mutePublishStreamVideoJni(mute, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "mutePublishStreamVideo", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStreamExtraInfo(String extraInfo, ZegoPublishChannel channel, IZegoPublisherSetStreamExtraInfoCallback handler) {
        int seq = ZegoExpressEngineJni.setStreamExtraInfoJni(extraInfo, channel.value());
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateStreamExtraInfoHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static void setCaptureVolume(int volume) {
        int errorCode = ZegoExpressEngineJni.setCaptureVolumeJni(volume);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setCaptureVolume", errorCode, new Object[0]);
    }

    public static void setAudioConfig(ZegoAudioConfig config) {
        int errorCode = 0;
        errorCode = config != null ? ZegoExpressEngineJni.setAudioConfigJni(config.bitrate, config.channel.value(), config.codecID.value()) : ZegoExpressEngineJni.setAudioConfigJni(-1, -1, -1);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAudioConfig", errorCode, new Object[0]);
    }

    public static void enableTrafficControl(boolean enable, int controlTypeBitMask) {
        int errorCode = ZegoExpressEngineJni.enableTrafficControlJni(enable, controlTypeBitMask);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableTrafficControl", errorCode, new Object[0]);
    }

    public static void enablePublishDirectToCDN(boolean enable, ZegoCDNConfig zegoCDNConfig, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.enablePublishDirectToCDNJni(enable, zegoCDNConfig, channel.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPublishCdnUrl(String streamID, String targetURL, IZegoPublisherUpdateCdnUrlCallback handler) {
        int seq = ZegoExpressEngineJni.addPublishCdnUrlJni(streamID, targetURL);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePublishCdnUrl(String streamID, String targetURL, IZegoPublisherUpdateCdnUrlCallback handler) {
        int seq = ZegoExpressEngineJni.removePublishCdnUrlJni(streamID, targetURL);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static void setCapturePipelineScaleMode(ZegoCapturePipelineScaleMode mode) {
        int errorCode = ZegoExpressEngineJni.setCapturePipelineScaleModeJni(mode.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setCapturePipelineScaleMode", errorCode, new Object[0]);
    }

    public static void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.setPublishWatermarkJni(watermark, isPreviewVisible, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setPublishWatermark", errorCode, new Object[0]);
    }

    public static void enableHardwareEncoder(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableHardwareEncoderJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableHardwareEncoder", errorCode, new Object[0]);
    }

    public static void enableDTX(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableDTXJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableDTX", errorCode, new Object[0]);
    }

    public static void enableVAD(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableVADJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableVAD", errorCode, new Object[0]);
    }

    public static int startPlayingStream(String streamID, ZegoCanvas canvas, ZegoPlayerConfig config) {
        int videoLayer = ZegoPlayerVideoLayer.AUTO.value();
        if (config != null && config.videoLayer != null) {
            videoLayer = config.videoLayer.value();
        }
        ZegoCDNConfig zegoCDNConfig = null;
        if (config != null && config.cdnConfig != null) {
            zegoCDNConfig = config.cdnConfig;
        }
        int errorCode = canvas == null ? ZegoExpressEngineJni.startPlayingStreamJni(streamID, null, 0, 0, zegoCDNConfig, videoLayer) : ZegoExpressEngineJni.startPlayingStreamJni(streamID, canvas.view, canvas.viewMode == null ? ZegoViewMode.ASPECT_FIT.value() : canvas.viewMode.value(), canvas.backgroundColor, zegoCDNConfig, videoLayer);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "startPlayingStream", errorCode, new Object[0]);
        return errorCode;
    }

    public static void stopPlayingStream(String streamID) {
        int errorCode = ZegoExpressEngineJni.stopPlayingStreamJni(streamID);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "stopPlayingStream", errorCode, new Object[0]);
    }

    public static void setPlayVolume(String streamID, int volume) {
        int errorCode = ZegoExpressEngineJni.setPlayVolumeJni(streamID, volume);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setPlayVolume", errorCode, new Object[0]);
    }

    public static void mutePlayStreamAudio(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePlayStreamAudioJni(streamID, mute);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "mutePlayStreamAudio", errorCode, new Object[0]);
    }

    public static void mutePlayStreamVideo(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePlayStreamVideoJni(streamID, mute);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "mutePlayStreamVideo", errorCode, new Object[0]);
    }

    public static void setMinVideoBitrateForTrafficControl(int bitrate, ZegoTrafficControlMinVideoBitrateMode mode) {
        int errorCode = ZegoExpressEngineJni.setMinVideoBitrateForTrafficControlJni(bitrate, mode.value());
    }

    public static void enableHardwareDecoder(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableHardwareDecoderJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "enableHardwareDecoder", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startMixerTask(ZegoMixerTask task, IZegoMixerStartCallback handler) {
        int seq = ZegoExpressEngineJni.startMixerJni(task);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sMixerStartResultHandler.put(seq, handler);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 5, "startMixerTask", 0, new Object[0]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopMixerTask(ZegoMixerTask task, IZegoMixerStopCallback handler) {
        int seq = ZegoExpressEngineJni.stopMixerJni(task);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sMixerStopResultHandler.put(seq, handler);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 5, "stopMixerTask", 0, new Object[0]);
            return;
        }
    }

    public static void muteMicrophone(boolean mute) {
        int errorCode = ZegoExpressEngineJni.muteMicrophoneJni(mute);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "muteMicrophone", errorCode, new Object[0]);
    }

    public static void muteAudioOutput(boolean enable) {
        int errorCode = ZegoExpressEngineJni.muteAudioOutputJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "muteAudioOutput", errorCode, new Object[0]);
    }

    public static void muteSpeaker(boolean enable) {
        int errorCode = ZegoExpressEngineJni.muteSpeakerJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "muteSpeaker", errorCode, new Object[0]);
    }

    public static void enableCamera(boolean enable, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.enableCameraJni(enable, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCamera", errorCode, new Object[0]);
    }

    public static void useFrontCamera(boolean enable, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.useFrontCameraJni(enable, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "useFrontCamera", errorCode, new Object[0]);
    }

    public static void startSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJni.startSoundLevelMonitorJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startSoundLevelMonitor", errorCode, new Object[0]);
    }

    public static void stopSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJni.stopSoundLevelMonitorJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopSoundLevelMonitor", errorCode, new Object[0]);
    }

    public static void startAudioSpectrumMonitor() {
        int errorCode = ZegoExpressEngineJni.startFrequencySpectrumMonitorJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startFrequencySpectrumMonitor", errorCode, new Object[0]);
    }

    public static void stopAudioSpectrumMonitor() {
        int errorCode = ZegoExpressEngineJni.stopFrequencySpectrumMonitorJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopFrequencySpectrumMonitor", errorCode, new Object[0]);
    }

    public static void enableAudioCaptureDevice(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableCaptureDeviceJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCaptureDevice", errorCode, new Object[0]);
    }

    public static void enableAEC(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableAECJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableAEC", errorCode, new Object[0]);
    }

    public static void setAECMode(ZegoAECMode mode) {
        int errorCode = ZegoExpressEngineJni.setAECModeJni(mode.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAECMode", errorCode, new Object[0]);
    }

    public static void enableCheckPoc(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableCheckPocJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCheckPoc", errorCode, new Object[0]);
    }

    public static void enableAGC(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableAGCJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableAGC", errorCode, new Object[0]);
    }

    public static void enableANS(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableANSJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableANS", errorCode, new Object[0]);
    }

    public static void enableBeautify(int feature, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.enableBeautifyJni(feature, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableBeautify", errorCode, new Object[0]);
    }

    public static void setBeautifyOption(ZegoBeautifyOption option, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.setBeautifyOptionJni(option, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setBeautifyOption", errorCode, new Object[0]);
    }

    public static void sendSEI(byte[] data, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.sendSEIJni(data, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "sendSEI", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBarrageMessage(String message, String roomID, IZegoIMSendBarrageMessageCallback handler) {
        int seq = ZegoExpressEngineJni.sendBarrageMessageJni(message, roomID);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sIMSendBarragetMssageHandler.put(seq, handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static ZegoMediaPlayer createMediaplayer() {
        return ZegoMediaPlayerJni.createMediaPlayer();
    }

    public static void setCustomVideoRenderHandler(IZegoCustomVideoRenderHandler handler) {
        mCustomVideoRenderHandler = handler;
    }

    public static void setCustomVideoCaptureHandler(final IZegoCustomVideoCaptureHandler handler) {
        if (mUIHandler == null) {
            return;
        }
        mUIHandler.post(new Runnable(){

            @Override
            public void run() {
                mCustomVideoCaptureHandler = handler;
            }
        });
    }

    static void onCustomVideoCaptureWillStart(final int channel) {
        if (mUIHandler == null) {
            return;
        }
        mUIHandler.post(new Runnable(){

            @Override
            public void run() {
                if (mCustomVideoCaptureHandler != null) {
                    mCustomVideoCaptureHandler.onStart(ZegoPublishChannel.values()[channel]);
                    isCustomVideoCapturing = true;
                }
            }
        });
    }

    public static void onCustomVideoCaptureWillStop(final int channel) {
        if (mUIHandler == null) {
            return;
        }
        mUIHandler.post(new Runnable(){

            @Override
            public void run() {
                if (mCustomVideoCaptureHandler != null && isCustomVideoCapturing) {
                    mCustomVideoCaptureHandler.onStop(ZegoPublishChannel.values()[channel]);
                    isCustomVideoCapturing = false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBroadcastMessage(String message, String roomID, IZegoIMSendBroadcastMessageCallback callback) {
        int seq = ZegoExpressEngineJni.sendBroadcastMessageJni(message, roomID);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sIMSendBoradcastMssageHandler.put(seq, callback);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 9, "sendBroadcastMessage", 0, new Object[0]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCustomCommand(String roomID, String command, ArrayList<ZegoUser> toUserList, IZegoIMSendCustomCommandCallback callback) {
        int size = toUserList.size();
        ZegoUser[] userList = toUserList.toArray(new ZegoUser[size]);
        int seq = ZegoExpressEngineJni.sendCustomerMessageJni(command, userList, roomID);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sIMSendCustomCommandHandler.put(seq, callback);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 9, "sendCustomCommand", 0, new Object[0]);
            return;
        }
    }

    public static void sendCustomVideoCaptureRawData(ByteBuffer data, int dataLength, ZegoVideoFrameParam params, long referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.sendCustomVideoCaptureRawDataJni(data, dataLength, params.format.value(), params.strides, params.width, params.height, referenceTimeMillisecond, channel.value(), params.rotation);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "sendCustomVideoCaptureRawData", errorCode, new Object[0]);
    }

    public static void setCustomVideoCaptureFillMode(int value) {
        int errorCode = ZegoExpressEngineJni.setCustomVideoCaptureFillModeJni(value);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "setCustomVideoCaptureFillMode", errorCode, new Object[0]);
    }

    public static void sendCustomVideoCaptureTextureData(int textureID, int width, int height, double referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJni.sendCustomVideoCaptureTextureDataJni(textureID, width, height, referenceTimeMillisecond, channel.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "sendCustomVideoCaptureTextureData", errorCode, new Object[0]);
    }

    public static SurfaceTexture getCustomVideoCaptureSurfaceTexture() {
        SurfaceTexture surfaceTexture = ZegoExpressEngineJni.getCustomVideoCaptureSurfaceTextureJni();
        ZegoExpressEngineJni.printDebugInfo(surfaceTexture == null ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "getCustomVideoCaptureSurfaceTexture", -1, new Object[0]);
        return surfaceTexture;
    }

    public static void setBuiltInSpeakerOn(boolean enable) {
        int errorCode = ZegoExpressEngineJni.setBuiltInSpeakerOnJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 6, "setBuiltInSpeakerOn", errorCode, new Object[0]);
    }

    private static native int setBuiltInSpeakerOnJni(boolean var0);

    private static native int sendBarrageMessageJni(String var0, String var1);

    private static native int sendCustomVideoCaptureTextureDataJni(int var0, int var1, int var2, double var3, int var5);

    private static native int sendCustomVideoCaptureRawDataJni(ByteBuffer var0, int var1, int var2, int[] var3, int var4, int var5, long var6, int var8, int var9);

    private static native int setCustomVideoCaptureFillModeJni(int var0);

    private static native SurfaceTexture getCustomVideoCaptureSurfaceTextureJni();

    private static native int engineInitJni(long var0, String var2, boolean var3, int var4, Context var5);

    private static native void setEngineInitConfigToJni(ZegoEngineConfig var0, boolean var1, int var2, boolean var3, int var4, boolean var5, int var6, boolean var7, int var8, String var9, long var10, String var12);

    private static native int engineUninitAsyncJni();

    private static native String getVersionJni();

    private static native void setDebugVerboseJni(boolean var0, int var1);

    private static native void uploadLogJni();

    private static native int loginRoomJni(ZegoUser var0, String var1, ZegoRoomConfig var2);

    private static native int loginRoomJni(ZegoUser var0, String var1, ZegoRoomConfig var2, String var3);

    public static native int logoutRoomJni(String var0);

    public static native int ZegoVideoMirrorModeJni(int var0, int var1);

    public static native int setCapturePipelineScaleModeJni(int var0);

    public static native int enableCheckPocJni(boolean var0);

    public static native int setAppOrientationJni(int var0, int var1);

    public static native int startPreviewJni(Object var0, int var1, int var2, int var3);

    public static native int stopPreviewJni(int var0);

    public static native int setVideoConfigJni(ZegoVideoConfig var0, int var1);

    public static native int startPublishingStreamJni(String var0, int var1);

    public static native int stopPublishingStreamJni(int var0);

    public static native int mutePublishStreamAudioJni(boolean var0, int var1);

    public static native int mutePublishStreamVideoJni(boolean var0, int var1);

    public static native int setStreamExtraInfoJni(String var0, int var1);

    public static native int setCaptureVolumeJni(int var0);

    public static native int enableTrafficControlJni(boolean var0, int var1);

    public static native int addPublishCdnUrlJni(String var0, String var1);

    public static native int enablePublishDirectToCDNJni(boolean var0, ZegoCDNConfig var1, int var2);

    public static native int removePublishCdnUrlJni(String var0, String var1);

    public static native int setPublishWatermarkJni(ZegoWatermark var0, boolean var1, int var2);

    public static native int enableHardwareEncoderJni(boolean var0);

    public static native int enableDTXJni(boolean var0);

    public static native int enableVADJni(boolean var0);

    static native int sendSEIJni(byte[] var0, int var1);

    public static native int startPlayingStreamJni(String var0, Object var1, int var2, int var3, ZegoCDNConfig var4, int var5);

    public static native int stopPlayingStreamJni(String var0);

    public static native int setPlayVolumeJni(String var0, int var1);

    public static native int mutePlayStreamAudioJni(String var0, boolean var1);

    public static native int mutePlayStreamVideoJni(String var0, boolean var1);

    public static native int enableHardwareDecoderJni(boolean var0);

    public static native int startMixerJni(ZegoMixerTask var0);

    public static native int stopMixerJni(ZegoMixerTask var0);

    public static native int muteMicrophoneJni(boolean var0);

    public static native int muteAudioOutputJni(boolean var0);

    public static native int muteSpeakerJni(boolean var0);

    public static native int enableCameraJni(boolean var0, int var1);

    public static native int useFrontCameraJni(boolean var0, int var1);

    public static native int startSoundLevelMonitorJni();

    public static native int stopSoundLevelMonitorJni();

    public static native int startFrequencySpectrumMonitorJni();

    public static native int stopFrequencySpectrumMonitorJni();

    public static native int enableCaptureDeviceJni(boolean var0);

    public static native int setMinVideoBitrateForTrafficControlJni(int var0, int var1);

    public static native int enableAECJni(boolean var0);

    public static native int setAECModeJni(int var0);

    public static native int enableAGCJni(boolean var0);

    public static native int enableANSJni(boolean var0);

    public static native int enableVirtualStereoJni(boolean var0, int var1);

    public static native int enableReverbJni(boolean var0, int var1);

    public static native int setReverbParamsJni(ZegoReverbParam var0);

    public static native int enableBeautifyJni(int var0, int var1);

    public static native int setBeautifyOptionJni(ZegoBeautifyOption var0, int var1);

    public static native int setWatermarkImagePathJni(String var0);

    public static native int setPreviewWatermarkPositionJni(int var0, int var1, int var2, int var3);

    public static native int setPublishWatermarkPositionJni(int var0, int var1, int var2, int var3);

    public static native int sendBroadcastMessageJni(String var0, String var1);

    public static native int sendCustomerMessageJni(String var0, ZegoUser[] var1, String var2);

    public static void printDebugInfo(ZegoDebugLevel level, int module, String funcName, int errorCode, Object ... args) {
        String msg = ZegoExpressEngineJni.printDebugInfoJni(level.value(), module, funcName, errorCode, args);
        if (!msg.equals("")) {
            ZegoExpressEngineJni.showToastMsg(msg, errorCode);
            if (errorCode != 0 || isNoErrorCallback) {
                if (mUIHandler == null) {
                    return;
                }
                ZegoExpressEngineJni.onDebugError(errorCode, funcName, msg);
            }
        }
    }

    public static void logInfo(String fileName, String funcName, int line, ZegoDebugLevel level, ZegoDebugLayer layer, int module, String format, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            return;
        }
        ZegoExpressEngineJni.logInfoJni(fileName, funcName, line, level.value(), layer.value(), module, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRoomStreamUpdate(final String roomID, final int updateType, ZegoStream[] streamList) {
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<ZegoStream>();
        for (int i = 0; i < streamList.length; ++i) {
            streamArrayList.add(streamList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onRoomStreamUpdate(roomID, ZegoUpdateType.values()[updateType], streamArrayList);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRoomStateUpdate(final String roomID, final int state, final int errorCode, final String extendedData) {
        if (state == ZegoRoomState.DISCONNECTED.value() && errorCode != 0) {
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 2, "onRoomStreamUpdate", errorCode, new Object[0]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onRoomStateUpdate(roomID, ZegoRoomState.values()[state], errorCode, ZegoExpressEngineJni.getJsonObject(extendedData));
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onStreamExtraInfoUpdate(ZegoStream[] streamList, int streamInfoCount, String roomID) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRoomUserUpdate(final String roomID, final int updateType, ZegoUser[] userList) {
        final ArrayList<ZegoUser> userArrayList = new ArrayList<ZegoUser>();
        for (int i = 0; i < userList.length; ++i) {
            userArrayList.add(userList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onRoomUserUpdate(roomID, ZegoUpdateType.values()[updateType], userArrayList);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherStateUpdate(final String streamID, final int state, final int errorCode, final String extendedData) {
        if (state == ZegoPublisherState.NO_PUBLISH.value() && errorCode != 0) {
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 3, "onPublisherStateUpdate", errorCode, new Object[0]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPublisherStateUpdate(streamID, ZegoPublisherState.values()[state], errorCode, ZegoExpressEngineJni.getJsonObject(extendedData));
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static JSONObject getJsonObject(String extendedData) {
        try {
            return new JSONObject(extendedData);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherUpdateCdnUrlResult(String streamID, final int errorCode, final int seq) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoPublisherUpdateCdnUrlCallback handler = (IZegoPublisherUpdateCdnUrlCallback)sPublisherUpdateCDNURLHandler.get(seq);
                        if (handler != null) {
                            handler.onPublisherUpdateCdnUrlResult(errorCode);
                            sPublisherUpdateCDNURLHandler.remove(seq);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerRecvSEI(final String streamID, final byte[] data, int dataLength) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPlayerRecvSEI(streamID, data);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherUpdateStreamExtraInfoResult(final int errorCode, final int seq) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoPublisherSetStreamExtraInfoCallback handler = (IZegoPublisherSetStreamExtraInfoCallback)sPublisherUpdateStreamExtraInfoHandler.get(seq);
                        if (handler != null) {
                            handler.onPublisherSetStreamExtraInfoResult(errorCode);
                            sPublisherUpdateStreamExtraInfoHandler.remove(seq);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherQualityUpdate(final String streamID, final ZegoPublishStreamQuality quality) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPublisherQualityUpdate(streamID, quality);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherMediaEvent(int media_event, int reason, String streamID) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        // empty if block
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherRecvAudioFirstFrame() {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPublisherCapturedAudioFirstFrame();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherRecvVideoFirstFrame(final int zegoPublishChannel) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPublisherCapturedVideoFirstFrame(ZegoPublishChannel.values()[zegoPublishChannel]);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherVideoSizeChanged(final int width, final int height, final int channel) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPublisherVideoSizeChanged(width, height, ZegoPublishChannel.values()[channel]);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherRelayCDNStateUpdate(final String streamID, ZegoStreamRelayCDNInfo[] infoList) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; ++i) {
            infoArrayList.add(infoList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPublisherRelayCDNStateUpdate(streamID, infoArrayList);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerStateUpdate(final String streamID, final int state, final int errorCode, final String extendedData) {
        if (state == ZegoPlayerState.NO_PLAY.value() && errorCode != 0) {
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 4, "onPlayerStateUpdate", errorCode, new Object[0]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPlayerStateUpdate(streamID, ZegoPlayerState.values()[state], errorCode, ZegoExpressEngineJni.getJsonObject(extendedData));
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerQualityUpdate(final String streamID, final ZegoPlayStreamQuality quality) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPlayerQualityUpdate(streamID, quality);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerMediaEvent(final String streamID, final int mediaEvent) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPlayerMediaEvent(streamID, ZegoPlayerMediaEvent.values()[mediaEvent]);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerRecvAudioFirstFrame(final String streamID) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPlayerRecvAudioFirstFrame(streamID);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerRecvVideoFirstFrame(final String streamID) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPlayerRecvVideoFirstFrame(streamID);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerRenderVideoFirstFrame(final String streamID) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPlayerRenderVideoFirstFrame(streamID);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerVideoSizeChanged(final String streamID, final int width, final int height) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onPlayerVideoSizeChanged(streamID, width, height);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRoomStreamExtraInfoUpdate(final String roomID, ZegoStream[] streamList) {
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<ZegoStream>();
        for (int i = 0; i < streamList.length; ++i) {
            streamArrayList.add(streamList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onRoomStreamExtraInfoUpdate(roomID, streamArrayList);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMRecvBroadcastMessage(final String roomID, ZegoBroadcastMessageInfo[] messageList) {
        final ArrayList<ZegoBroadcastMessageInfo> messageArrayList = new ArrayList<ZegoBroadcastMessageInfo>();
        for (int i = 0; i < messageList.length; ++i) {
            messageArrayList.add(messageList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onIMRecvBroadcastMessage(roomID, messageArrayList);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMRecvCustomCommand(final String roomID, final ZegoUser fromUser, final String command) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onIMRecvCustomCommand(roomID, fromUser, command);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMSendBroadcastMessageResult(String roomID, final int errorCode, final int seq, final long messageID) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoIMSendBroadcastMessageCallback callback = (IZegoIMSendBroadcastMessageCallback)sIMSendBoradcastMssageHandler.get(seq);
                        if (callback != null) {
                            callback.onIMSendBroadcastMessageResult(errorCode, messageID);
                        }
                        sIMSendBoradcastMssageHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMRecvBarrageMessage(final String roomID, ZegoBarrageMessageInfo[] messageList) {
        final ArrayList<ZegoBarrageMessageInfo> messageArrayList = new ArrayList<ZegoBarrageMessageInfo>();
        messageArrayList.addAll(Arrays.asList(messageList));
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onIMRecvBarrageMessage(roomID, messageArrayList);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMSendBarrageMessageResult(final int seq, final int errorCode, final String messageID) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoIMSendBarrageMessageCallback callback = (IZegoIMSendBarrageMessageCallback)sIMSendBarragetMssageHandler.get(seq);
                        if (callback != null) {
                            callback.onIMSendBarrageMessageResult(errorCode, messageID);
                        }
                        sIMSendBarragetMssageHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMSendCustomCommandResult(String roomID, final int errorCode, final int seq) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoIMSendCustomCommandCallback callback = (IZegoIMSendCustomCommandCallback)sIMSendCustomCommandHandler.get(seq);
                        if (callback != null) {
                            callback.onIMSendCustomCommandResult(errorCode);
                        }
                        sIMSendCustomCommandHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRemoteCameraStateUpdate(final String streamID, final int state) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onRemoteCameraStateUpdate(streamID, ZegoRemoteDeviceState.values()[state]);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRemoteMICStateUpdate(final String streamID, final int state) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onRemoteMicStateUpdate(streamID, ZegoRemoteDeviceState.values()[state]);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void onEngineStateUpdate(int zegoEngineState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onEngineUninitUpdate() {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (iZegoDestroyCompletionCallback != null) {
                iZegoDestroyCompletionCallback.onDestroyCompletion();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onDeviceError(final int errorCode, final String deviceName) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onDeviceError(errorCode, deviceName);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerSoundLevelUpdate(final HashMap<String, Float> soundLevelHashMap) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onRemoteSoundLevelUpdate(soundLevelHashMap);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onCapturedSoundLevelUpdate(final float soundLevel) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onCapturedSoundLevelUpdate(soundLevel);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onCapturedFrequencySpectrumUpdate(final float[] frequencySpectrum) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onCapturedAudioSpectrumUpdate(frequencySpectrum);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerFrequencySpectrumUpdate(final HashMap<String, float[]> frequencySpectrums) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onRemoteAudioSpectrumUpdate(frequencySpectrums);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMixerStartResult(final int seq, final int errorCode, final String extendedData) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoMixerStartCallback callback = (IZegoMixerStartCallback)sMixerStartResultHandler.get(seq);
                        if (callback != null) {
                            callback.onMixerStartResult(errorCode, ZegoExpressEngineJni.getJsonObject(extendedData));
                        }
                        sMixerStartResultHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMixerStopResult(final int seq, final int errorCode) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoMixerStopCallback callback = (IZegoMixerStopCallback)sMixerStopResultHandler.get(seq);
                        if (callback != null) {
                            callback.onMixerStopResult(errorCode);
                        }
                        sMixerStartResultHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMixerRelayCDNStateUpdate(ZegoStreamRelayCDNInfo[] infoList, final String taskID) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; ++i) {
            infoArrayList.add(infoList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (eventHandler == null) return;
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (eventHandler == null) return;
                        eventHandler.onMixerRelayCDNStateUpdate(taskID, infoArrayList);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public static void onCustomVideoRenderCapturedFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, int videoFlipMode, int channel) {
        if (mCustomVideoRenderHandler != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            for (int i = 0; i < strides.length; ++i) {
                zegoVideoFrameParam.strides[i] = strides[i];
            }
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            mCustomVideoRenderHandler.onCapturedVideoFrameRawData(buffers, dataLen, zegoVideoFrameParam, ZegoVideoFlipMode.values()[videoFlipMode], ZegoPublishChannel.values()[channel]);
        }
    }

    public static void onCustomVideoRenderRemoteFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, String streamID) {
        if (mCustomVideoRenderHandler != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            for (int i = 0; i < strides.length; ++i) {
                zegoVideoFrameParam.strides[i] = strides[i];
            }
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            mCustomVideoRenderHandler.onRemoteVideoFrameRawData(buffers, dataLen, zegoVideoFrameParam, streamID);
        }
    }

    public static void showToastMsg(String msg, int errorCode) {
        if (errorCode == 0 || !mIsTestEnv) {
            return;
        }
        if (context != null) {
            try {
                Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onDebugError(final int errorCode, final String funcName, final String info) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        if (errorCode == 0) {
                            if (!isNoErrorCallback) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                            String msg = "\u8c03\u7528" + funcName + "\u63a5\u53e3\u6210\u529f";
                            ZegoExpressEngineJni.showToastMsg(msg, errorCode);
                        } else {
                            String msg;
                            switch (language) {
                                default: {
                                    msg = " Kind reminder\uff1aFailed to call function: " + funcName + "\n\rError Code:" + errorCode + "\n\rError Info\uff1a" + info + "\n\r\n\rYou can see in the debug console for more details.";
                                    break;
                                }
                                case CHINESE: {
                                    msg = " \u6e29\u99a8\u63d0\u9192\uff1a\u8c03\u7528" + funcName + "\u63a5\u53e3\u5931\u8d25\u3002\n\r\u9519\u8bef\u7801:" + errorCode + "\n\r\u9519\u8bef\u4fe1\u606f\uff1a" + info + "\n\r\n\r\u53ef\u4ee5\u5728\u8c03\u8bd5\u4fe1\u606f\u63a7\u5236\u53f0\u4e2d\u67e5\u770b\u66f4\u591a\u4fe1\u606f\u3002";
                                }
                            }
                            ZegoExpressEngineJni.showToastMsg(msg, errorCode);
                        }
                        if (eventHandler == null) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        eventHandler.onDebugError(errorCode, funcName, info);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void enableNoErrorCallback(boolean enable) {
        isNoErrorCallback = enable;
    }

    public static native String printDebugInfoJni(int var0, int var1, String var2, int var3, Object ... var4);

    public static native void logInfoJni(String var0, String var1, int var2, int var3, int var4, int var5, String var6, Object ... var7);

    public static native int setTestCase(int var0, int var1, String var2, boolean var3);

    public static native int triggerCallback();

    public static native int setAudioConfigJni(int var0, int var1, int var2);

    static {
        engine = null;
        mIsTestEnv = true;
        language = ZegoLanguage.ENGLISH;
        eventHandler = null;
        sPublisherUpdateCDNURLHandler = new HashMap();
        sPublisherUpdateStreamExtraInfoHandler = new HashMap();
        sIMSendBarragetMssageHandler = new HashMap();
        sMixerStartResultHandler = new HashMap();
        sMixerStopResultHandler = new HashMap();
        sIMSendBoradcastMssageHandler = new HashMap();
        sIMSendCustomCommandHandler = new HashMap();
        isNoErrorCallback = false;
        try {
            System.loadLibrary("ZegoExpressEngine");
            hasSoLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            hasSoLoaded = false;
        }
        isCustomVideoCapturing = false;
    }

    public static final class ZegoInnerModule {
        public static final int COMMON = 0;
        public static final int ENGINE = 1;
        public static final int ROOM = 2;
        public static final int PUBLISHER = 3;
        public static final int PLAYER = 4;
        public static final int MIXER = 5;
        public static final int DEVICE = 6;
        public static final int PREPROCESS = 7;
        public static final int MEDIAPLAYER = 8;
        public static final int IM = 9;
        public static final int RECODER = 10;
        public static final int CUSTOM_VIDEO_IO = 11;
    }
}

