/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoliveroom.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class SoLoadUtil {
    private static final int BUFFER_SIZE = 65536;
    private static final String VERSION_FILE_NAME_TEMPLATE = "cur_ver_%d.txt";

    public static boolean loadSpecialLibrary(String customizeSoPath, Context context) throws Exception {
        block4: {
            File soFile = new File(customizeSoPath);
            if (!soFile.exists()) {
                return false;
            }
            try {
                System.load(customizeSoPath);
            }
            catch (UnsatisfiedLinkError e) {
                File soPath = SoLoadUtil.getCustomizeLibDir(context, "ext");
                File targetSo = new File(soPath, soFile.getName());
                if (!targetSo.exists() || targetSo.length() != soFile.length()) {
                    SoLoadUtil.copyFile(soFile, targetSo);
                }
                if (!targetSo.exists()) break block4;
                System.load(targetSo.getAbsolutePath());
            }
        }
        return true;
    }

    public static boolean loadSoFile(String fileName, Context context) {
        File soPath = SoLoadUtil.getCustomizeLibDir(context, "apk");
        int currentVersionCode = SoLoadUtil.getVersionCode(context);
        File versionFile = new File(soPath, SoLoadUtil.versionFileName(currentVersionCode));
        File targetSoFile = new File(soPath, fileName);
        int errorCode = 0;
        if (!versionFile.exists() || !targetSoFile.exists()) {
            errorCode = SoLoadUtil.unzipSo(context, fileName, targetSoFile, versionFile);
        }
        if (errorCode == 0 && versionFile.exists() && targetSoFile.exists()) {
            System.load(targetSoFile.getPath());
            return true;
        }
        Log.e((String)"ZegoSoLoadUtil", (String)("unzip " + fileName + " from apk failed, errorCode: " + errorCode));
        return false;
    }

    private static File getCustomizeLibDir(Context context, String subDirName) {
        File rootDir = context.getDir("libs", 0);
        return new File(rootDir, subDirName);
    }

    private static int getVersionCode(Context context) {
        PackageManager pm = context.getPackageManager();
        String pkgName = context.getPackageName();
        try {
            return pm.getPackageInfo((String)pkgName, (int)16384).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static int unzipSo(Context context, String libName, File targetFile, File versionFile) {
        String[] supportAbis;
        String codePath = context.getPackageCodePath();
        for (String abiType : supportAbis = SoLoadUtil.getSupportABIs()) {
            try {
                boolean success = SoLoadUtil.unzipSpecialABISo(codePath, libName, abiType, targetFile);
                if (!success) continue;
                success = versionFile.createNewFile();
                return success ? 0 : -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -2;
            }
        }
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unzipSpecialABISo(String apkPath, String libName, String ABIType, File targetFile) throws IOException {
        block14: {
            try (ZipInputStream zis = null;){
                boolean bl;
                block15: {
                    ZipEntry entry;
                    boolean found = false;
                    zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(apkPath)));
                    while ((entry = zis.getNextEntry()) != null) {
                        String entryName = entry.getName();
                        if (entryName.contains("../")) {
                            throw new SecurityException("unsecurity zip file!");
                        }
                        if (!entryName.startsWith("lib/") || !entryName.startsWith(ABIType, 4) || !entryName.endsWith(libName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) break block14;
                    byte[] buffer = new byte[65536];
                    File parentDir = targetFile.getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    FilterOutputStream targetStream = null;
                    try {
                        int count;
                        targetStream = new BufferedOutputStream(new FileOutputStream(targetFile), 65536);
                        while ((count = zis.read(buffer, 0, 65536)) != -1) {
                            ((BufferedOutputStream)targetStream).write(buffer, 0, count);
                        }
                        ((BufferedOutputStream)targetStream).flush();
                        bl = true;
                        if (targetStream == null) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (targetStream != null) {
                                targetStream.close();
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                    targetStream.close();
                }
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File srcFile, File targetFile) throws IOException {
        File parentDir = targetFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int readSize;
            bis = new BufferedInputStream(new FileInputStream(srcFile));
            bos = new BufferedOutputStream(new FileOutputStream(targetFile, false));
            byte[] buffer = new byte[65536];
            int loopCount = 0;
            while ((readSize = bis.read(buffer, 0, 65536)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, readSize);
                if (++loopCount % 10 != 0) continue;
                ((BufferedOutputStream)bos).flush();
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return true;
    }

    private static String versionFileName(int versionCode) {
        return String.format(VERSION_FILE_NAME_TEMPLATE, versionCode);
    }

    private static String[] getSupportABIs() {
        String[] supportedAbis = Build.VERSION.SDK_INT >= 21 ? Build.SUPPORTED_ABIS : new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        return supportedAbis;
    }
}

