/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoliveroom.constants;

public final class ZegoAvConfig {
    public static final int[] VIDEO_FPSS = new int[]{5, 10, 15, 20, 25, 30};
    public static final int[] VIDEO_BITRATES = new int[]{300000, 400000, 600000, 1200000, 1500000, 3000000};
    private int mVideoFPS;
    private int mVideoBitrate;
    private int mVideoEncodeResolutionWidth;
    private int mVideoEncodeResolutionHeight;
    private int mVideoCaptureResolutionWidth;
    private int mVideoCaptureResolutionHeight;

    public ZegoAvConfig(int level) {
        if (level < 0 || level > 5) {
            level = 2;
        }
        switch (level) {
            case 0: {
                this.mVideoEncodeResolutionWidth = 180;
                this.mVideoEncodeResolutionHeight = 320;
                this.mVideoCaptureResolutionWidth = 180;
                this.mVideoCaptureResolutionHeight = 320;
                break;
            }
            case 1: {
                this.mVideoEncodeResolutionWidth = 270;
                this.mVideoEncodeResolutionHeight = 480;
                this.mVideoCaptureResolutionWidth = 270;
                this.mVideoCaptureResolutionHeight = 480;
                break;
            }
            case 2: {
                this.mVideoEncodeResolutionWidth = 360;
                this.mVideoEncodeResolutionHeight = 640;
                this.mVideoCaptureResolutionWidth = 360;
                this.mVideoCaptureResolutionHeight = 640;
                break;
            }
            case 3: {
                this.mVideoEncodeResolutionWidth = 540;
                this.mVideoEncodeResolutionHeight = 960;
                this.mVideoCaptureResolutionWidth = 540;
                this.mVideoCaptureResolutionHeight = 960;
                break;
            }
            case 4: {
                this.mVideoEncodeResolutionWidth = 720;
                this.mVideoEncodeResolutionHeight = 1280;
                this.mVideoCaptureResolutionWidth = 720;
                this.mVideoCaptureResolutionHeight = 1280;
                break;
            }
            case 5: {
                this.mVideoEncodeResolutionWidth = 1080;
                this.mVideoEncodeResolutionHeight = 1920;
                this.mVideoCaptureResolutionWidth = 1080;
                this.mVideoCaptureResolutionHeight = 1920;
            }
        }
        this.mVideoFPS = 15;
        this.mVideoBitrate = VIDEO_BITRATES[level];
    }

    public void setVideoFPS(int videoFPS) {
        this.mVideoFPS = videoFPS;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.mVideoBitrate = videoBitrate;
    }

    public int getVideoFPS() {
        return this.mVideoFPS;
    }

    public int getVideoBitrate() {
        return this.mVideoBitrate;
    }

    public void setVideoEncodeResolution(int width, int height) {
        this.mVideoEncodeResolutionWidth = width;
        this.mVideoEncodeResolutionHeight = height;
    }

    public void setVideoCaptureResolution(int width, int height) {
        this.mVideoCaptureResolutionWidth = width;
        this.mVideoCaptureResolutionHeight = height;
    }

    public int getVideoEncodeResolutionWidth() {
        return this.mVideoEncodeResolutionWidth;
    }

    public int getVideoEncodeResolutionHeight() {
        return this.mVideoEncodeResolutionHeight;
    }

    public int getVideoCaptureResolutionWidth() {
        return this.mVideoCaptureResolutionWidth;
    }

    public int getVideoCaptureResolutionHeight() {
        return this.mVideoCaptureResolutionHeight;
    }

    public static final class Level {
        public static final int VeryLow = 0;
        public static final int Low = 1;
        public static final int Generic = 2;
        public static final int High = 3;
        public static final int VeryHigh = 4;
        public static final int SuperHigh = 5;
    }
}

