/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoliveroom;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.zego.zegoavkit2.ZegoStreamExtraPlayInfo;
import com.zego.zegoavkit2.entities.ZegoStreamRelayCDNInfo;
import com.zego.zegoavkit2.utils.ZegoLogUtil;
import com.zego.zegoliveroom.ZegoLiveRoomJNI;
import com.zego.zegoliveroom.callback.IZegoAVEngineCallback;
import com.zego.zegoliveroom.callback.IZegoAudioPostpCallback;
import com.zego.zegoliveroom.callback.IZegoAudioPrepCallback;
import com.zego.zegoliveroom.callback.IZegoAudioPrepCallback2;
import com.zego.zegoliveroom.callback.IZegoAudioRecordCallback;
import com.zego.zegoliveroom.callback.IZegoAudioRecordCallback2;
import com.zego.zegoliveroom.callback.IZegoCustomCommandCallback;
import com.zego.zegoliveroom.callback.IZegoDeviceEventCallback;
import com.zego.zegoliveroom.callback.IZegoEndJoinLiveCallback;
import com.zego.zegoliveroom.callback.IZegoExternalRenderCallback;
import com.zego.zegoliveroom.callback.IZegoInitSDKCompletionCallback;
import com.zego.zegoliveroom.callback.IZegoLiveEventCallback;
import com.zego.zegoliveroom.callback.IZegoLivePlayerCallback;
import com.zego.zegoliveroom.callback.IZegoLivePlayerCallback2;
import com.zego.zegoliveroom.callback.IZegoLivePublisherCallback;
import com.zego.zegoliveroom.callback.IZegoLivePublisherCallback2;
import com.zego.zegoliveroom.callback.IZegoLivePublisherExCallback;
import com.zego.zegoliveroom.callback.IZegoLogInfoCallback;
import com.zego.zegoliveroom.callback.IZegoLoginCompletionCallback;
import com.zego.zegoliveroom.callback.IZegoMediaSideCallback;
import com.zego.zegoliveroom.callback.IZegoResponseCallback;
import com.zego.zegoliveroom.callback.IZegoRoomCallback;
import com.zego.zegoliveroom.callback.IZegoSnapshotCompletionCallback;
import com.zego.zegoliveroom.callback.IZegoSnapshotCompletionCallback2;
import com.zego.zegoliveroom.callback.IZegoUpdatePublishTargetCallback;
import com.zego.zegoliveroom.callback.im.IZegoBigRoomMessageCallback;
import com.zego.zegoliveroom.callback.im.IZegoIMCallback;
import com.zego.zegoliveroom.callback.im.IZegoRoomMessageCallback;
import com.zego.zegoliveroom.callback.reliablemessage.IZegoGetReliableMessageCallback;
import com.zego.zegoliveroom.callback.reliablemessage.IZegoReliableMessageCallback;
import com.zego.zegoliveroom.callback.reliablemessage.IZegoSendReliableMessageCallback;
import com.zego.zegoliveroom.constants.ZegoAvConfig;
import com.zego.zegoliveroom.entity.ZegoAudioFrame;
import com.zego.zegoliveroom.entity.ZegoAudioRecordConfig;
import com.zego.zegoliveroom.entity.ZegoBigRoomMessage;
import com.zego.zegoliveroom.entity.ZegoExtPrepSet;
import com.zego.zegoliveroom.entity.ZegoPlayStreamQuality;
import com.zego.zegoliveroom.entity.ZegoPublishStreamQuality;
import com.zego.zegoliveroom.entity.ZegoReliableMessage;
import com.zego.zegoliveroom.entity.ZegoReliableMessageInfo;
import com.zego.zegoliveroom.entity.ZegoRoomMessage;
import com.zego.zegoliveroom.entity.ZegoStreamInfo;
import com.zego.zegoliveroom.entity.ZegoUser;
import com.zego.zegoliveroom.entity.ZegoUserState;
import com.zego.zegoliveroom.utils.ZegoCommonUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ZegoLiveRoom
implements ZegoLiveRoomJNI.IJniZegoLiveRoomCallback,
ZegoLiveRoomJNI.IJniZegoIMCallback {
    private static final int DEFAULT_LOG_SIZE = 0x500000;
    static SDKContext mContext = null;
    private Handler mUIHandler = new Handler(Looper.getMainLooper());
    private volatile IZegoRoomCallback mZegoRoomCallback = null;
    private volatile IZegoLivePlayerCallback mZegoLivePlayerCallback = null;
    private volatile IZegoInitSDKCompletionCallback mZegoInitSDKCallback = null;
    private volatile IZegoLivePublisherCallback mZegoLivePublisherCallback = null;
    private volatile IZegoLivePublisherCallback2 mZegoLivePublisherCallback2 = null;
    private volatile IZegoLivePublisherExCallback mZegoLivePublisherExCallback = null;
    private volatile IZegoExternalRenderCallback mZegoExternalRenderCallback = null;
    private volatile IZegoAudioRecordCallback mZegoAudioRecordCallback = null;
    private volatile IZegoAudioRecordCallback2 mZegoAudioRecordCallback2 = null;
    @Deprecated
    private volatile IZegoAudioPrepCallback mZegoAudioPrepCallback = null;
    @Deprecated
    private volatile IZegoAudioPrepCallback2 mZegoAudioPrepCallback2 = null;
    private volatile IZegoAudioPrepCallback2 mZegoAudioPrepCB = null;
    private volatile IZegoAudioPostpCallback mZegoAudioPostpCB = null;
    private volatile IZegoDeviceEventCallback mZegoDeviceEventCallback = null;
    private volatile IZegoLiveEventCallback mZegoLiveEventCallback = null;
    private volatile IZegoIMCallback mZegoIMCallback = null;
    private volatile IZegoMediaSideCallback mZegoMediaSideCallback = null;
    private volatile IZegoAVEngineCallback mZegoAVEngineCallback = null;
    private volatile IZegoReliableMessageCallback mZegoReliableMessageCallback = null;
    private volatile IZegoLogInfoCallback mZegoLogInfoCallback = null;
    private volatile int mWaitingJoinLiveResponseSeq = 0;
    private volatile IZegoResponseCallback mJoinLiveResponseCallback = null;
    private Map<Integer, IZegoEndJoinLiveCallback> mMapEndJoinLiveResponseCallback = new HashMap<Integer, IZegoEndJoinLiveCallback>();
    private volatile int mWaitingInviteJoinLiveResponseSeq = 0;
    private volatile IZegoResponseCallback mInviteJoinLiveResponseCallback = null;
    private Map<String, IZegoLoginCompletionCallback> mMapZegoLoginCompletionCallback = new HashMap<String, IZegoLoginCompletionCallback>();
    private Map<String, IZegoSnapshotCompletionCallback> mMapStreamSnapshotCompletionCallback = new HashMap<String, IZegoSnapshotCompletionCallback>();
    private volatile IZegoSnapshotCompletionCallback mPreviewSnapshotCompletionCallback = null;
    private volatile IZegoSnapshotCompletionCallback2 mPreviewSnapshotCompletionCallback2 = null;
    private Map<Object, Object> mMapIMCallback = new HashMap<Object, Object>();
    private Map<Integer, IZegoCustomCommandCallback> mMapCustomCommandCallback = new HashMap<Integer, IZegoCustomCommandCallback>();
    private Map<Integer, IZegoSendReliableMessageCallback> mMapSendReliableMessageCallback = new HashMap<Integer, IZegoSendReliableMessageCallback>();
    private Map<Integer, IZegoGetReliableMessageCallback> mMapGetReliableMessageCallback = new HashMap<Integer, IZegoGetReliableMessageCallback>();
    private Map<Integer, IZegoUpdatePublishTargetCallback> mMapUpdatePublishTargetCallback = new HashMap<Integer, IZegoUpdatePublishTargetCallback>();
    private static String sLogPath = null;

    public static int setSDKContext(SDKContext sdkContext) {
        String customizeSoPath;
        mContext = sdkContext;
        Application appContext = sdkContext.getAppContext();
        int errorCode = ZegoLiveRoomJNI.ensureSoLoaded((Context)appContext, customizeSoPath = sdkContext.getSoFullPath());
        if (errorCode < 0) {
            Log.e((String)"Java_ZegoLiveRoom", (String)("load zegoliveroom native library failed, errorCode: " + errorCode));
        } else {
            String logPath = sdkContext.getLogPath();
            if (logPath == null || logPath.length() == 0) {
                logPath = ZegoLogUtil.getLogPath((Context)appContext);
            }
            long logFileSize = 0x500000L;
            String subLogFolder = null;
            if (sdkContext instanceof SDKContextEx) {
                logFileSize = ((SDKContextEx)sdkContext).getLogFileSize();
                subLogFolder = ((SDKContextEx)sdkContext).getSubLogFolder();
            }
            ZegoLiveRoomJNI.setLogPathAndSize(logPath, logFileSize, subLogFolder, (Context)appContext);
        }
        if (errorCode > 0) {
            ZegoLiveRoomJNI.logPrint("Java_ZegoLiveRoom_setSDKContext\uff0creload zegoliveroom native library success with code: " + errorCode);
        }
        return errorCode;
    }

    public void setZegoLogInfoCallback(IZegoLogInfoCallback callback) {
        this.mZegoLogInfoCallback = callback;
    }

    public void setZegoRoomCallback(IZegoRoomCallback callback) {
        this.mZegoRoomCallback = callback;
    }

    public void setZegoLivePlayerCallback(IZegoLivePlayerCallback callback) {
        this.mZegoLivePlayerCallback = callback;
    }

    public void setZegoLiveEventCallback(IZegoLiveEventCallback callback) {
        this.mZegoLiveEventCallback = callback;
    }

    public void setZegoDeviceEventCallback(IZegoDeviceEventCallback callback) {
        this.mZegoDeviceEventCallback = callback;
    }

    public void setZegoLivePublisherCallback(IZegoLivePublisherCallback callback) {
        this.mZegoLivePublisherCallback = callback;
    }

    public void setZegoLivePublisherExCallback(IZegoLivePublisherExCallback callback) {
        this.mZegoLivePublisherExCallback = callback;
    }

    public void setZegoLivePublisherCallback2(IZegoLivePublisherCallback2 callback2) {
        this.mZegoLivePublisherCallback2 = callback2;
    }

    public void setZegoAudioRecordCallback(IZegoAudioRecordCallback callback) {
        this.mZegoAudioRecordCallback = callback;
    }

    public void setZegoAudioRecordCallback(IZegoAudioRecordCallback2 callback) {
        this.mZegoAudioRecordCallback2 = callback;
    }

    @Deprecated
    public void setZegoAudioPrepCallback(IZegoAudioPrepCallback callback) {
        this.mZegoAudioPrepCallback = callback;
    }

    @Deprecated
    public void setZegoAudioPrepCallback2(IZegoAudioPrepCallback2 callback) {
        this.mZegoAudioPrepCallback2 = callback;
    }

    public void setZegoIMCallback(IZegoIMCallback callback) {
        this.mZegoIMCallback = callback;
    }

    public void setZegoAVEngineCallback(IZegoAVEngineCallback callback) {
        this.mZegoAVEngineCallback = callback;
    }

    @Deprecated
    public void setZegoMediaSideCallback(IZegoMediaSideCallback callback) {
        this.mZegoMediaSideCallback = callback;
        if (callback != null) {
            ZegoLiveRoomJNI.setMediaSideCallback(true);
        } else {
            ZegoLiveRoomJNI.setMediaSideCallback(false);
        }
    }

    public void setLatencyMode(int mode) {
        ZegoLiveRoomJNI.setLatencyMode(mode);
    }

    public void setCapturePipelineScaleMode(int mode) {
        ZegoLiveRoomJNI.setCapturePipelineScaleMode(mode);
    }

    @Deprecated
    public boolean initSDK(long appID, byte[] appSign, Context context) {
        if (context == null && (mContext == null || mContext.getAppContext() == null)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_initSDK] failed, context is null");
            return false;
        }
        if (mContext == null) {
            String logPath = sLogPath;
            if (logPath == null || logPath.length() == 0) {
                logPath = ZegoLogUtil.getLogPath(context);
            }
            ZegoLiveRoomJNI.setLogPathAndSize(logPath, 0x500000L, null, context);
        }
        Context validContext = context != null ? context : mContext.getAppContext();
        return this._initSDKInner(appID, appSign, validContext);
    }

    public boolean initSDK(long appID, byte[] appSign) {
        IZegoInitSDKCompletionCallback callback = null;
        return this.initSDK(appID, appSign, callback);
    }

    public boolean initSDK(long appID, byte[] appSign, IZegoInitSDKCompletionCallback callback) {
        this.mZegoInitSDKCallback = callback;
        if (mContext == null || mContext.getAppContext() == null) {
            throw new RuntimeException("must call setSDKContext(SDKContext) before any other methods");
        }
        return this._initSDKInner(appID, appSign, mContext.getAppContext().getApplicationContext());
    }

    private boolean _initSDKInner(long appID, byte[] appSign, Context context) {
        boolean ret;
        if (appID == 0L || appSign == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_initSDK] failed, appSign is null");
            return false;
        }
        if (ZegoCommonUtils.isDeviceInBlackList()) {
            ZegoLiveRoomJNI.setAudioDeviceMode(2);
            ZegoLiveRoomJNI.enableAEC(true);
            ZegoLiveRoomJNI.enableNoiseSuppress(true);
        }
        if (!(ret = ZegoLiveRoomJNI.initSDK((int)appID, appSign, context))) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_initSDK], init failed");
            return false;
        }
        ZegoLiveRoomJNI.setZegoLiveRoomCallback(this);
        ZegoLiveRoomJNI.setZegoIMCallback(this);
        return true;
    }

    public boolean unInitSDK() {
        try {
            sLogPath = null;
            this.mZegoRoomCallback = null;
            this.mZegoLivePlayerCallback = null;
            this.mZegoLivePublisherCallback = null;
            this.mZegoLivePublisherExCallback = null;
            this.mZegoLivePublisherCallback2 = null;
            this.mZegoDeviceEventCallback = null;
            this.mZegoLiveEventCallback = null;
            this.mZegoExternalRenderCallback = null;
            this.mZegoAudioRecordCallback = null;
            this.mZegoAudioPrepCallback = null;
            this.mZegoAudioPrepCallback2 = null;
            this.mZegoIMCallback = null;
            this.mZegoMediaSideCallback = null;
            this.mZegoAVEngineCallback = null;
            this.mZegoInitSDKCallback = null;
            this.mZegoReliableMessageCallback = null;
            this.mZegoLogInfoCallback = null;
            this.removeAllRoomCallback();
            ZegoLiveRoomJNI.setZegoLiveRoomCallback(null);
            ZegoLiveRoomJNI.setZegoIMCallback(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ZegoLiveRoomJNI.unInitSDK();
    }

    public void setRoomConfig(boolean audienceCreateRoom, boolean userStateUpdate) {
        ZegoLiveRoomJNI.setRoomConfig(audienceCreateRoom, userStateUpdate);
    }

    public void setCustomToken(String thirdPartyToken) {
        ZegoLiveRoomJNI.setCustomToken(thirdPartyToken);
    }

    public void setRoomMaxUserCount(int maxCount) {
        ZegoLiveRoomJNI.setRoomMaxUserCount(maxCount);
    }

    public boolean setVideoCaptureDeviceId(String id, int channelIndex) {
        return ZegoLiveRoomJNI.setVideoCaptureDeviceId(id, channelIndex);
    }

    public boolean loginRoom(String roomID, int role, IZegoLoginCompletionCallback callback) {
        return this.loginRoom(roomID, "", role, callback);
    }

    public boolean loginRoom(String roomID, String roomName, int role, IZegoLoginCompletionCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_loginRoom] failed, roomID is empty");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)roomName)) {
            roomName = "";
        }
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_loginRoom] failed, callback is null");
            return false;
        }
        boolean ret = ZegoLiveRoomJNI.loginRoom(roomID, roomName, role);
        if (ret) {
            if (this.mMapZegoLoginCompletionCallback.get(roomID) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_loginRoom], unfinished room login: " + roomID);
            }
            this.mMapZegoLoginCompletionCallback.put(roomID, callback);
        }
        return ret;
    }

    private void removeAllRoomCallback() {
        this.mMapEndJoinLiveResponseCallback.clear();
        this.mMapZegoLoginCompletionCallback.clear();
        this.mWaitingInviteJoinLiveResponseSeq = 0;
        this.mWaitingJoinLiveResponseSeq = 0;
        this.mInviteJoinLiveResponseCallback = null;
        this.mJoinLiveResponseCallback = null;
        this.mMapStreamSnapshotCompletionCallback.clear();
        this.mPreviewSnapshotCompletionCallback = null;
        this.mPreviewSnapshotCompletionCallback2 = null;
        this.mMapIMCallback.clear();
        this.mMapCustomCommandCallback.clear();
        this.mMapSendReliableMessageCallback.clear();
        this.mMapGetReliableMessageCallback.clear();
        this.mMapUpdatePublishTargetCallback.clear();
    }

    public boolean logoutRoom() {
        this.removeAllRoomCallback();
        return ZegoLiveRoomJNI.logoutRoom();
    }

    public void updatePlayDecryptKey(String streamId, byte[] key) {
        ZegoLiveRoomJNI.updatePlayDecryptKey(streamId, key);
    }

    public boolean startPlayingStream(String streamID, Object view) {
        return this.startPlayingStreamInner(streamID, view, null);
    }

    public boolean startPlayingStream(String streamID, Object view, String params) {
        ZegoStreamExtraPlayInfo info = new ZegoStreamExtraPlayInfo();
        info.params = params;
        return this.startPlayingStreamInner(streamID, view, info);
    }

    public boolean startPlayingStream(String streamID, Object view, ZegoStreamExtraPlayInfo info) {
        return this.startPlayingStreamInner(streamID, view, info);
    }

    private boolean startPlayingStreamInner(String streamID, Object view, ZegoStreamExtraPlayInfo info) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_startPlayingStreamInner] failed, streamID is empty");
            return false;
        }
        if (info != null && TextUtils.isEmpty((CharSequence)info.params)) {
            info.params = "";
        }
        return ZegoLiveRoomJNI.startPlayingStream(streamID, view, info);
    }

    public boolean updatePlayView(String streamID, Object view) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_updatePlayView] failed, streamID is empty");
            return false;
        }
        return ZegoLiveRoomJNI.updatePlayView(streamID, view);
    }

    public boolean stopPlayingStream(String streamID) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_stopPlayingStream] failed, streamID is empty");
            return false;
        }
        return ZegoLiveRoomJNI.stopPlayingStream(streamID);
    }

    public boolean setPlayStreamFocus(String streamID) {
        return ZegoLiveRoomJNI.setPlayStreamFocus(streamID);
    }

    public boolean requestJoinLive(IZegoResponseCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_requestJoinLive] failed, callback is null");
            return false;
        }
        int seq = ZegoLiveRoomJNI.requestJoinLive();
        if (seq > 0) {
            this.mWaitingJoinLiveResponseSeq = seq;
            this.mJoinLiveResponseCallback = callback;
            return true;
        }
        return false;
    }

    public boolean respondInviteJoinLiveReq(int seq, int rspResult) {
        return ZegoLiveRoomJNI.respondInviteJoinLiveReq(seq, rspResult);
    }

    public boolean endJoinLive(String userId, IZegoEndJoinLiveCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_endJoinLive] failed, callback is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)userId)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_endJoinLive] failed, userId is empty");
            return false;
        }
        int seq = ZegoLiveRoomJNI.endJoinLive(userId);
        if (seq > 0) {
            if (this.mMapEndJoinLiveResponseCallback.get(seq) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_endJoinLive], unfinished send end join live, seq:" + seq);
            }
            this.mMapEndJoinLiveResponseCallback.put(seq, callback);
            return true;
        }
        ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_endJoinLive] failed, seq:" + seq);
        return false;
    }

    public int getAudioRouteType() {
        return ZegoLiveRoomJNI.getAudioRouteType();
    }

    public boolean enableSpeaker(boolean enable) {
        return ZegoLiveRoomJNI.enableSpeaker(enable);
    }

    public boolean setBuiltInSpeakerOn(boolean on) {
        return ZegoLiveRoomJNI.setBuiltInSpeakerOn(on);
    }

    public boolean setPlayVolume(int volume) {
        return ZegoLiveRoomJNI.setPlayVolume(volume);
    }

    public boolean setPlayVolume(int volume, String streamID) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            streamID = "";
        }
        return ZegoLiveRoomJNI.setPlayVolume2(volume, streamID);
    }

    public float getSoundLevelOfStream(String streamID) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_getSoundLevelOfStream] failed, streamID is empty");
            return 0.0f;
        }
        return ZegoLiveRoomJNI.getSoundLevelOfStream(streamID);
    }

    public boolean setViewMode(int mode, String streamID) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setViewMode] failed, streamID is empty");
            return false;
        }
        return ZegoLiveRoomJNI.setViewMode(mode, streamID);
    }

    public boolean setViewBackgroundColor(int color, String streamID) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setViewBackgroundColor] failed, streamID is empty");
            return false;
        }
        return ZegoLiveRoomJNI.setViewBackgroundColor(color, streamID);
    }

    public boolean setViewRotation(int rotation, String streamID) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setViewRotation] failed, streamID is empty");
            return false;
        }
        return ZegoLiveRoomJNI.setViewRotation(rotation, streamID);
    }

    public boolean takeSnapshotOfStream(String streamID, IZegoSnapshotCompletionCallback callback) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_takeSnapshotOfStream] failed, streamID is empty");
            return false;
        }
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_takeSnapshotOfStream] failed, callback is null");
            return false;
        }
        boolean ret = ZegoLiveRoomJNI.takeSnapshot(streamID);
        if (ret) {
            if (this.mMapStreamSnapshotCompletionCallback.get(streamID) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_takeSnapshotOfStream] unfinished snapshot, streamID:" + streamID);
            }
            this.mMapStreamSnapshotCompletionCallback.put(streamID, callback);
        }
        return ret;
    }

    @Deprecated
    public boolean enableSelectedAudioRecord(int mask, int sampleRate) {
        return ZegoLiveRoomJNI.enableSelectedAudioRecord(mask, sampleRate, 1);
    }

    public boolean enableSelectedAudioRecord(ZegoAudioRecordConfig config) {
        if (config == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_enableSelectedAudioRecord] failed, config is NULL");
            return false;
        }
        return ZegoLiveRoomJNI.enableSelectedAudioRecord(config.mask, config.sampleRate, config.channels);
    }

    public boolean setPreviewView(Object view) {
        return ZegoLiveRoomJNI.setPreviewView(view, 0);
    }

    public boolean setPreviewView(Object view, int channelIndex) {
        return ZegoLiveRoomJNI.setPreviewView(view, channelIndex);
    }

    public boolean startPreview() {
        return ZegoLiveRoomJNI.startPreview(0);
    }

    public boolean startPreview(int channelIndex) {
        return ZegoLiveRoomJNI.startPreview(channelIndex);
    }

    public boolean setVideoCodecId(int codecId, int channelIndex) {
        return ZegoLiveRoomJNI.setVideoCodecId(codecId, channelIndex);
    }

    public boolean stopPreview() {
        return ZegoLiveRoomJNI.stopPreview(0);
    }

    public boolean stopPreview(int channelIndex) {
        return ZegoLiveRoomJNI.stopPreview(channelIndex);
    }

    public void setPublishEncryptKey(byte[] key, int channelIndex) {
        ZegoLiveRoomJNI.setPublishEncryptKey(key, channelIndex);
    }

    public boolean startPublishing(String streamID, String title, int flag) {
        return this.startPublishInner(streamID, title, flag);
    }

    public boolean startPublishing(String streamID, String title, int flag, String extraInfo) {
        if (!TextUtils.isEmpty((CharSequence)extraInfo) && !ZegoLiveRoomJNI.updateStreamExtraInfo(extraInfo, 0)) {
            return false;
        }
        return this.startPublishInner(streamID, title, flag);
    }

    public boolean startPublishing2(String streamID, String title, int flag, int channelIndex) {
        return this.startPublishInner2(streamID, title, flag, channelIndex, null, null);
    }

    public boolean startPublishing2(String streamID, String title, int flag, String extraInfo, int channelIndex) {
        return this.startPublishInner2(streamID, title, flag, channelIndex, extraInfo, null);
    }

    public boolean startPublishing2(String streamID, String title, int flag, String extraInfo, String params, int channelIndex) {
        return this.startPublishInner2(streamID, title, flag, channelIndex, extraInfo, params);
    }

    public boolean updateStreamExtraInfo(String extraInfo) {
        return this.updateStreamExtraInfoInner(extraInfo, 0);
    }

    public boolean updateStreamExtraInfo(String extraInfo, int channelIndex) {
        return this.updateStreamExtraInfoInner(extraInfo, channelIndex);
    }

    private boolean updateStreamExtraInfoInner(String extraInfo, int channelIndex) {
        if (TextUtils.isEmpty((CharSequence)extraInfo)) {
            extraInfo = "";
        }
        return ZegoLiveRoomJNI.updateStreamExtraInfo(extraInfo, channelIndex);
    }

    private boolean startPublishInner(String streamID, String title, int flag) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            streamID = "";
        }
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = "";
        }
        return ZegoLiveRoomJNI.startPublishing(streamID, title, flag);
    }

    private boolean startPublishInner2(String streamID, String title, int flag, int channelIndex, String extraInfo, String params) {
        if (TextUtils.isEmpty((CharSequence)streamID)) {
            streamID = "";
        }
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = "";
        }
        if (TextUtils.isEmpty((CharSequence)params)) {
            params = "";
        }
        if (!TextUtils.isEmpty((CharSequence)extraInfo) && !ZegoLiveRoomJNI.updateStreamExtraInfo(extraInfo, channelIndex)) {
            return false;
        }
        return ZegoLiveRoomJNI.startPublishing2(streamID, title, flag, channelIndex, params);
    }

    public boolean stopPublishing() {
        return ZegoLiveRoomJNI.stopPublishing(0);
    }

    public boolean stopPublishing(int channelIndex) {
        return ZegoLiveRoomJNI.stopPublishing(channelIndex);
    }

    public boolean respondJoinLiveReq(int seq, int rspResult) {
        return ZegoLiveRoomJNI.respondJoinLiveReq(seq, rspResult);
    }

    public boolean inviteJoinLive(String userID, IZegoResponseCallback callback) {
        if (TextUtils.isEmpty((CharSequence)userID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_inviteJoinLive] failed, userID is empty");
            return false;
        }
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_inviteJoinLive] failed, callback is null");
            return false;
        }
        int seq = ZegoLiveRoomJNI.inviteJoinLive(userID);
        if (seq > 0) {
            this.mWaitingInviteJoinLiveResponseSeq = seq;
            this.mInviteJoinLiveResponseCallback = callback;
            return true;
        }
        return false;
    }

    public boolean setAVConfig(ZegoAvConfig zegoAvConfig) {
        return this.setAVConfigInner(zegoAvConfig, 0);
    }

    public boolean setAVConfig(ZegoAvConfig zegoAvConfig, int channelIndex) {
        return this.setAVConfigInner(zegoAvConfig, channelIndex);
    }

    public boolean setAVConfigInner(ZegoAvConfig zegoAvConfig, int channelIndex) {
        if (zegoAvConfig == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setAVConfigInner] failed, config is null");
            return false;
        }
        boolean ret = true;
        ret &= ZegoLiveRoomJNI.setVideoFPS(zegoAvConfig.getVideoFPS(), channelIndex);
        ret &= ZegoLiveRoomJNI.setVideoBitrate(zegoAvConfig.getVideoBitrate(), channelIndex);
        ret &= ZegoLiveRoomJNI.setVideoEncodeResolution(zegoAvConfig.getVideoEncodeResolutionWidth(), zegoAvConfig.getVideoEncodeResolutionHeight(), channelIndex);
        return ret &= ZegoLiveRoomJNI.setVideoCaptureResolution(zegoAvConfig.getVideoCaptureResolutionWidth(), zegoAvConfig.getVideoCaptureResolutionHeight(), channelIndex);
    }

    public boolean setVideoKeyFrameInterval(int intervalSecond) {
        return this.setVideoKeyFrameInterval(intervalSecond, 0);
    }

    public boolean setVideoKeyFrameInterval(int intervalSecond, int channelIndex) {
        return ZegoLiveRoomJNI.setVideoKeyFrameInterval(intervalSecond, channelIndex);
    }

    public boolean setAppOrientation(int orientation) {
        return this.setAppOrientationInner(orientation, 0);
    }

    public boolean setAppOrientation(int orientation, int channelIndex) {
        return this.setAppOrientationInner(orientation, channelIndex);
    }

    private boolean setAppOrientationInner(int orientation, int channelIndex) {
        if (orientation < 0 || orientation > 3) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setAppOrientationInner] failed, orientation is illegal");
            return false;
        }
        return ZegoLiveRoomJNI.setAppOrientation(orientation, channelIndex);
    }

    public void setLoopbackVolume(int volume) {
        ZegoLiveRoomJNI.setLoopbackVolume(volume);
    }

    public void setCaptureVolume(int volume) {
        ZegoLiveRoomJNI.setCaptureVolume(volume);
    }

    public boolean enableBeautifying(int feature) {
        return ZegoLiveRoomJNI.enableBeautifying(feature, 0);
    }

    public boolean enableBeautifying(int feature, int channelIndex) {
        return ZegoLiveRoomJNI.enableBeautifying(feature, channelIndex);
    }

    public boolean setPolishStep(float step) {
        return ZegoLiveRoomJNI.setPolishStep(step, 0);
    }

    public boolean setPolishStep(float step, int channelIndex) {
        return ZegoLiveRoomJNI.setPolishStep(step, channelIndex);
    }

    public boolean setPolishFactor(float factor) {
        return ZegoLiveRoomJNI.setPolishFactor(factor, 0);
    }

    public boolean setPolishFactor(float factor, int channelIndex) {
        return ZegoLiveRoomJNI.setPolishFactor(factor, channelIndex);
    }

    public boolean setWhitenFactor(float factor) {
        return ZegoLiveRoomJNI.setWhitenFactor(factor, 0);
    }

    public boolean setWhitenFactor(float factor, int channelIndex) {
        return ZegoLiveRoomJNI.setWhitenFactor(factor, channelIndex);
    }

    public boolean setSharpenFactor(float factor) {
        return ZegoLiveRoomJNI.setSharpenFactor(factor, 0);
    }

    public boolean setSharpenFactor(float factor, int channelIndex) {
        return ZegoLiveRoomJNI.setSharpenFactor(factor, channelIndex);
    }

    public boolean setFilter(int filter) {
        return ZegoLiveRoomJNI.setFilter(filter, 0);
    }

    public boolean setFilter(int filter, int channelIndex) {
        return ZegoLiveRoomJNI.setFilter(filter, channelIndex);
    }

    public boolean setPreviewViewMode(int mode) {
        return ZegoLiveRoomJNI.setPreviewViewMode(mode, 0);
    }

    public boolean setPreviewViewMode(int mode, int channelIndex) {
        return ZegoLiveRoomJNI.setPreviewViewMode(mode, channelIndex);
    }

    public boolean setPreviewViewBackgroundColor(int color) {
        return ZegoLiveRoomJNI.setPreviewViewBackgroundColor(color, 0);
    }

    public boolean setPreviewViewBackgroundColor(int color, int channelIndex) {
        return ZegoLiveRoomJNI.setPreviewViewBackgroundColor(color, channelIndex);
    }

    public boolean setPreviewRotation(int rotation) {
        return ZegoLiveRoomJNI.setPreviewRotation(rotation, 0);
    }

    public boolean setPreviewRotation(int rotation, int channelIndex) {
        return ZegoLiveRoomJNI.setPreviewRotation(rotation, channelIndex);
    }

    public boolean enablePreviewMirror(boolean enable) {
        return ZegoLiveRoomJNI.enablePreviewMirror(enable, 0);
    }

    public boolean enablePreviewMirror(boolean enable, int channelIndex) {
        return ZegoLiveRoomJNI.enablePreviewMirror(enable, channelIndex);
    }

    public boolean enableCaptureMirror(boolean enable) {
        return ZegoLiveRoomJNI.enableCaptureMirror(enable, 0);
    }

    public boolean enableCaptureMirror(boolean enable, int channelIndex) {
        return ZegoLiveRoomJNI.enableCaptureMirror(enable, channelIndex);
    }

    public boolean setVideoMirrorMode(int mode, int channelIndex) {
        return ZegoLiveRoomJNI.setVideoMirrorMode(mode, channelIndex);
    }

    public boolean enableRateControl(boolean enable) {
        return ZegoLiveRoomJNI.enableRateControl(enable, 0);
    }

    public boolean enableRateControl(boolean enable, int channelIndex) {
        return ZegoLiveRoomJNI.enableRateControl(enable, channelIndex);
    }

    public void setVideoEncoderRateControlConfig(int strategy, int encoderCRF) {
        ZegoLiveRoomJNI.setVideoEncoderRateControlConfig(strategy, encoderCRF, 0);
    }

    public void setVideoEncoderRateControlConfig(int strategy, int encoderCRF, int channelIndex) {
        ZegoLiveRoomJNI.setVideoEncoderRateControlConfig(strategy, encoderCRF, channelIndex);
    }

    public boolean setFrontCam(boolean front) {
        return ZegoLiveRoomJNI.setFrontCam(front, 0);
    }

    public boolean setFrontCam(boolean front, int channelIndex) {
        return ZegoLiveRoomJNI.setFrontCam(front, channelIndex);
    }

    public boolean enableMic(boolean enable) {
        return ZegoLiveRoomJNI.enableMic(enable);
    }

    public boolean enableMicDevice(boolean enable) {
        return ZegoLiveRoomJNI.enableMicDevice(enable);
    }

    public boolean enableCamera(boolean enable) {
        return ZegoLiveRoomJNI.enableCamera(enable, 0);
    }

    public boolean enableCamera(boolean enable, int channelIndex) {
        return ZegoLiveRoomJNI.enableCamera(enable, channelIndex);
    }

    public boolean enableTorch(boolean enable) {
        return ZegoLiveRoomJNI.enableTorch(enable, 0);
    }

    public boolean enableTorch(boolean enable, int channelIndex) {
        return ZegoLiveRoomJNI.enableTorch(enable, channelIndex);
    }

    public boolean takePreviewSnapshot(IZegoSnapshotCompletionCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_takePreviewSnapshot] failed, callback is null");
            return false;
        }
        this.mPreviewSnapshotCompletionCallback = callback;
        return ZegoLiveRoomJNI.takePreviewSnapshot(0);
    }

    public boolean takePreviewSnapshot(IZegoSnapshotCompletionCallback2 callback, int channelIndex) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_takePreviewSnapshot_channel] failed, callback is null");
            return false;
        }
        this.mPreviewSnapshotCompletionCallback2 = callback;
        return ZegoLiveRoomJNI.takePreviewSnapshot(channelIndex);
    }

    @Deprecated
    public boolean muteAux(boolean mute) {
        return ZegoLiveRoomJNI.muteAux(mute);
    }

    public float getCaptureSoundLevel() {
        return ZegoLiveRoomJNI.getCaptureSoundLevel();
    }

    public boolean sendRoomMessage(int messageType, int messageCategory, String content, IZegoRoomMessageCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendRoomMessage] failed, callback is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)content)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendRoomMessage] failed, content is empty");
            return false;
        }
        int seq = ZegoLiveRoomJNI.sendRoomMessageEx(messageType, messageCategory, content);
        if (seq != -1) {
            if (this.mMapIMCallback.get(seq) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendRoomMessage], unfinished send room message, seq:" + seq);
            }
            this.mMapIMCallback.put(seq, callback);
            return true;
        }
        ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendRoomMessage] failed, seq:" + seq);
        return false;
    }

    public boolean sendBigRoomMessage(int messageType, int messageCategory, String content, IZegoBigRoomMessageCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendBigRoomMessage] callback is null");
        }
        if (TextUtils.isEmpty((CharSequence)content)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendBigRoomMessage] failed, content is empty");
            return false;
        }
        int seq = ZegoLiveRoomJNI.sendBigRoomMessage(messageType, messageCategory, content);
        if (seq != -1) {
            if (this.mMapIMCallback.get(seq) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendBigRoomMessage], unfinished send room message, seq:" + seq);
            }
            if (callback != null) {
                this.mMapIMCallback.put(seq, callback);
            }
            return true;
        }
        ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendBigRoomMessage] failed, seq:" + seq);
        return false;
    }

    public boolean sendReliableMessage(String content, String type, long latestSeq, IZegoSendReliableMessageCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendReliableMessage] callback is null");
        }
        if (TextUtils.isEmpty((CharSequence)type)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendReliableMessage] failed, type is empty");
            return false;
        }
        int sendSeq = ZegoLiveRoomJNI.sendReliableMessage(content == null ? "" : content, type, latestSeq);
        if (sendSeq != -1) {
            if (this.mMapSendReliableMessageCallback.get(sendSeq) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendReliableMessage], unfinished send reliable message, seq:" + sendSeq);
            }
            if (callback != null) {
                this.mMapSendReliableMessageCallback.put(sendSeq, callback);
            }
            return true;
        }
        ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendReliableMessage] failed, seq:" + sendSeq);
        return false;
    }

    public boolean getReliableMessage(String[] messageTypes, IZegoGetReliableMessageCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_getReliableMessage] callback is null");
            return false;
        }
        int sendSeq = ZegoLiveRoomJNI.getReliableMessage(messageTypes);
        if (sendSeq != -1) {
            this.mMapGetReliableMessageCallback.put(sendSeq, callback);
            return true;
        }
        ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendReliableMessage] failed, seq:" + sendSeq);
        return false;
    }

    public void setReliableMessageCallback(IZegoReliableMessageCallback callback) {
        this.mZegoReliableMessageCallback = callback;
    }

    private ZegoUser[] getListOfLegalUser(ZegoUser[] listMember) {
        if (listMember == null || listMember.length == 0) {
            return null;
        }
        ArrayList<ZegoUser> listTemp = new ArrayList<ZegoUser>();
        for (ZegoUser zegoUser : listMember) {
            if (zegoUser == null || TextUtils.isEmpty((CharSequence)zegoUser.userID) || TextUtils.isEmpty((CharSequence)zegoUser.userName)) continue;
            listTemp.add(zegoUser);
        }
        int numberOfLegalUser = listTemp.size();
        if (numberOfLegalUser == 0) {
            return null;
        }
        ZegoUser[] listOfLegalUser = new ZegoUser[numberOfLegalUser];
        for (int i = 0; i < numberOfLegalUser; ++i) {
            listOfLegalUser[i] = (ZegoUser)listTemp.get(i);
        }
        return listOfLegalUser;
    }

    public static boolean setWaterMarkImagePath(String imagePath) {
        return ZegoLiveRoom.setWaterMarkImagePathInner(imagePath, 0);
    }

    public static boolean setWaterMarkImagePath(String imagePath, int channelIndex) {
        return ZegoLiveRoom.setWaterMarkImagePathInner(imagePath, channelIndex);
    }

    private static boolean setWaterMarkImagePathInner(String imagePath, int channelIndex) {
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setWaterMarkImagePathInner] failed, imagePath is empty");
            return false;
        }
        ZegoLiveRoomJNI.setWaterMarkImagePath(imagePath, channelIndex);
        return true;
    }

    public static boolean setPreviewWaterMarkRect(Rect rect) {
        return ZegoLiveRoom.setPreviewWaterMarkRectInner(rect, 0);
    }

    public static boolean setPreviewWaterMarkRect(Rect rect, int channelIndex) {
        return ZegoLiveRoom.setPreviewWaterMarkRectInner(rect, channelIndex);
    }

    private static boolean setPreviewWaterMarkRectInner(Rect rect, int channelIndex) {
        if (rect == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setPreviewWaterMarkRectInner] failed, rect is null");
            return false;
        }
        ZegoLiveRoomJNI.setPreviewWaterMarkRect(rect.left, rect.top, rect.right, rect.bottom, channelIndex);
        return true;
    }

    public static boolean setPublishWaterMarkRect(Rect rect) {
        return ZegoLiveRoom.setPublishWaterMarkRectInner(rect, 0);
    }

    public static boolean setPublishWaterMarkRect(Rect rect, int channelIndex) {
        return ZegoLiveRoom.setPublishWaterMarkRectInner(rect, channelIndex);
    }

    private static boolean setPublishWaterMarkRectInner(Rect rect, int channelIndex) {
        if (rect == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setPublishWaterMarkRectInner] failed, rect is null");
            return false;
        }
        ZegoLiveRoomJNI.setPublishWaterMarkRect(rect.left, rect.top, rect.right, rect.bottom, channelIndex);
        return true;
    }

    @Deprecated
    public static void setLogPath(String logPath) {
        sLogPath = logPath;
    }

    public static boolean setUser(String userID, String userName) {
        if (TextUtils.isEmpty((CharSequence)userID)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setUser] failed, userID is empty");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)userName)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setUser] failed, userName is empty");
            return false;
        }
        return ZegoLiveRoomJNI.setUser(userID, userName);
    }

    public static void setTestEnv(boolean useTestEnv) {
        ZegoLiveRoomJNI.setTestEnv(useTestEnv);
    }

    private static void setAlphaEnv(boolean useAlphaEnv) {
        ZegoLiveRoomJNI.setAlphaEnv(useAlphaEnv);
    }

    public static String version() {
        return ZegoLiveRoomJNI.version();
    }

    public static String version2() {
        return ZegoLiveRoomJNI.version2();
    }

    public static void setVerbose(boolean onVerbose) {
        ZegoLiveRoomJNI.setVerbose(onVerbose);
    }

    public static void uploadLog() {
        ZegoLiveRoomJNI.uploadLog();
    }

    public static void setBusinessType(int type) {
        ZegoLiveRoomJNI.setBusinessType(type);
    }

    public static int getMaxPlayChannelCount() {
        return ZegoLiveRoomJNI.getMaxPlayChannelCount();
    }

    public static int getMaxPublishChannelCount() {
        return ZegoLiveRoomJNI.getMaxPublishChannelCount();
    }

    public static boolean requireHardwareEncoder(boolean require) {
        return ZegoLiveRoomJNI.requireHardwareEncoder(require);
    }

    public static boolean requireHardwareDecoder(boolean require) {
        return ZegoLiveRoomJNI.requireHardwareDecoder(require);
    }

    public static boolean setPlayQualityMonitorCycle(long timeInMS) {
        return ZegoLiveRoomJNI.setPlayQualityMonitorCycle(timeInMS);
    }

    public static boolean setPublishQualityMonitorCycle(long timeInMS) {
        return ZegoLiveRoomJNI.setPublishQualityMonitorCycle(timeInMS);
    }

    public boolean setAudioEqualizerGain(int bandIndex, float bandGain) {
        return ZegoLiveRoomJNI.setAudioEqualizerGain(bandIndex, bandGain);
    }

    @Deprecated
    public static void enableAudioPrep2(boolean enable, ZegoExtPrepSet set) {
        ZegoLiveRoomJNI.enableAudioPrep2(enable, set);
    }

    public void setAudioPrepCallback(IZegoAudioPrepCallback2 callback, ZegoExtPrepSet config) {
        this.mZegoAudioPrepCB = callback;
        ZegoLiveRoomJNI.setAudioPrepCallback(callback != null, config);
    }

    public void setAudioPostpCallback(IZegoAudioPostpCallback callback, ZegoExtPrepSet config) {
        this.mZegoAudioPostpCB = callback;
        ZegoLiveRoomJNI.setAudioPostpCallback(callback != null, config);
    }

    public void enableAudioPostp(boolean enable, String streamId) {
        ZegoLiveRoomJNI.enableAudioPostp(enable, streamId);
    }

    public boolean setAudioBitrate(int bitrate) {
        return ZegoLiveRoomJNI.setAudioBitrate(bitrate);
    }

    public void enableAGC(boolean enable) {
        ZegoLiveRoomJNI.enableAGC(enable);
    }

    public void enableAEC(boolean enable) {
        ZegoLiveRoomJNI.enableAEC(enable);
    }

    public void setAECMode(int mode) {
        ZegoLiveRoomJNI.setAECMode(mode);
    }

    public boolean sendCustomCommand(ZegoUser[] listMember, String content, IZegoCustomCommandCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendCustomCommand] failed, callback is null");
            return false;
        }
        ZegoUser[] listOfLegalUser = this.getListOfLegalUser(listMember);
        if (listOfLegalUser == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendCustomCommand] failed, listMember is empty");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)content)) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendCustomCommand] failed, content is empty");
            return false;
        }
        int requestSeq = ZegoLiveRoomJNI.sendCustomCommand(listOfLegalUser, listOfLegalUser.length, content);
        if (requestSeq != -1) {
            if (this.mMapCustomCommandCallback.get(requestSeq) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_sendCustomCommand], unfinished custom command, seq:" + requestSeq);
            }
            this.mMapCustomCommandCallback.put(requestSeq, callback);
            return true;
        }
        return false;
    }

    @Deprecated
    public void setMediaSideFlags(boolean start, boolean onlyAudioPublish) {
        ZegoLiveRoomJNI.setMediaSideFlags(start, onlyAudioPublish, 0, 0, 0);
    }

    @Deprecated
    public void setMediaSideFlags(boolean start, boolean onlyAudioPublish, int channelIndex) {
        ZegoLiveRoomJNI.setMediaSideFlags(start, onlyAudioPublish, 0, 0, channelIndex);
    }

    @Deprecated
    public void setMediaSideFlags(boolean start, boolean onlyAudioPublish, int mediaInfoType, int seiSendType, int channelIndex) {
        ZegoLiveRoomJNI.setMediaSideFlags(start, onlyAudioPublish, mediaInfoType, seiSendType, channelIndex);
    }

    @Deprecated
    public void sendMediaSideInfo(ByteBuffer inData, int dataLen, boolean packet) {
        ZegoLiveRoomJNI.sendMediaSideInfo(inData, dataLen, packet, 0);
    }

    @Deprecated
    public void sendMediaSideInfo(ByteBuffer inData, int dataLen, boolean packet, int channelIndex) {
        ZegoLiveRoomJNI.sendMediaSideInfo(inData, dataLen, packet, channelIndex);
    }

    public void setPublishConfig(Map<String, Object> config) {
        this.setPublishConfigInner(config, 0);
    }

    public void setPublishConfig(Map<String, Object> config, int channelIndex) {
        this.setPublishConfigInner(config, channelIndex);
    }

    private void setPublishConfigInner(Map<String, Object> config, int channelIndex) {
        String customCDNTarget;
        if (config == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_setPublishConfigInner] invalid params, config is null");
            return;
        }
        String customPublishTarget = (String)config.get("publishCustomTarget");
        if (!TextUtils.isEmpty((CharSequence)customPublishTarget)) {
            ZegoLiveRoomJNI.setPublishConfig(customPublishTarget, channelIndex);
        }
        if (!TextUtils.isEmpty((CharSequence)(customCDNTarget = (String)config.get("publish_cdn_target")))) {
            ZegoLiveRoomJNI.setCDNPublishTarget(customCDNTarget, channelIndex);
        }
    }

    public boolean addPublishTarget(String target, String streamID, IZegoUpdatePublishTargetCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_addPublishTarget] failed, callback is null");
            return false;
        }
        int seq = ZegoLiveRoomJNI.addPublishTarget(target, streamID);
        if (seq != -1) {
            if (this.mMapUpdatePublishTargetCallback.get(seq) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_addPublishTarget], unfinished add publish target, seq:" + seq);
            }
            this.mMapUpdatePublishTargetCallback.put(seq, callback);
            return true;
        }
        ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_addPublishTarget] failed, seq:" + seq);
        return false;
    }

    public boolean deletePublishTarget(String target, String streamID, IZegoUpdatePublishTargetCallback callback) {
        if (callback == null) {
            ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_deletePublishTarget] failed, callback is null");
            return false;
        }
        int seq = ZegoLiveRoomJNI.deletePublishTarget(target, streamID);
        if (seq != -1) {
            if (this.mMapUpdatePublishTargetCallback.get(seq) != null) {
                ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_deletePublishTarget], unfinished delete publish target, seq:" + seq);
            }
            this.mMapUpdatePublishTargetCallback.put(seq, callback);
            return true;
        }
        ZegoLiveRoomJNI.logPrint("[Java_ZegoLiveRoom_deletePublishTarget] failed, seq:" + seq);
        return false;
    }

    @Deprecated
    public void setAuxVolume(int volume) {
        ZegoLiveRoomJNI.setAuxVolume(volume);
    }

    public void enableDTX(boolean enable) {
        ZegoLiveRoomJNI.enableDTX(enable);
    }

    public void enableVAD(boolean enable) {
        ZegoLiveRoomJNI.enableVAD(enable);
    }

    public void enableTrafficControl(int properties, boolean enable) {
        ZegoLiveRoomJNI.enableTrafficControl(properties, enable);
    }

    public void setMinVideoBitrateForTrafficControl(int bitrate, int mode) {
        ZegoLiveRoomJNI.setMinVideoBitrateForTrafficControl(bitrate, mode);
    }

    public static void setAudioDeviceMode(int mode) {
        if (ZegoCommonUtils.isDeviceInBlackList() && (1 == mode || 5 == mode || 5 == mode)) {
            ZegoLiveRoomJNI.setAudioDeviceMode(2);
        } else {
            ZegoLiveRoomJNI.setAudioDeviceMode(mode);
        }
    }

    @TargetApi(value=23)
    public static boolean setAudioDevice(int deviceType, String deviceId) {
        if (deviceType != 0 && deviceType != 1) {
            Log.w((String)"ZEGO", (String)String.format("deviceType: %d invalid when setAudioDevice", deviceType));
            return false;
        }
        return ZegoLiveRoomJNI.setAudioDevice(deviceType, deviceId);
    }

    public static void enableCheckPoc(boolean enable) {
        ZegoLiveRoomJNI.enableCheckPoc(enable);
    }

    @Deprecated
    public static void _logPrint(String strFormat, Object ... args) {
        String message = String.format(strFormat, args);
        ZegoLiveRoomJNI.logPrint(message);
    }

    public boolean enableLoopback(boolean enable) {
        return ZegoLiveRoomJNI.enableLoopback(enable);
    }

    public boolean enableNoiseSuppress(boolean enable) {
        return ZegoLiveRoomJNI.enableNoiseSuppress(enable);
    }

    public boolean setNoiseSuppressMode(int mode) {
        return ZegoLiveRoomJNI.setNoiseSuppressMode(mode);
    }

    public boolean enableTransientNoiseSuppress(boolean enable) {
        return ZegoLiveRoomJNI.enableTransientNoiseSuppress(enable);
    }

    public void pauseModule(int moduleType) {
        ZegoLiveRoomJNI.pauseModule(moduleType);
    }

    public void resumeModule(int moduleType) {
        ZegoLiveRoomJNI.resumeModule(moduleType);
    }

    public void setAudioChannelCount(int count) {
        ZegoLiveRoomJNI.setAudioChannelCount(count);
    }

    public int activateAudioPlayStream(String streamId, boolean active) {
        return ZegoLiveRoomJNI.activateAudioPlayStream(streamId, active);
    }

    public int activateVideoPlayStream(String streamId, boolean active) {
        return ZegoLiveRoomJNI.activateVideoPlayStream(streamId, active, -1);
    }

    public int activateVideoPlayStream(String streamId, boolean active, int videoLayer) {
        return ZegoLiveRoomJNI.activateVideoPlayStream(streamId, active, videoLayer);
    }

    public int muteVideoPublish(boolean mute) {
        return this.muteVideoPublish(mute, 0);
    }

    public int muteVideoPublish(boolean mute, int channelIndex) {
        return ZegoLiveRoomJNI.muteVideoPublish(mute, channelIndex);
    }

    public int muteAudioPublish(boolean mute) {
        return this.muteAudioPublish(mute, 0);
    }

    public int muteAudioPublish(boolean mute, int channelIndex) {
        return ZegoLiveRoomJNI.muteAudioPublish(mute, channelIndex);
    }

    public static void setConfig(String config) {
        ZegoLiveRoomJNI.setConfig(config);
    }

    public void setChannelExtraParam(String param_config, int channelIndex) {
        ZegoLiveRoomJNI.setChannelExtraParam(param_config, channelIndex);
    }

    private static String getServiceUrl(String service) {
        return ZegoLiveRoomJNI.getServiceUrl(service);
    }

    public void enableAECWhenHeadsetDetected(boolean enable) {
        ZegoLiveRoomJNI.enableAECWhenHeadsetDetected(enable);
    }

    @Override
    public void onInitSDK(final int errorCode) {
        final IZegoInitSDKCompletionCallback zegoRoomCallback = this.mZegoInitSDKCallback;
        if (zegoRoomCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoRoomCallback.onInitSDK(errorCode);
                }
            });
        }
    }

    @Override
    public void onLogWillOverwrite() {
        final IZegoLogInfoCallback zegoLogCallback = this.mZegoLogInfoCallback;
        if (zegoLogCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLogCallback.onLogWillOverwrite();
                }
            });
        }
    }

    @Override
    public void onLogUploadResult(final int errorCode) {
        final IZegoLogInfoCallback zegoLogCallback = this.mZegoLogInfoCallback;
        if (zegoLogCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLogCallback.onLogUploadResult(errorCode);
                }
            });
        }
    }

    @Override
    public void onLoginRoom(final int errorCode, String roomID, final ZegoStreamInfo[] listStream) {
        final IZegoLoginCompletionCallback loginCompletionCallback = this.mMapZegoLoginCompletionCallback.get(roomID);
        this.mMapZegoLoginCompletionCallback.remove(roomID);
        if (loginCompletionCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    loginCompletionCallback.onLoginCompletion(errorCode, listStream);
                }
            });
        }
    }

    @Override
    public void onKickOut(final int reason, final String roomID, final String customReason) {
        final IZegoRoomCallback zegoRoomCallback = this.mZegoRoomCallback;
        if (zegoRoomCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoRoomCallback.onKickOut(reason, roomID, customReason);
                }
            });
        }
    }

    @Override
    public void onDisconnect(final int errorCode, final String roomID) {
        final IZegoRoomCallback zegoRoomCallback = this.mZegoRoomCallback;
        if (zegoRoomCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoRoomCallback.onDisconnect(errorCode, roomID);
                }
            });
        }
    }

    @Override
    public void onReconnect(final int errorCode, final String roomID) {
        final IZegoRoomCallback zegoRoomCallback = this.mZegoRoomCallback;
        if (zegoRoomCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoRoomCallback.onReconnect(errorCode, roomID);
                }
            });
        }
    }

    @Override
    public void onTempBroken(final int errorCode, final String roomID) {
        final IZegoRoomCallback zegoRoomCallback = this.mZegoRoomCallback;
        if (zegoRoomCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoRoomCallback.onTempBroken(errorCode, roomID);
                }
            });
        }
    }

    @Override
    public void onStreamUpdated(final int type, final ZegoStreamInfo[] listStream, final String roomID) {
        final IZegoRoomCallback zegoRoomCallback = this.mZegoRoomCallback;
        if (zegoRoomCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoRoomCallback.onStreamUpdated(type, listStream, roomID);
                }
            });
        }
    }

    @Override
    public void onStreamExtraInfoUpdated(final ZegoStreamInfo[] listStream, final String roomID) {
        final IZegoRoomCallback zegoRoomCallback = this.mZegoRoomCallback;
        if (zegoRoomCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoRoomCallback.onStreamExtraInfoUpdated(listStream, roomID);
                }
            });
        }
    }

    @Override
    public void onPlayStateUpdate(final int stateCode, final String streamID) {
        final IZegoLivePlayerCallback zegoLivePlayerCallback = this.mZegoLivePlayerCallback;
        if (zegoLivePlayerCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onPlayStateUpdate(stateCode, streamID);
                }
            });
        }
    }

    @Override
    public void onPlayQualityUpdate(final String streamID, final ZegoPlayStreamQuality streamQuality) {
        final IZegoLivePlayerCallback zegoLivePlayerCallback = this.mZegoLivePlayerCallback;
        if (zegoLivePlayerCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onPlayQualityUpdate(streamID, streamQuality);
                }
            });
        }
    }

    @Override
    public void onJoinLiveResponse(final int result, final String fromUserID, final String fromUserName, int seq) {
        final IZegoResponseCallback joinLiveResponseCallback = this.mJoinLiveResponseCallback;
        if (this.mWaitingJoinLiveResponseSeq == seq && joinLiveResponseCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    joinLiveResponseCallback.onResponse(result, fromUserID, fromUserName);
                }
            });
            this.mJoinLiveResponseCallback = null;
            this.mWaitingJoinLiveResponseSeq = 0;
        }
    }

    @Override
    public void onInviteJoinLiveRequest(final int seq, final String fromUserID, final String fromUserName, final String roomID) {
        final IZegoLivePlayerCallback zegoLivePlayerCallback = this.mZegoLivePlayerCallback;
        if (zegoLivePlayerCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onInviteJoinLiveRequest(seq, fromUserID, fromUserName, roomID);
                }
            });
        }
    }

    @Override
    public void onRecvEndJoinLiveCommand(final String fromUserId, final String fromUserName, final String roomId) {
        final IZegoLivePlayerCallback zegoLivePlayCallback = this.mZegoLivePlayerCallback;
        if (zegoLivePlayCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayCallback.onRecvEndJoinLiveCommand(fromUserId, fromUserName, roomId);
                }
            });
        }
    }

    @Override
    public void onVideoSizeChanged(final String streamID, final int width, final int height) {
        final IZegoLivePlayerCallback zegoLivePlayerCallback = this.mZegoLivePlayerCallback;
        if (zegoLivePlayerCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onVideoSizeChangedTo(streamID, width, height);
                }
            });
        }
    }

    @Override
    public void onRemoteCameraStatusUpdate(final String streamID, final int status, final int reason) {
        IZegoLivePlayerCallback2 zegoLivePlayerCallback;
        if (this.mZegoLivePlayerCallback instanceof IZegoLivePlayerCallback2 && (zegoLivePlayerCallback = (IZegoLivePlayerCallback2)this.mZegoLivePlayerCallback) != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onRemoteCameraStatusUpdate(streamID, status, reason);
                }
            });
        }
    }

    @Override
    public void onRemoteMicStatusUpdate(final String streamID, final int status, final int reason) {
        IZegoLivePlayerCallback2 zegoLivePlayerCallback;
        if (this.mZegoLivePlayerCallback instanceof IZegoLivePlayerCallback2 && (zegoLivePlayerCallback = (IZegoLivePlayerCallback2)this.mZegoLivePlayerCallback) != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onRemoteMicStatusUpdate(streamID, status, reason);
                }
            });
        }
    }

    @Override
    public void onRecvRemoteAudioFirstFrame(final String streamID) {
        IZegoLivePlayerCallback2 zegoLivePlayerCallback;
        if (this.mZegoLivePlayerCallback instanceof IZegoLivePlayerCallback2 && (zegoLivePlayerCallback = (IZegoLivePlayerCallback2)this.mZegoLivePlayerCallback) != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onRecvRemoteAudioFirstFrame(streamID);
                }
            });
        }
    }

    @Override
    public void onRecvRemoteVideoFirstFrame(final String streamID) {
        IZegoLivePlayerCallback2 zegoLivePlayerCallback;
        if (this.mZegoLivePlayerCallback instanceof IZegoLivePlayerCallback2 && (zegoLivePlayerCallback = (IZegoLivePlayerCallback2)this.mZegoLivePlayerCallback) != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onRecvRemoteVideoFirstFrame(streamID);
                }
            });
        }
    }

    @Override
    public void onRenderRemoteVideoFirstFrame(final String streamID) {
        IZegoLivePlayerCallback2 zegoLivePlayerCallback;
        if (this.mZegoLivePlayerCallback instanceof IZegoLivePlayerCallback2 && (zegoLivePlayerCallback = (IZegoLivePlayerCallback2)this.mZegoLivePlayerCallback) != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePlayerCallback.onRenderRemoteVideoFirstFrame(streamID);
                }
            });
        }
    }

    @Override
    public void onSnapshot(final Bitmap img, String streamID) {
        final IZegoSnapshotCompletionCallback zegoSnapshotCompletionCallback = this.mMapStreamSnapshotCompletionCallback.get(streamID);
        if (zegoSnapshotCompletionCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoSnapshotCompletionCallback.onZegoSnapshotCompletion(img);
                }
            });
            this.mMapStreamSnapshotCompletionCallback.remove(streamID);
        }
    }

    @Override
    public void onPublishStateUpdate(final int stateCode, final String streamID, final HashMap<String, Object> streamInfo) {
        final IZegoLivePublisherCallback zegoLivePublisherCallback = this.mZegoLivePublisherCallback;
        if (zegoLivePublisherCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherCallback.onPublishStateUpdate(stateCode, streamID, streamInfo);
                }
            });
        }
    }

    @Override
    public void onRelayCDNStateUpdate(final ZegoStreamRelayCDNInfo[] statesInfo, final String streamID) {
        final IZegoLivePublisherExCallback zegoLivePublisherExCallback = this.mZegoLivePublisherExCallback;
        if (zegoLivePublisherExCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherExCallback.onRelayCDNStateUpdate(statesInfo, streamID);
                }
            });
        }
    }

    @Override
    public void onUpdatePublishTargetState(final int errorCode, final String streamID, int seq) {
        final IZegoUpdatePublishTargetCallback callback = this.mMapUpdatePublishTargetCallback.remove(seq);
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onUpdatePublishTargetState(errorCode, streamID);
                }
            });
        }
    }

    @Override
    public void onJoinLiveRequest(final int seq, final String fromUserID, final String fromUserName, final String roomID) {
        final IZegoLivePublisherCallback zegoLivePublisherCallback = this.mZegoLivePublisherCallback;
        if (zegoLivePublisherCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherCallback.onJoinLiveRequest(seq, fromUserID, fromUserName, roomID);
                }
            });
        }
    }

    @Override
    public void onInviteJoinLiveResponse(final int result, final String fromUserID, final String fromUserName, int seq) {
        final IZegoResponseCallback inviteJoinLiveResponseCallback = this.mInviteJoinLiveResponseCallback;
        if (this.mWaitingInviteJoinLiveResponseSeq == seq && inviteJoinLiveResponseCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    inviteJoinLiveResponseCallback.onResponse(result, fromUserID, fromUserName);
                }
            });
            this.mInviteJoinLiveResponseCallback = null;
            this.mWaitingInviteJoinLiveResponseSeq = 0;
        }
    }

    @Override
    public void onEndJoinLive(final int result, int seq, final String roomID) {
        final IZegoEndJoinLiveCallback zegoEndJoinLiveResponseCallback = this.mMapEndJoinLiveResponseCallback.remove(seq);
        if (zegoEndJoinLiveResponseCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoEndJoinLiveResponseCallback.onEndJoinLive(result, roomID);
                }
            });
        }
    }

    @Override
    public void onPublishQulityUpdate(final String streamID, final ZegoPublishStreamQuality streamQuality) {
        final IZegoLivePublisherCallback zegoLivePublisherCallback = this.mZegoLivePublisherCallback;
        if (zegoLivePublisherCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherCallback.onPublishQualityUpdate(streamID, streamQuality);
                }
            });
        }
    }

    @Override
    public void onCaptureVideoSizeChanged(final int width, final int height) {
        final IZegoLivePublisherCallback zegoLivePublisherCallback = this.mZegoLivePublisherCallback;
        if (zegoLivePublisherCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherCallback.onCaptureVideoSizeChangedTo(width, height);
                }
            });
        }
    }

    @Override
    public void onCaptureVideoSizeChanged(final int channelIndex, final int width, final int height) {
        final IZegoLivePublisherCallback2 zegoLivePublisherCallback2 = this.mZegoLivePublisherCallback2;
        if (zegoLivePublisherCallback2 != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherCallback2.onCaptureVideoSizeChangedTo(channelIndex, width, height);
                }
            });
        }
    }

    @Override
    public void onCaptureVideoFirstFrame() {
        final IZegoLivePublisherCallback zegoLivePublisherCallback = this.mZegoLivePublisherCallback;
        if (zegoLivePublisherCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherCallback.onCaptureVideoFirstFrame();
                }
            });
        }
    }

    @Override
    public void onCaptureVideoFirstFrame(final int channelIndex) {
        final IZegoLivePublisherCallback2 zegoLivePublisherCallback2 = this.mZegoLivePublisherCallback2;
        if (zegoLivePublisherCallback2 != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherCallback2.onCaptureVideoFirstFrame(channelIndex);
                }
            });
        }
    }

    @Override
    public void onCaptureAudioFirstFrame() {
        final IZegoLivePublisherCallback zegoLivePublisherCallback = this.mZegoLivePublisherCallback;
        if (zegoLivePublisherCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLivePublisherCallback.onCaptureAudioFirstFrame();
                }
            });
        }
    }

    @Override
    public void onPreviewSnapshot(final Bitmap img) {
        final IZegoSnapshotCompletionCallback zegoSnapshotCompletionCallback = this.mPreviewSnapshotCompletionCallback;
        if (zegoSnapshotCompletionCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoSnapshotCompletionCallback.onZegoSnapshotCompletion(img);
                }
            });
            this.mPreviewSnapshotCompletionCallback = null;
        }
    }

    @Override
    public void onPreviewSnapshot(final int channelIndex, final Bitmap img) {
        final IZegoSnapshotCompletionCallback2 zegoSnapshotCompletionCallback2 = this.mPreviewSnapshotCompletionCallback2;
        if (zegoSnapshotCompletionCallback2 != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoSnapshotCompletionCallback2.onZegoSnapshotCompletion(channelIndex, img);
                }
            });
            this.mPreviewSnapshotCompletionCallback2 = null;
        }
    }

    @Override
    public void onLiveEvent(final int event, final HashMap<String, String> info) {
        final IZegoLiveEventCallback zegoLiveEventCallback = this.mZegoLiveEventCallback;
        if (zegoLiveEventCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoLiveEventCallback.onLiveEvent(event, info);
                }
            });
        }
    }

    @Override
    public void onDeviceError(final String deviceName, final int errorCode) {
        final IZegoDeviceEventCallback zegoDeviceEventCallback = this.mZegoDeviceEventCallback;
        if (zegoDeviceEventCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoDeviceEventCallback.onDeviceError(deviceName, errorCode);
                }
            });
        }
    }

    @Override
    public int dequeueInputBuffer(int width, int height, int stride) {
        IZegoExternalRenderCallback zegoExternalRenderCallback = this.mZegoExternalRenderCallback;
        if (zegoExternalRenderCallback != null) {
            return zegoExternalRenderCallback.dequeueInputBuffer(width, height, stride);
        }
        return 0;
    }

    @Override
    public ByteBuffer getInputBuffer(int index) {
        IZegoExternalRenderCallback zegoExternalRenderCallback = this.mZegoExternalRenderCallback;
        if (zegoExternalRenderCallback != null) {
            return zegoExternalRenderCallback.getInputBuffer(index);
        }
        return null;
    }

    @Override
    public void queueInputBuffer(int bufferIndex, String streamID, int width, int height, int stride) {
        IZegoExternalRenderCallback zegoExternalRenderCallback = this.mZegoExternalRenderCallback;
        if (zegoExternalRenderCallback != null) {
            zegoExternalRenderCallback.queueInputBuffer(bufferIndex, streamID, width, height, stride);
        }
    }

    @Override
    public void onAudioRecordCallback(final byte[] data, final int sampleRate, final int channelCount, final int bitDepth, final int type) {
        final IZegoAudioRecordCallback2 cb2 = this.mZegoAudioRecordCallback2;
        if (cb2 != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    cb2.onAudioRecordCallback(data, sampleRate, channelCount, bitDepth, type);
                }
            });
        } else {
            final IZegoAudioRecordCallback zegoAudioRecordCallback = this.mZegoAudioRecordCallback;
            if (zegoAudioRecordCallback != null) {
                this.mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zegoAudioRecordCallback.onAudioRecordCallback(data, sampleRate, channelCount, bitDepth);
                    }
                });
            }
        }
    }

    @Override
    @Deprecated
    public void onAudioPrep(ByteBuffer inData, int sampleCount, int bitDepth, int sampleRate, ByteBuffer outData) {
        IZegoAudioPrepCallback zegoAudioPrepCallback = this.mZegoAudioPrepCallback;
        if (zegoAudioPrepCallback != null) {
            zegoAudioPrepCallback.onAudioPrep(inData, sampleCount, bitDepth, sampleRate, outData);
        }
    }

    @Override
    @Deprecated
    public ZegoAudioFrame onAudioPrep2(ZegoAudioFrame inFrame) {
        IZegoAudioPrepCallback2 zegoAudioPrepCallback2 = this.mZegoAudioPrepCallback2;
        if (zegoAudioPrepCallback2 != null) {
            return zegoAudioPrepCallback2.onAudioPrep(inFrame);
        }
        return inFrame;
    }

    @Override
    public ZegoAudioFrame onAudioPrep(ZegoAudioFrame inFrame) {
        IZegoAudioPrepCallback2 audioPrepCallback = this.mZegoAudioPrepCB;
        if (audioPrepCallback != null) {
            return audioPrepCallback.onAudioPrep(inFrame);
        }
        return inFrame;
    }

    @Override
    public ZegoAudioFrame onAudioPostp(ZegoAudioFrame inFrame, String streamId) {
        IZegoAudioPostpCallback audioPostpCallback = this.mZegoAudioPostpCB;
        if (audioPostpCallback != null) {
            return audioPostpCallback.onAudioPostp(inFrame, streamId);
        }
        return inFrame;
    }

    @Override
    public void onCustomCommand(final int errorCode, int requestSeq, final String roomID) {
        final IZegoCustomCommandCallback customCommandCallback = this.mMapCustomCommandCallback.get(requestSeq);
        if (customCommandCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    customCommandCallback.onSendCustomCommand(errorCode, roomID);
                }
            });
            this.mMapCustomCommandCallback.remove(requestSeq);
        }
    }

    @Override
    public void onRecvCustomCommand(final String userID, final String userName, final String content, final String roomID) {
        final IZegoRoomCallback zegoRoomCallback = this.mZegoRoomCallback;
        if (zegoRoomCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoRoomCallback.onRecvCustomCommand(userID, userName, content, roomID);
                }
            });
        }
    }

    @Override
    public void onMediaSideCallback(String streamID, ByteBuffer inData, int dataLen) {
        IZegoMediaSideCallback callback = this.mZegoMediaSideCallback;
        if (callback != null) {
            callback.onRecvMediaSideInfo(streamID, inData, dataLen);
        }
    }

    @Override
    public void onAVEngineStart() {
        final IZegoAVEngineCallback callback = this.mZegoAVEngineCallback;
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onAVEngineStart();
                }
            });
        }
    }

    @Override
    public void onAVEngineStop() {
        final IZegoAVEngineCallback callback = this.mZegoAVEngineCallback;
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onAVEngineStop();
                }
            });
        }
    }

    @Override
    public void onUserUpdate(final ZegoUserState[] listUser, final int updateType) {
        final IZegoIMCallback zegoIMCallback = this.mZegoIMCallback;
        if (zegoIMCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoIMCallback.onUserUpdate(listUser, updateType);
                }
            });
        }
    }

    @Override
    public void onUpdateOnlineCount(final String roomID, final int onlineCount) {
        final IZegoIMCallback zegoIMCallback = this.mZegoIMCallback;
        if (zegoIMCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoIMCallback.onUpdateOnlineCount(roomID, onlineCount);
                }
            });
        }
    }

    @Override
    public void onSendRoomMessage(final int errorCode, final String roomID, int sendSeq, final long messageID) {
        final IZegoRoomMessageCallback callback = (IZegoRoomMessageCallback)this.mMapIMCallback.get(sendSeq);
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onSendRoomMessage(errorCode, roomID, messageID);
                }
            });
            this.mMapIMCallback.remove(sendSeq);
        }
    }

    @Override
    public void onSendBigRoomMessage(final int errorCode, final String roomID, int sendSeq, final String messageID) {
        final IZegoBigRoomMessageCallback callback = (IZegoBigRoomMessageCallback)this.mMapIMCallback.get(sendSeq);
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onSendBigRoomMessage(errorCode, roomID, messageID);
                }
            });
            this.mMapIMCallback.remove(sendSeq);
        }
    }

    @Override
    public void onRecvRoomMessage(final String roomID, final ZegoRoomMessage[] listMessage) {
        final IZegoIMCallback zegoIMCallback = this.mZegoIMCallback;
        if (zegoIMCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoIMCallback.onRecvRoomMessage(roomID, listMessage);
                }
            });
        }
    }

    @Override
    public void onRecvBigRoomMessage(final String roomID, final ZegoBigRoomMessage[] listMessage) {
        final IZegoIMCallback zegoIMCallback = this.mZegoIMCallback;
        if (zegoIMCallback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    zegoIMCallback.onRecvBigRoomMessage(roomID, listMessage);
                }
            });
        }
    }

    @Override
    public void onRecvReliableMessage(final String roomId, final ZegoReliableMessage message) {
        final IZegoReliableMessageCallback callback = this.mZegoReliableMessageCallback;
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onRecvReliableMessage(roomId, message);
                }
            });
        }
    }

    @Override
    public void onSendReliableMessage(final int errorCode, int sendSeq, final String roomId, final String type, final long seq) {
        final IZegoSendReliableMessageCallback callback = this.mMapSendReliableMessageCallback.remove(sendSeq);
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onSendReliableMessage(errorCode, roomId, type, seq);
                }
            });
        }
    }

    @Override
    public void onGetReliableMessage(final int errorCode, int sendSeq, final String roomId, final ZegoReliableMessage[] messageList) {
        final IZegoGetReliableMessageCallback callback = this.mMapGetReliableMessageCallback.remove(sendSeq);
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onGetReliableMessage(errorCode, roomId, messageList);
                }
            });
        }
    }

    @Override
    public void onUpdateReliableMessageInfo(final String roomId, final ZegoReliableMessageInfo[] messageInfList) {
        final IZegoReliableMessageCallback callback = this.mZegoReliableMessageCallback;
        if (callback != null) {
            this.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onUpdateReliableMessageInfo(roomId, messageInfList);
                }
            });
        }
    }

    public static interface SDKContextEx
    extends SDKContext {
        public long getLogFileSize();

        @Nullable
        public String getSubLogFolder();
    }

    public static interface SDKContext {
        @Nullable
        public String getSoFullPath();

        @Nullable
        public String getLogPath();

        @NonNull
        public Application getAppContext();
    }
}

