/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.videorender;

import com.zego.zegoavkit2.entities.EncodedVideoFrame;
import com.zego.zegoavkit2.entities.VideoFrame;
import com.zego.zegoavkit2.enums.VideoCodecType;
import com.zego.zegoavkit2.enums.VideoPixelFormat;
import com.zego.zegoavkit2.videorender.IZegoExternalRenderCallback2;
import com.zego.zegoavkit2.videorender.IZegoExternalRenderCallback3;
import com.zego.zegoavkit2.videorender.IZegoVideoDecodeCallback;
import com.zego.zegoavkit2.videorender.IZegoVideoRenderCallback;
import java.nio.ByteBuffer;

final class ZegoExternalVideoRenderJNI {
    private static volatile IZegoExternalRenderCallback2 externalRenderCallback2 = null;
    private static volatile IZegoExternalRenderCallback3 externalRenderCallback3 = null;
    private static volatile IZegoVideoRenderCallback s_ZegoVideoRenderCallback = null;
    private static volatile IZegoVideoDecodeCallback s_ZegoVideoDecodeCallback = null;

    ZegoExternalVideoRenderJNI() {
    }

    public static void setJNIVideoExternalVideoCallback(IZegoExternalRenderCallback2 callback) {
        externalRenderCallback2 = callback;
    }

    public static void setJNIVideoExternalVideoCallback3(IZegoExternalRenderCallback3 callback) {
        externalRenderCallback3 = callback;
    }

    public static void setVideoRenderCallback(IZegoVideoRenderCallback callback) {
        s_ZegoVideoRenderCallback = callback;
        ZegoExternalVideoRenderJNI.setNativeVideoRenderCallback(callback != null);
    }

    public static void setVideoDecodeCallback(IZegoVideoDecodeCallback callback) {
        s_ZegoVideoDecodeCallback = callback;
        ZegoExternalVideoRenderJNI.setNativeVideoDecodeCallback(callback != null);
    }

    public static native void setVideoRenderType(int var0);

    public static native void enableExternalRender(boolean var0, int var1);

    public static native boolean enableVideoRender(boolean var0, String var1);

    public static native boolean enableVideoPreview(boolean var0, int var1);

    private static native void setNativeVideoRenderCallback(boolean var0);

    private static native void setNativeVideoDecodeCallback(boolean var0);

    public static void queueInputBuffer(int bufferIndex, String streamID, int videoPixelFormat) {
        if (externalRenderCallback2 != null) {
            externalRenderCallback2.queueInputBuffer(bufferIndex, streamID, VideoPixelFormat.valueOf(videoPixelFormat));
        } else if (externalRenderCallback3 != null) {
            externalRenderCallback3.queueInputBuffer(bufferIndex, streamID, VideoPixelFormat.valueOf(videoPixelFormat));
        }
    }

    public static VideoFrame getInputBuffer(int index, String streamID) {
        if (externalRenderCallback2 != null) {
            return externalRenderCallback2.getInputBuffer(index);
        }
        if (externalRenderCallback3 != null) {
            return externalRenderCallback3.getInputBuffer(index, streamID);
        }
        return null;
    }

    public static int dequeueInputBuffer(int width, int height, int[] strides, int[] byteBufferLens, String streamID) {
        if (externalRenderCallback2 != null) {
            return externalRenderCallback2.dequeueInputBuffer(width, height, strides, byteBufferLens);
        }
        if (externalRenderCallback3 != null) {
            return externalRenderCallback3.dequeueInputBuffer(width, height, strides, byteBufferLens, streamID);
        }
        return -1;
    }

    @Deprecated
    public static void setFlipModeCompatible(String streamID, int mode) {
        if (externalRenderCallback2 != null) {
            externalRenderCallback2.setFlipMode(streamID, mode);
        } else if (externalRenderCallback3 != null) {
            externalRenderCallback3.setFlipMode(streamID, mode);
        }
    }

    public static void setFlipMode(String streamID, int mode) {
        if (s_ZegoVideoRenderCallback != null) {
            s_ZegoVideoRenderCallback.setFlipMode(streamID, mode);
        }
    }

    public static void setRotation(String streamID, int rotation) {
        if (s_ZegoVideoRenderCallback != null) {
            s_ZegoVideoRenderCallback.setRotation(streamID, rotation);
        }
    }

    public static void onVideoRenderCallback(ByteBuffer[] data, int[] strides, int width, int height, int videoPixelFormat, String streamID) {
        if (s_ZegoVideoRenderCallback != null) {
            VideoFrame videoFrame = new VideoFrame();
            for (int i = 0; i < videoFrame.byteBuffers.length; ++i) {
                videoFrame.byteBuffers[i] = data[i];
                videoFrame.strides[i] = strides[i];
            }
            videoFrame.width = width;
            videoFrame.height = height;
            VideoPixelFormat pixelFormat = VideoPixelFormat.valueOf(videoPixelFormat);
            s_ZegoVideoRenderCallback.onVideoRenderCallback(videoFrame, pixelFormat, streamID);
        }
    }

    public static void onVideoDecodeCallback(ByteBuffer data, int codecType, boolean b_keyframe, double reference_time_ms, int rotation, String streamID) {
        if (s_ZegoVideoDecodeCallback != null) {
            EncodedVideoFrame videoFrame = new EncodedVideoFrame();
            videoFrame.data = data;
            videoFrame.codecType = VideoCodecType.valueOf(codecType);
            videoFrame.isKeyFrame = b_keyframe;
            videoFrame.reference_time_ms = reference_time_ms;
            videoFrame.rotation = rotation;
            s_ZegoVideoDecodeCallback.onVideoDecodeCallback(videoFrame, streamID);
        }
    }
}

