/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.soundlevel;

import android.os.Handler;
import android.os.Looper;
import com.zego.zegoavkit2.soundlevel.IZegoSoundLevelCallback;
import com.zego.zegoavkit2.soundlevel.ZegoSoundLevelInfo;

final class ZegoSoundLevelJNI {
    private IZegoSoundLevelCallback mCallback = null;
    private Handler mHandler = null;

    ZegoSoundLevelJNI() {
    }

    public void setCallback(IZegoSoundLevelCallback callback) {
        this.mCallback = callback;
        if (callback != null) {
            if (this.mHandler == null) {
                this.mHandler = new Handler(Looper.getMainLooper());
            }
        } else if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
    }

    public void onSoundLevelUpdate(final ZegoSoundLevelInfo[] infos) {
        Handler handler = this.mHandler;
        final IZegoSoundLevelCallback callback = this.mCallback;
        if (handler == null || callback == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                callback.onSoundLevelUpdate(infos);
            }
        });
    }

    public void onCaptureSoundLevelUpdate(final ZegoSoundLevelInfo info) {
        Handler handler = this.mHandler;
        final IZegoSoundLevelCallback callback = this.mCallback;
        if (handler == null || callback == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                callback.onCaptureSoundLevelUpdate(info);
            }
        });
    }

    public native boolean setCycle(int var1);

    public native boolean start();

    public native boolean stop();
}

